/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.precomputation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cmd.precomputation.NodeTempVariable;
import kd.bos.workflow.engine.impl.cmd.precomputation.PercomputatorUtils;
import kd.bos.workflow.engine.impl.cmd.precomputation.impl.DefaultPrecomputatorCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;

public class UserTaskPercomputator
extends DefaultPrecomputatorCmd {
    public UserTaskPercomputator(Long procinstId) {
        super(procinstId);
    }

    @Override
    public void through(CommandContext commandContext, ExecutionEntity execution, FlowNode flowNode) {
        Exception error = null;
        Map<String, NodeTempVariable> tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap();
        NodeTempVariable var = tempVariableMap.containsKey(flowNode.getId()) ? tempVariableMap.get(flowNode.getId()) : new NodeTempVariable();
        tempVariableMap.putIfAbsent(flowNode.getId(), var);
        var.setCurrentFlowElement(flowNode);
        var.setNodeId(flowNode.getId());
        UserTask userTask = (UserTask)flowNode;
        String flowNodeId = userTask.getId();
        List<Long> participants = new ArrayList<Long>();
        TaskEntity task = execution.getCurrentTask();
        if (task == null || !task.getTaskDefinitionKey().equals(flowNodeId)) {
            task = PercomputatorUtils.getNodeTask(flowNode, execution);
            logger.debug(String.format("\u521b\u5efa\u8282\u70b9%s\u7684\u4efb\u52a1", flowNodeId));
        }
        if (task == null) {
            logger.warn("\u4efb\u52a1\u4e3a\u7a7a\uff0c\u505c\u6b62\u6d41\u8f6c\uff01");
            this.stopContinue();
            return;
        }
        var.setCurrentTask(task);
        execution.setTransientVariable("percomputation_currentnode", flowNode.getId());
        task.setTransientVariable("percomputation_ctx", tempVariableMap);
        execution.setCurrentTaskOnly(task);
        this.recordAfterAuditNodeSet(flowNode, task, new ArrayList<Long>(task.getParticipants()), execution);
        if (task.getExecution() instanceof ExecutionEntityImpl) {
            task.setExecution(execution);
            DecisionOption approveDecision = (DecisionOption)this.entryNodeMsg.get("decisionOption");
            if (approveDecision == null) {
                approveDecision = this.getApproveDecision(userTask);
            }
            participants.addAll(task.getParticipants());
            logger.debug(String.format("%s\u4e3a\u5f53\u524d\u8282\u70b9\uff0c\u4ee5\u4eba\u5de5\u5904\u7406\u79bb\u5f00\uff0c\u53c2\u4e0e\u4eba=\u5904\u7406\u4eba=%s\uff0c\u6267\u884c\u7c7b\u578b%s\uff0c\u51b3\u7b56\u9879%s", flowNodeId, WfUtils.listToString(participants, ","), "byHand", approveDecision.getNumber()));
            this.setApprovalResult(userTask, participants, participants, approveDecision, "byHand", execution);
            this.stopCalculator(userTask);
        } else {
            ParticipantCalculator participantCalculator = commandContext.getProcessEngineConfiguration().getParticipantCalculator();
            try {
                boolean isSubmitNode = this.isSubmit(userTask);
                if (isSubmitNode && !this.result.isEmpty()) {
                    participants.add(execution.getCreatorId());
                    logger.debug(String.format("\u7b2c\u4e00\u4e2a\u4eba\u5de5\u8282\u70b9\u53c2\u4e0e\u4eba\u8bbe\u7f6e\u4e3a\u53d1\u8d77\u4eba%s", execution.getCreatorId()));
                } else {
                    participants = participantCalculator.getUserIds(execution.getProcessInstanceId(), flowNodeId, execution.getBusinessKey(), execution, false);
                    logger.debug(String.format("\u8ba1\u7b97\u51fa\u53c2\u4e0e\u4eba\u4e3a%s", WfUtils.listToString(participants, ",")));
                    if (participants.isEmpty() && isSubmitNode && execution.getCreatorId() != null) {
                        participants.add(execution.getCreatorId());
                        logger.debug(String.format("\u63d0\u4ea4\u8282\u70b9\u8ba1\u7b97\u4e0d\u5230\u53c2\u4e0e\u4eba\uff0c\u53c2\u4e0e\u4eba\u5e94\u8be5\u4e3a\u5355\u636e\u521b\u5efa\u4eba%s", execution.getCreatorId()));
                    }
                    if (participants.isEmpty()) {
                        logger.debug("\u8282\u70b9" + flowNode.getName() + "(" + flowNode.getNumber() + ")\u672a\u627e\u5230\u53c2\u4e0e\u4eba");
                    }
                }
            }
            catch (Exception e) {
                logger.error(WfUtils.getExceptionStacktrace(e));
                error = e;
            }
            TaskBehaviorUtil.updateParticipantVariable(task, participants, userTask.getParticipant() != null && userTask.getParticipant().isAllowNoneParticipant());
            boolean rejectBackNotSkip = DynamicFlowUtil.rejectBackNotSkip(execution, flowNode.getId());
            if (!rejectBackNotSkip && this.isSkipTask(userTask, task, participants)) {
                logger.debug("\u8bbe\u7f6e\u8df3\u8fc7\u7ed3\u679c");
                this.setSkipResult(flowNode, participants, execution);
            } else {
                logger.debug("\u8bbe\u7f6e\u4eba\u4e3a\u5ba1\u6279\u7ed3\u679c");
                DecisionOption approveDecision = this.getApproveDecision(userTask);
                this.doApprove(userTask, task, execution, participants, approveDecision);
            }
            if (error != null && !this.result.isEmpty()) {
                for (IPreComputorRecordItem item : this.result) {
                    if (!flowNode.getId().equals(item.getNodeId())) continue;
                    item.setErrType("participantError");
                    item.setErrMsg(WfUtils.getPromptWordLocaleString(String.format("\u53c2\u4e0e\u4eba\u8ba1\u7b97\u5f02\u5e38%s", error.getMessage()), "UserTaskPercomputator_0", "bos-wf-engine"));
                    item.setExceptionMsg(error.getMessage());
                    item.setIsNormal(Boolean.valueOf(false));
                    break;
                }
            }
        }
    }

    protected void setApprovalResult(FlowElement flowNode, List<Long> participants, List<Long> assigneeIds, DecisionOption adapterDecision, String executionType, ExecutionEntity execution) {
        PercomputatorUtils.addNodeDesc(flowNode.getId(), adapterDecision.getNumber(), "approve", assigneeIds, executionType, (PreComputatorExecutionEntityImpl)execution);
        executionType = this.isSubmit(flowNode) != false ? "skip" : executionType;
        String status = "stopWhenFirstApprove".equals(this.model) && this.prepareNode.contains(flowNode.getId()) ? "current" : executionType;
        this.addNodeResult(flowNode, participants, adapterDecision.getNumber(), status);
    }

    @Override
    public List<FlowNode> getNextNodes(CommandContext commandContext, ExecutionEntity execution, FlowNode flowNode) {
        UserTask userTask = (UserTask)flowNode;
        boolean isRejectBackToNode = this.getRejectBackToNode(commandContext, execution);
        TaskEntity currentTask = execution.getCurrentTask();
        Long currentActInstId = execution.getCurrentActInstId();
        logger.debug("execution " + execution.getId() + "/" + currentActInstId);
        if (isRejectBackToNode || userTask.isBackRejectedActivity() && currentTask != null && "dismissed".equals(currentTask.getHandleState()) && WfUtils.isNotEmpty(currentActInstId)) {
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            String rejectNodeId = "";
            if (isRejectBackToNode) {
                execution.setVariable("rejectBackToNode", null);
                rejectNodeId = taskHelper.getRejectIdForRejectBackToNode(commandContext, currentTask);
            } else {
                rejectNodeId = taskHelper.getRejectNodeId(execution.getProcessInstanceId(), currentActInstId);
            }
            ArrayList<FlowNode> nextNodes = new ArrayList<FlowNode>(1);
            if (StringUtils.isNotBlank((CharSequence)rejectNodeId)) {
                AuditTask f = (AuditTask)this.process.getFlowElement(rejectNodeId);
                Map<String, NodeForkJoinModel> models = this.process.getForkJoinModels();
                Boolean join = f.getJoin();
                Boolean showRejectBackToNode = this.isEnableRejectBack(userTask, f, models, isRejectBackToNode, execution);
                if (join.booleanValue() || !showRejectBackToNode.booleanValue()) {
                    return super.getNextNodes(commandContext, execution, flowNode);
                }
                if (models.get(rejectNodeId).getForkStructure().contains(models.get(userTask.getId()).getForkStructure() + "$")) {
                    return super.getNextNodes(commandContext, execution, flowNode);
                }
                this.addNodeResult(f, Collections.emptyList(), "", "through");
                UserTaskPercomputator.transferVariablesToTemp(execution, flowNode.getId(), rejectNodeId, "rejectBackToNode");
                nextNodes.add(f);
            }
            return nextNodes;
        }
        return super.getNextNodes(commandContext, execution, flowNode);
    }

    private static void transferVariablesToTemp(ExecutionEntity execution, String curNode, String nextNodeId, String dynType) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("srcNode", curNode);
        param.put("dynToNode", nextNodeId);
        param.put("dynType", dynType);
        Map<String, NodeTempVariable> tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap();
        NodeTempVariable var = new NodeTempVariable();
        var.setNodeId(SerializationUtils.toJsonString(param));
        tempVariableMap.put("dynToNode", var);
    }

    private boolean getRejectBackToNode(CommandContext commandContext, ExecutionEntity execution) {
        boolean isRejectBackToNode;
        Object rejectBackToNode = execution.getVariable("rejectBackToNode");
        boolean bl = isRejectBackToNode = rejectBackToNode != null && "true".equals(rejectBackToNode);
        if (isRejectBackToNode) {
            TaskEntity currentTask = execution.getCurrentTask();
            if (currentTask != null && "YunzhijiaTask".equals(currentTask.getCategory())) {
                Long parentTaskId = WfUtils.isNotEmpty(currentTask.getParentTaskId()) ? currentTask.getParentTaskId() : currentTask.getId();
                List<TaskEntity> taskEntities = commandContext.getTaskEntityManager().findTasksByParentTaskId(parentTaskId);
                if (taskEntities == null || taskEntities.isEmpty() || taskEntities != null && !taskEntities.isEmpty() && !"dismissed".equals(taskEntities.get(0).getHandleState())) {
                    isRejectBackToNode = false;
                }
            } else if (currentTask != null && !"dismissed".equals(currentTask.getHandleState())) {
                isRejectBackToNode = false;
            }
        }
        return isRejectBackToNode;
    }

    private Boolean isEnableRejectBack(UserTask userTask, AuditTask rejectNode, Map<String, NodeForkJoinModel> models, boolean isRejectBackToNode, ExecutionEntity executionEntity) {
        boolean allowerRejectBackToNode;
        String currentNodeId = userTask.getId();
        String rejectNodeId = rejectNode.getId();
        Object alloReject = executionEntity.getVariable("allowRejectAndGoBack");
        boolean bl = allowerRejectBackToNode = alloReject == null ? rejectNode.isAllowRejectAndGoBack() : "true".equals(alloReject);
        Boolean showRejectBackToNode = userTask.getType().equals("UserTask") && userTask.isBackRejectedActivity() && (allowerRejectBackToNode && isRejectBackToNode || !allowerRejectBackToNode) ? Boolean.TRUE : (allowerRejectBackToNode && isRejectBackToNode && models.get(currentNodeId).getForkStructure().equals(models.get(rejectNodeId).getForkStructure()) ? Boolean.TRUE : Boolean.FALSE);
        return showRejectBackToNode;
    }

    public void doApprove(UserTask userTask, TaskEntity task, ExecutionEntity execution, List<Long> participants, DecisionOption approveDecision) {
        this.setApprovalResult(userTask, participants, participants, approveDecision, "byHand", execution);
        if (!this.isSubmit(userTask).booleanValue() || this.result.isEmpty()) {
            this.stopCalculator(userTask);
        }
    }

    protected boolean isSkipTask(UserTask userTask, TaskEntity task, List<Long> userIds) {
        if (userTask.getParticipant() != null && userTask.getParticipant().isSkipNodeWithoutPart() && userIds.isEmpty()) {
            return true;
        }
        if (DynamicFlowUtil.skipRejectInnerAfterNode(task.getExecution(), userTask, false)) {
            return true;
        }
        if (ConditionUtil.isConditionAvailable(userTask.getSkipCondition())) {
            String expression;
            ConditionalRuleEntity condition;
            if ("afteraudit".equals(this.model) && (condition = userTask.getSkipCondition()) != null && WfUtils.isNotEmpty(expression = condition.getExpression())) {
                for (String skipExpression : this.afterAuditNodeSet) {
                    if (!expression.contains(skipExpression)) continue;
                    logger.debug("\u6761\u4ef6\u8868\u8fbe\u5f0f" + expression + "\u4f7f\u7528\u4e86\u540e\u5ba1\u8282\u70b9\u7684\u6d41\u7a0b\u5c5e\u6027");
                    ILocaleString lString = WfUtils.getPromptWordLocaleString(String.format("\u8282\u70b9\u201c%1$s(%2$s)\u201d\u8df3\u8fc7\u6761\u4ef6\u5e94\u7528\u4e86\u540e\u5ba1\u8282\u70b9\u7684\u6d41\u7a0b\u5c5e\u6027\uff1a\u201c%3$s\u201d\u3002", userTask.getName(), userTask.getNumber(), skipExpression), "UserTaskPercomputator_1", "bos-wf-engine");
                    this.addErrNodeResult(userTask, "afteraudit", lString, "");
                    this.stopContinue();
                    break;
                }
            }
            return ConditionUtil.hasTrueCondition(userTask.getSkipCondition(), (VariableScope)task, "percomputator-isSkipTask");
        }
        return false;
    }

    private Boolean isSubmit(FlowElement userTask) {
        boolean first = false;
        if (BpmnModelUtil.instanceofUserTask(userTask.getType()) && ((UserTask)userTask).getIncomingFlows() != null) {
            List<SequenceFlow> tmp = ((UserTask)userTask).getIncomingFlows();
            for (SequenceFlow seq : tmp) {
                if (seq == null || seq.isDynamic() || !(seq.getSourceFlowElement() instanceof StartEvent)) continue;
                first = true;
                break;
            }
        }
        return first;
    }

    protected DecisionOption getApproveDecision(UserTask userTask) {
        List<DecisionOption> options = userTask.getDecisionOptions();
        if (options.isEmpty()) {
            return null;
        }
        return options.get(0);
    }

    private void recordAfterAuditNodeSet(FlowNode auditTask, TaskEntity task, List<Long> participants, ExecutionEntity execution) {
        if (!"afteraudit".equals(this.model)) {
            return;
        }
        if (!(auditTask instanceof AuditTask) || auditTask instanceof YunzhijiaTask) {
            return;
        }
        if (participants == null || new HashSet<Long>(participants).size() != 1) {
            return;
        }
        if (this.keyAuditorSet.contains(0L) || this.keyAuditorSet.contains(participants.get(0))) {
            String pre = String.format("proc.%s_%s", this.process.getNumber(), auditTask.getNumber());
            this.afterAuditNodeSet.add(pre + "AuditNumber");
            this.afterAuditNodeSet.add(pre + "Comment");
            this.afterAuditNodeSet.add(pre + "ExecutionType");
            this.afterAuditNodeSet.add(pre + "Assignee");
        }
    }
}

