/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.precomputation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.AuditRuleForYzjUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.GetLastAuditParticipantsCmd;
import kd.bos.workflow.engine.impl.cmd.precomputation.PercomputatorUtils;
import kd.bos.workflow.engine.impl.cmd.precomputation.impl.AuditTaskPercomputator;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;

public class YzjTaskPercomputator
extends AuditTaskPercomputator {
    public YzjTaskPercomputator(Long procinstId) {
        super(procinstId);
    }

    @Override
    public void doApprove(UserTask userTask, TaskEntity task, ExecutionEntity execution, List<Long> participants, DecisionOption approveDecision) {
        Object autoApprovePersonCollection = new ArrayList<Long>();
        YunzhijiaTask yzjTask = (YunzhijiaTask)userTask;
        DecisionOption defaultDecision = WfUtils.getDefaultDecision(yzjTask);
        String executionType = "byHand";
        boolean isAutoAuditWhenSamePerson = this.process.getAutoAuditWhenSamePerson();
        boolean isNoNeedCountersign = yzjTask.isNoNeedCountersign();
        Object assigneeIds = new ArrayList<Long>();
        boolean rejectBackNotSkip = DynamicFlowUtil.rejectBackNotSkip(execution, userTask.getId());
        if (!rejectBackNotSkip) {
            if (isNoNeedCountersign) {
                autoApprovePersonCollection = new GetLastAuditParticipantsCmd(execution.getProcessInstanceId(), yzjTask.getId(), "approve", null).execute(this.commandContext);
                if (AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign(execution, yzjTask, participants.size(), this.commandContext, null)) {
                    executionType = "byAuto";
                    assigneeIds = autoApprovePersonCollection;
                    logger.debug(String.format("\u8282\u70b9%s\u7b26\u5408\u540c\u610f\u65e0\u9700\u518d\u6b21\u56de\u8fc1\uff0c\u5904\u7406\u4eba%s\uff0c\u51b3\u7b56\u9879%s\uff0c\u6267\u884c\u7c7b\u578b%s", yzjTask.getId(), participants, defaultDecision.getNumber(), executionType));
                    this.setApprovalResult(yzjTask, participants, (List<Long>)assigneeIds, defaultDecision, executionType, execution);
                    return;
                }
            }
            if (this.isYZJRepeater(yzjTask, task, participants, execution, approveDecision, (List<Long>)autoApprovePersonCollection)) {
                executionType = "byAuto";
                defaultDecision.setAuditType("approve");
                defaultDecision.setNumber("Consent");
                logger.debug(String.format("\u8282\u70b9%s\u7b26\u5408\u91cd\u590d\u5ba1\u6279\u4eba\uff0c\u5904\u7406\u4eba%s\uff0c\u51b3\u7b56\u9879%s\uff0c\u6267\u884c\u7c7b\u578b%s", yzjTask.getId(), "TODO", "approve", executionType));
                this.setApprovalResult(yzjTask, participants, (List<Long>)assigneeIds, defaultDecision, executionType, execution);
                return;
            }
            if ("approve".equals(defaultDecision.getAuditType())) {
                if (isAutoAuditWhenSamePerson && WfUtils.isNotEmptyForCollection(participants) && WfUtils.isNotEmpty(execution.getStartUserId()) && participants.contains(execution.getStartUserId())) {
                    if (!autoApprovePersonCollection.contains(execution.getStartUserId())) {
                        autoApprovePersonCollection.add(execution.getStartUserId());
                    }
                    if (this.isStarterSameAsYzjAuditor(execution.getStartUserId(), yzjTask, defaultDecision, participants)) {
                        executionType = "byAuto";
                        assigneeIds = new ArrayList<Long>();
                        assigneeIds.add((Long)execution.getStartUserId());
                        logger.debug(String.format("\u8282\u70b9%s\u7b26\u5408\u4e1a\u52a1\u63d0\u5355\u4eba\u76f8\u540c\u81ea\u52a8\u5ba1\u6279\uff0c\u5904\u7406\u4eba%s\uff0c\u51b3\u7b56\u9879%s\uff0c\u6267\u884c\u7c7b\u578b%s", yzjTask.getId(), task.getStarterId(), defaultDecision.getNumber(), executionType));
                        this.setApprovalResult(yzjTask, participants, (List<Long>)assigneeIds, defaultDecision, executionType, execution);
                        return;
                    }
                    this.stopCalculator(userTask);
                }
            } else {
                defaultDecision = approveDecision;
            }
            if (this.isAutoApprove(execution, yzjTask, participants, (List<Long>)autoApprovePersonCollection)) {
                executionType = "byAuto";
                logger.debug(String.format("\u8282\u70b9%s\u7b26\u5408\u81ea\u52a8\u5ba1\u6279\u6761\u4ef6\uff0c\u5904\u7406\u4eba%s\uff0c\u51b3\u7b56\u9879%s\uff0c\u6267\u884c\u7c7b\u578b%s", yzjTask.getId(), task.getStarterId(), defaultDecision.getNumber(), executionType));
                assigneeIds = autoApprovePersonCollection;
            } else {
                assigneeIds = participants;
            }
        }
        this.setApprovalResult(yzjTask, participants, (List<Long>)assigneeIds, defaultDecision, executionType, execution);
        if (!"byAuto".equals(executionType)) {
            this.stopCalculator(yzjTask);
        }
    }

    private boolean isAutoApprove(ExecutionEntity execution, YunzhijiaTask yzjTask, List<Long> participants, List<Long> autoApprovePersonCollection) {
        return AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign(autoApprovePersonCollection, execution, yzjTask, participants.size(), this.commandContext, autoApprovePersonCollection.size(), true, null);
    }

    private boolean isYZJRepeater(YunzhijiaTask yzjTask, TaskEntity task, List<Long> userIds, ExecutionEntity execution, DecisionOption approveDecision, List<Long> autoApprovePersonCollection) {
        boolean result = false;
        String handleWey = yzjTask.getRepeaterModel();
        boolean isRepeaterbtn = yzjTask.isRepeaterbtn();
        int countForAudit = 0;
        if (isRepeaterbtn && "auto".equals(handleWey)) {
            for (Long userId : userIds) {
                boolean canCount = false;
                ArrayList<Long> userIdList = new ArrayList<Long>(1);
                userIdList.add(userId);
                List<Map<String, String>> repeaterInfos = PercomputatorUtils.getRepeaterInfo(yzjTask, task, userIdList, execution);
                for (Map<String, String> repeaterInfo : repeaterInfos) {
                    String resultNumber = repeaterInfo.get("resultNumber");
                    String assigneeId = repeaterInfo.get("assigneeId");
                    if (!"Consent".equals(resultNumber) || !StringUtils.equals((CharSequence)String.valueOf(userId), (CharSequence)assigneeId)) continue;
                    if (!autoApprovePersonCollection.contains(Long.valueOf(assigneeId))) {
                        autoApprovePersonCollection.add(Long.valueOf(assigneeId));
                    }
                    canCount = true;
                    break;
                }
                if (!canCount) continue;
                ++countForAudit;
            }
        }
        if (WfUtils.isNotEmptyForCollection(userIds)) {
            result = AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign(autoApprovePersonCollection, execution, yzjTask, userIds.size(), this.commandContext, countForAudit, true, null);
        }
        return result;
    }

    private boolean isStarterSameAsYzjAuditor(Long starterId, YunzhijiaTask yzjTask, DecisionOption decision, List<Long> userIds) {
        switch (yzjTask.getBusinessModel()) {
            case "passByOne": {
                return true;
            }
            case "oneVoteVeto": {
                if (userIds.size() != 1) break;
                return true;
            }
            case "voteOnProportion": {
                return AuditRuleForYzjUtil.isThroughVotePercentage(1, userIds.size(), yzjTask, decision.getAuditType());
            }
            case "allVote": {
                if (userIds.size() != 1 || !"approve".equals(decision.getAuditType())) break;
                return true;
            }
            case "voteByPassProportion": {
                return AuditRuleForYzjUtil.isThroughPassPercent(1, userIds.size(), yzjTask, decision.getAuditType());
            }
        }
        return false;
    }
}

