/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.procinst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class CalculateProcInstCycleCmd
implements Command<List<HistoricActivityInstanceEntity>> {
    private static final String MODEL_ADJACENT = "adjacent";
    private static final String MODEL_DEFAULT = "default";
    private Log logger = LogFactory.getLog(this.getClass());
    private Long procInstId;
    private String currentNodeId;
    private String model = "default";
    protected Map<String, Map<String, Object>> comments;
    protected Process process;
    protected Map<Long, Set<HistoricActivityInstanceEntity>> sourceActInsts = new HashMap<Long, Set<HistoricActivityInstanceEntity>>();
    protected Map<Long, HistoricActivityInstanceEntity> idActInsts = new HashMap<Long, HistoricActivityInstanceEntity>();
    protected final Node head = new Node();
    protected Map<String, Node> replacedNodeAndForkRemoveBranch = new LinkedHashMap<String, Node>();
    protected Set<Long> rejectToInnerJoinNodes = new HashSet<Long>();

    public CalculateProcInstCycleCmd(Long procInstId) {
        this.procInstId = procInstId;
    }

    public CalculateProcInstCycleCmd(Long procInstId, String currentNodeId) {
        this.procInstId = procInstId;
        this.currentNodeId = currentNodeId;
    }

    public CalculateProcInstCycleCmd(Long procInstId, String currentNodeId, String model) {
        this.procInstId = procInstId;
        this.currentNodeId = currentNodeId;
        this.model = MODEL_ADJACENT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<HistoricActivityInstanceEntity> execute(CommandContext commandContext) {
        void var5_13;
        Node targetNode;
        this.logger.debug(String.format("start execute CalculateProcInstCycle, args procinstid=%s,currentNodeId=%s ", this.procInstId, this.procInstId));
        if (this.procInstId == null) {
            return Collections.emptyList();
        }
        this.process = ProcessDefinitionUtil.getProcessByProcInstId(this.procInstId);
        if (this.process == null) {
            return Collections.emptyList();
        }
        List<HistoricActivityInstanceEntity> allSortedActInsts = commandContext.getHistoricActivityInstanceEntityManager().findByProcessInstanceId(this.procInstId);
        HashSet<Long> idSet = new HashSet<Long>(allSortedActInsts.size());
        for (HistoricActivityInstanceEntity historicActivityInstanceEntity : allSortedActInsts) {
            Long key = historicActivityInstanceEntity.getId();
            idSet.add(key);
        }
        HashSet<Long> curIdSet = new HashSet<Long>(1);
        for (HistoricActivityInstanceEntity i : allSortedActInsts) {
            Set<HistoricActivityInstanceEntity> sourceVals;
            if ("StartSignalEvent".equals(i.getActivityType())) {
                this.head.setActId(i.getActivityId());
                this.head.setActInstId(i.getId());
                this.head.setActInst(i);
            }
            Long key = i.getId();
            this.idActInsts.put(key, i);
            Set<HistoricActivityInstanceEntity> vals = this.sourceActInsts.get(key);
            if (vals == null) {
                this.sourceActInsts.put(key, new HashSet());
            }
            if ((sourceVals = this.sourceActInsts.get(key = i.getSourceElementId())) == null) {
                sourceVals = new HashSet<HistoricActivityInstanceEntity>();
                this.sourceActInsts.put(key, sourceVals);
            }
            sourceVals.add(i);
            Long targetElementId = i.getTargetElementId();
            if (!WfUtils.isNotEmpty(targetElementId) || idSet.contains(i.getTargetElementId())) continue;
            curIdSet.add(i.getTargetElementId());
        }
        if (MODEL_ADJACENT.equals(this.model) && !curIdSet.isEmpty()) {
            for (Long teid : curIdSet) {
                this.prepareCurNode(commandContext, teid);
            }
        }
        this.comments = this.getComments();
        this.buildCycle(this.head);
        ArrayList<HistoricActivityInstanceEntity> arrayList = new ArrayList<HistoricActivityInstanceEntity>();
        HashMap<String, Node> newestNodeMap = new HashMap<String, Node>();
        this.collectNewestInst(this.head, arrayList, newestNodeMap);
        this.logger.debug(String.format("head data - %s", WfUtils.listToString(newestNodeMap.keySet(), "->")));
        if (!this.replacedNodeAndForkRemoveBranch.isEmpty()) {
            LinkedList<String> forkIds = new LinkedList<String>(this.replacedNodeAndForkRemoveBranch.keySet());
            this.logger.debug(String.format("replacedNodeAndForkRemoveBranch result is %s", WfUtils.listToString(forkIds, ",")));
            forkIds.sort(new Comparator<String>(){

                @Override
                public int compare(String j, String k) {
                    return k.split("\\$").length - j.split("\\$").length;
                }
            });
            Node preNode = this.head;
            for (String forkId : forkIds) {
                Node cnode = this.replacedNodeAndForkRemoveBranch.get(forkId);
                Node splitNode = this.getTargetNodeFromHead(preNode, cnode.getActId());
                if (splitNode == null) {
                    if ((cnode = this.getTargetNode(cnode, this.head.getActId())) == null) continue;
                    preNode = cnode;
                    this.collectNewestInst(cnode, arrayList, newestNodeMap);
                    continue;
                }
                this.collectNewestInst(cnode, arrayList, newestNodeMap);
            }
        }
        if (MODEL_DEFAULT.equals(this.model)) {
            if (WfUtils.isNotEmpty(this.currentNodeId)) {
                ArrayList<HistoricActivityInstanceEntity> arrayList2 = new ArrayList<HistoricActivityInstanceEntity>();
                targetNode = (Node)newestNodeMap.get(this.currentNodeId);
                if (targetNode != null) {
                    this.getPreInst(targetNode, arrayList2, newestNodeMap);
                }
            }
        } else if (MODEL_ADJACENT.equals(this.model)) {
            ArrayList<HistoricActivityInstanceEntity> arrayList3 = new ArrayList<HistoricActivityInstanceEntity>();
            if (WfUtils.isNotEmpty(this.currentNodeId) && (targetNode = (Node)newestNodeMap.get(this.currentNodeId)) != null) {
                this.getAdjacentPreInst(targetNode, arrayList3, newestNodeMap);
            }
        }
        return var5_13;
    }

    private void prepareCurNode(CommandContext commandContext, Long teid) {
        Set<HistoricActivityInstanceEntity> sourceVals;
        HistoricActivityInstanceEntity targetActInst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(teid);
        Long key = targetActInst.getId();
        this.idActInsts.put(key, targetActInst);
        Set<HistoricActivityInstanceEntity> vals = this.sourceActInsts.get(key);
        if (vals == null) {
            this.sourceActInsts.put(key, new HashSet());
        }
        if ((sourceVals = this.sourceActInsts.get(key = targetActInst.getSourceElementId())) == null) {
            sourceVals = new HashSet<HistoricActivityInstanceEntity>();
            this.sourceActInsts.put(key, sourceVals);
        }
        sourceVals.add(targetActInst);
    }

    private void collectNewestInst(Node node, List<HistoricActivityInstanceEntity> newestActInsts, Map<String, Node> newestNodeMap) {
        if (!this.rejectToInnerJoinNodes.contains(node.getActInstId())) {
            if (!newestNodeMap.containsKey(node.getActId())) {
                newestNodeMap.put(node.getActId(), node);
                newestActInsts.add(node.getActInst());
            }
            for (Node n : node.getNextNodes()) {
                this.collectNewestInst(n, newestActInsts, newestNodeMap);
            }
        }
    }

    private void getPreInst(Node node, List<HistoricActivityInstanceEntity> newestActInsts, Map<String, Node> newestNodeMap) {
        newestActInsts.add(node.getActInst());
        for (Node p : node.getPreNodes()) {
            if (newestActInsts.contains(p.getActInst())) continue;
            this.getPreInst(p, newestActInsts, newestNodeMap);
        }
    }

    private void getAdjacentPreInst(Node node, List<HistoricActivityInstanceEntity> newestActInsts, Map<String, Node> newestNodeMap) {
        for (Node p : node.getPreNodes()) {
            boolean loop = false;
            HistoricActivityInstanceEntity activity = p.getActInst();
            String activityType = p.getActInst().getActivityType();
            if ("byAuto".equals(p.getActInst().getExecutionType()) && BpmnModelUtil.instanceofAuditTask(activityType)) {
                AuditTask element;
                loop = WfUtils.isEmpty(activity.getAssigneeId()) ? ((element = (AuditTask)this.process.getFlowElement(p.getActId())).getAutoAudit() != null && "reject".equalsIgnoreCase(BpmnModelUtil.getDecisionType(element, element.getAutoAudit().getAutoDecisionWhenMatch())) && element.getAutoAudit().getParticipantAsAutoAuditor() != false ? loop : Boolean.TRUE) : activity.getAssigneeId() == -1L;
            } else {
                boolean bl = loop = "skip".equals(activity.getExecutionType()) || BpmnModelUtil.instanceofAutoTask(activity.getActivityType()) || BpmnModelUtil.instanceofNotifyTask(activity.getActivityType()) || BpmnModelUtil.isInstanceof(activity.getActivityType(), "WaitTask") || "InclusiveGateway".equals(activity.getActivityType()) || BpmnModelUtil.isInstanceof(activity.getActivityType(), "CallActivity") || BpmnModelUtil.instanceofSSCApprover(activity.getActivityType()) || BpmnModelUtil.instanceofSSCImageUpload(activity.getActivityType()) || "jump".equals(activity.getExecutionType());
            }
            if (loop) {
                this.getAdjacentPreInst(p, newestActInsts, newestNodeMap);
                continue;
            }
            newestActInsts.add(activity);
        }
    }

    private Map<String, Map<String, Object>> getComments() {
        String sql = "select  a.FDECISIONTYPE decisionType, a.FTASKID taskId, a.FACTIVITYID actId from t_wf_hicomment a where a.FPROCINSTID = ? and a.FTYPE = 'comment'  ";
        Object[] params = new Object[]{this.procInstId};
        HashMap<String, Map<String, Object>> cs = new HashMap<String, Map<String, Object>>();
        try (DataSet ds = DB.queryDataSet((String)"wfs.calculateCycle", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            for (Row r : ds) {
                Long taskId = r.getLong("taskId");
                if (!WfUtils.isNotEmpty(taskId)) continue;
                HashMap<String, Object> comment = new HashMap<String, Object>();
                comment.put("taskId", taskId);
                comment.put("decisionType", r.getString("decisionType"));
                comment.put("actId", r.getString("actId"));
                cs.put(String.valueOf(taskId), comment);
            }
        }
        return cs;
    }

    public void buildCycle(Node head) {
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(head);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.poll();
            Long id = node.getActInstId();
            Set<HistoricActivityInstanceEntity> targets = this.sourceActInsts.get(id);
            for (HistoricActivityInstanceEntity i : targets) {
                if (!"SequenceFlow".equals(i.getActivityType())) {
                    this.logger.warn(String.format("\u6d41\u7a0b\u6570\u636e\u6709\u9519\u8bef\uff0c\u3010%s\u3011\u7684souceElement\u4e3a\u3010%s\u3011\uff01", i.getId(), node.getActId()));
                    throw new KDException(WFErrorCode.engineError(), new Object[0]);
                }
                HistoricActivityInstanceEntity actInst = this.idActInsts.get(i.getTargetElementId());
                if (actInst == null) continue;
                if ("YunzhijiaTask".equals(actInst.getActivityType())) {
                    actInst = this.getSourcedYzjActInst(actInst, i);
                }
                Node targetNode = this.warpActInst(actInst);
                this.calculate(queue, node, targetNode);
                queue.sort(new Comparator<Node>(){

                    @Override
                    public int compare(Node n1, Node n2) {
                        Date dn1 = n1.getActInst().getEndTime();
                        if (dn1 == null) {
                            return 1;
                        }
                        Date dn2 = n2.getActInst().getEndTime();
                        if (dn2 == null) {
                            return -1;
                        }
                        return dn1.compareTo(dn2);
                    }
                });
            }
        }
    }

    private HistoricActivityInstanceEntity getSourcedYzjActInst(HistoricActivityInstanceEntity yzjActInst, HistoricActivityInstanceEntity incomingFlowActInst) {
        if (this.sourceActInsts.get(incomingFlowActInst.getId()) != null) {
            for (HistoricActivityInstanceEntity i : this.sourceActInsts.get(incomingFlowActInst.getId())) {
                Set<HistoricActivityInstanceEntity> yzjOutFlow = this.sourceActInsts.get(i.getId());
                if (yzjOutFlow == null || yzjOutFlow.isEmpty()) continue;
                return i;
            }
        }
        return yzjActInst;
    }

    private void calculate(LinkedList<Node> queue, Node curNode, Node targetNode) {
        this.logger.debug(String.format("execting calculate: curNode=%s, targetNode=%s, queue=%s ;", curNode.getActId(), targetNode.getActId(), WfUtils.listToString(queue, ",")));
        boolean reject = this.isReject(curNode, this.comments);
        Node forkBranchNode = this.getForkBranchNode(curNode, targetNode);
        if (reject && forkBranchNode != null) {
            String rejectStrategy = this.getForkNodeRejectStrategy(forkBranchNode);
            Node replacedNode = this.getTargetNode(curNode, targetNode.getActId());
            if ("reject".equals(rejectStrategy)) {
                Node forkNode = forkBranchNode.getPreNodes().get(0);
                if (replacedNode != null) {
                    forkNode.removeNextNode(forkBranchNode);
                    forkBranchNode.removePreNode(forkNode);
                    Node copyedReplaceNode = this.nodeCopy(replacedNode, queue);
                    this.replaceNode(replacedNode, targetNode);
                    this.replacedNodeAndForkRemoveBranch.put(forkNode.getActId(), copyedReplaceNode);
                } else {
                    curNode.addNextNode(targetNode);
                    targetNode.addPreNode(curNode);
                }
            } else {
                Iterator<Map.Entry<String, Node>> iter = this.replacedNodeAndForkRemoveBranch.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, Node> entry = iter.next();
                    Node forkNode = this.getTargetNodeFromHead(entry.getValue(), entry.getKey());
                    if (forkNode == null || !this.getForkPath(forkNode).contains(this.getForkPath(targetNode))) continue;
                    iter.remove();
                }
                if (replacedNode != null) {
                    this.replaceNode(replacedNode, targetNode);
                } else {
                    curNode.addNextNode(targetNode);
                    targetNode.addPreNode(curNode);
                }
            }
            this.addQueue(queue, targetNode);
        } else if (reject && "UserTask".equals(targetNode.getActInst().getActivityType())) {
            HistoricActivityInstanceEntity nnextActInst;
            Set<HistoricActivityInstanceEntity> flows = this.sourceActInsts.get(targetNode.getActInstId());
            Node nnextNode = null;
            if (flows != null && flows.size() == 1 && (nnextActInst = this.idActInsts.get(flows.iterator().next().getTargetElementId())) != null && nnextActInst.getActivityId().equals(curNode.getActId())) {
                if ("YunzhijiaTask".equals(nnextActInst.getActivityType())) {
                    nnextActInst = this.getSourcedYzjActInst(nnextActInst, flows.iterator().next());
                }
                nnextNode = this.warpActInst(nnextActInst);
                this.replaceNode(curNode, nnextNode);
            }
            Node replacedNode = this.getTargetNode(curNode, targetNode.getActId());
            if (nnextNode != null) {
                if (replacedNode != null) {
                    replacedNode.setActInst(targetNode.getActInst());
                    replacedNode.setActInstId(targetNode.getActInstId());
                    nnextNode.getPreNodes().clear();
                    nnextNode.getPreNodes().add(replacedNode);
                    this.addQueue(queue, nnextNode);
                } else {
                    this.logger.debug("reject Node is never deal");
                }
            } else {
                this.defaultContinue(curNode, targetNode);
                this.addQueue(queue, targetNode);
            }
        } else {
            Node beforeNode;
            String joinFlag;
            String forkNodeId;
            Node forkNode;
            if (WfUtils.isNotEmpty(targetNode.getActInst().getJoinFlag()) && (forkNode = this.getTargetNode(curNode, forkNodeId = (joinFlag = targetNode.getActInst().getJoinFlag()).split("\\$")[0])) != null && (beforeNode = this.getTargetNodeFromHead(forkNode, targetNode.getActId())) != null && joinFlag.equals(beforeNode.getActInst().getJoinFlag())) {
                this.logger.debug("is joinNode and others is deal .");
                beforeNode.addPreNode(curNode);
                curNode.addNextNode(beforeNode);
                return;
            }
            String actId = curNode.getActId();
            if (this.replacedNodeAndForkRemoveBranch.containsKey(actId)) {
                String nodePath = this.getForkPath(curNode);
                String nextNodePath = this.getForkPath(targetNode);
                if (nextNodePath.contains(String.format("%s$", nodePath)) && this.getTargetNode(curNode, targetNode.getActId()) != null) {
                    Node copyHead = this.replacedNodeAndForkRemoveBranch.get(actId);
                    Node beforeForkNode = this.getTargetNodeFromHead(copyHead, actId);
                    targetNode.addPreNode(curNode);
                    curNode.addNextNode(targetNode);
                    if (beforeForkNode != null) {
                        for (Node n : beforeForkNode.getNextNodes()) {
                            curNode.addNextNode(n);
                            n.removePreNode(beforeForkNode);
                            beforeForkNode.removeNextNode(n);
                            n.addPreNode(curNode);
                        }
                        this.replacedNodeAndForkRemoveBranch.remove(actId);
                    } else {
                        this.defaultContinue(curNode, targetNode);
                    }
                } else {
                    this.defaultContinue(curNode, targetNode);
                }
                this.addQueue(queue, targetNode);
            } else {
                this.defaultContinue(curNode, targetNode);
                this.addQueue(queue, targetNode);
            }
        }
    }

    private void defaultContinue(Node node, Node nextNode) {
        Node beforeNextNode = this.getTargetNode(node, nextNode.getActId());
        if (beforeNextNode != null) {
            Map<String, NodeForkJoinModel> models = this.process.getForkJoinModels();
            NodeForkJoinModel cmodel = models.get(node.getActId());
            NodeForkJoinModel nmodel = models.get(nextNode.getActId());
            if (cmodel != null && nmodel != null) {
                Node joinNode;
                String cStructure = cmodel.getForkStructure();
                String nStructure = nmodel.getForkStructure();
                if (nStructure.contains(cStructure + "$") && nStructure.split("\\$").length - 1 == cStructure.split("\\$").length && !nmodel.getLatestForkNode().equals(cmodel.getNodeId()) && (joinNode = this.getTargetNode(node, nmodel.getLatestJoinNode())) != null) {
                    this.rejectToInnerJoinNodes.add(joinNode.getActInstId());
                }
            }
            this.replaceNode(beforeNextNode, nextNode);
        } else if (!this.repairJoinNode(node, nextNode)) {
            nextNode.addPreNode(node);
            node.addNextNode(nextNode);
        }
    }

    private boolean repairJoinNode(Node node, Node nextNode) {
        Node joinNode;
        Node startNode;
        boolean isJoinNode = false;
        NodeForkJoinModel model = this.process.getForkJoinModels().get(node.getActId());
        if (model != null && nextNode.getActId().equals(model.getLatestJoinNode()) && (startNode = this.getTargetNode(node, model.getLatestForkNode())) != null && (joinNode = this.getTargetNodeFromHead(startNode, nextNode.getActId())) != null) {
            this.replaceNode(joinNode, nextNode);
            for (Node pre : joinNode.getPreNodes()) {
                if (pre.getActId().equals(node.getActId())) {
                    nextNode.addPreNode(node);
                    node.addNextNode(nextNode);
                    continue;
                }
                nextNode.addPreNode(pre);
                pre.removeNextNode(joinNode);
                pre.addNextNode(nextNode);
            }
            isJoinNode = true;
        }
        return isJoinNode;
    }

    private void addQueue(LinkedList<Node> queue, Node nextNode) {
        if (this.replacedNodeAndForkRemoveBranch.isEmpty()) {
            queue.add(nextNode);
        } else {
            queue.addFirst(nextNode);
        }
    }

    private void replaceNode(Node oldNode, Node newNode) {
        for (Node pre : oldNode.getPreNodes()) {
            newNode.addPreNode(pre);
            pre.removeNextNode(oldNode);
            pre.addNextNode(newNode);
        }
    }

    private boolean isReject(Node node, Map<String, Map<String, Object>> comments) {
        Long taskId = node.getActInst().getParentTaskId();
        Long l = taskId = WfUtils.isEmpty(taskId) ? node.getActInst().getTaskId() : taskId;
        if (WfUtils.isEmpty(taskId)) {
            return false;
        }
        Map<String, Object> c = comments.get(String.valueOf(taskId));
        if (c == null) {
            return false;
        }
        return "reject".equals(c.get("decisionType")) || "forceReject".equals(c.get("decisionType"));
    }

    private Node getForkBranchNode(Node node, Node nextNode) {
        String forkPath = this.getForkPath(node);
        String nextForkPath = this.getForkPath(nextNode);
        if (WfUtils.isEmpty(forkPath) || WfUtils.isEmpty(nextForkPath) || nextForkPath.contains(forkPath)) {
            return null;
        }
        String forkBranchNodeId = forkPath.substring(nextForkPath.length() + 1);
        return this.getTargetNode(node, forkBranchNodeId);
    }

    private String getForkPath(Node node) {
        String forkPath = null;
        NodeForkJoinModel model = this.process.getForkJoinModels().get(node.getActId());
        if (model != null) {
            forkPath = model.getForkStructure();
        }
        return forkPath == null ? "" : forkPath;
    }

    private String getForkNodeRejectStrategy(Node branchNode) {
        Node forkNode = branchNode.getPreNodes().get(0);
        List<Node> nextNodes = forkNode.getNextNodes();
        if (nextNodes.size() < 2) {
            return "all";
        }
        Node otherBranchNode = nextNodes.get(0);
        if (otherBranchNode.getActId().equals(branchNode.getActId())) {
            otherBranchNode = nextNodes.get(1);
        }
        HistoricActivityInstanceEntity actInst = otherBranchNode.getActInst();
        while (true) {
            if ("cancel".equals(actInst.getExecutionType())) {
                return "all";
            }
            if (actInst.getJoinFlag().contains(forkNode.getActId())) {
                return "reject";
            }
            if (otherBranchNode.getNextNodes().isEmpty()) break;
            otherBranchNode = otherBranchNode.getNextNodes().get(0);
            actInst = otherBranchNode.getActInst();
        }
        return this.snifferInActInsts(actInst, forkNode.getActId());
    }

    private String snifferInActInsts(HistoricActivityInstanceEntity actInst, String forkNodeId) {
        Set<HistoricActivityInstanceEntity> flows;
        while ((flows = this.sourceActInsts.get(actInst.getId())) != null && !flows.isEmpty()) {
            actInst = flows.iterator().next();
            if ("cancel".equals(actInst.getExecutionType())) {
                return "all";
            }
            if (!actInst.getJoinFlag().contains(forkNodeId)) continue;
            return "reject";
        }
        return "reject";
    }

    private Node getTargetNode(Node start, String targetActId) {
        if (start.getActId().equals(targetActId)) {
            return start;
        }
        List<Node> preNodes = start.getPreNodes();
        Node n = null;
        for (Node node : preNodes) {
            if (targetActId.equals(node.getActId())) {
                return node;
            }
            n = this.getTargetNode(node, targetActId);
            if (n == null) continue;
            return n;
        }
        return n;
    }

    private Node getTargetNodeFromHead(Node start, String targetActId) {
        List<Node> nextNodes = start.getNextNodes();
        Node n = null;
        for (Node node : nextNodes) {
            if (targetActId.equals(node.getActId())) {
                return node;
            }
            n = this.getTargetNodeFromHead(node, targetActId);
            if (n == null) continue;
            return n;
        }
        return n;
    }

    public Node warpActInst(HistoricActivityInstanceEntity actInst) {
        Node node = new Node();
        node.setActId(actInst.getActivityId());
        node.setActInstId(actInst.getId());
        node.setActInst(actInst);
        if ("YunzhijiaTask".equals(actInst.getActivityType())) {
            node.setGroupKey(String.valueOf(actInst.getParentTaskId()));
        } else if (WfUtils.isNotEmpty(actInst.getJoinFlag())) {
            node.setGroupKey(actInst.getJoinFlag());
        }
        return node;
    }

    public Node nodeCopy(Node node, LinkedList<Node> queue) {
        HashMap<String, Node> copyNodeMap = new HashMap<String, Node>();
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        this.createCopyNode(node, copyNodeMap, nodeMap);
        this.buildPointer(copyNodeMap, nodeMap);
        Node copyedNode = (Node)copyNodeMap.get(node.getActId());
        this.chanageQueueNode(copyNodeMap, nodeMap, copyedNode, queue);
        return copyedNode;
    }

    private void chanageQueueNode(Map<String, Node> copyNodeMap, Map<String, Node> nodeMap, Node copyedNode, LinkedList<Node> queue) {
        Node node = nodeMap.get(copyedNode.getActId());
        if (queue.contains(node)) {
            queue.remove(node);
            queue.add(copyedNode);
        }
        for (Node n : copyedNode.getNextNodes()) {
            this.chanageQueueNode(copyNodeMap, nodeMap, n, queue);
        }
    }

    private void buildPointer(Map<String, Node> copyNodeMap, Map<String, Node> nodeMap) {
        for (Map.Entry<String, Node> entry : copyNodeMap.entrySet()) {
            Node coypedNode = entry.getValue();
            Node node = nodeMap.get(entry.getKey());
            for (Node p : node.getPreNodes()) {
                coypedNode.addPreNode(copyNodeMap.get(p.getActId()));
            }
            for (Node n : node.getNextNodes()) {
                coypedNode.addNextNode(copyNodeMap.get(n.getActId()));
            }
        }
    }

    private void createCopyNode(Node node, Map<String, Node> copyNodeMap, Map<String, Node> nodeMap) {
        String actId = node.getActId();
        Node copyNode = copyNodeMap.get(actId);
        nodeMap.put(actId, node);
        if (copyNode == null) {
            copyNode = node.copy();
            copyNodeMap.put(node.getActId(), copyNode);
        }
        for (Node p : node.getPreNodes()) {
            if (copyNodeMap.containsKey(p.getActId())) continue;
            this.createCopyNode(p, copyNodeMap, nodeMap);
        }
        for (Node n : node.getNextNodes()) {
            if (copyNodeMap.containsKey(n.getActId())) continue;
            this.createCopyNode(n, copyNodeMap, nodeMap);
        }
    }

    final class Node {
        private String actId;
        private Long actInstId;
        private HistoricActivityInstanceEntity actInst;
        private String groupKey;
        private LinkedList<Node> preNodes = new LinkedList();
        private LinkedList<Node> nextNodes = new LinkedList();

        Node() {
        }

        public Node copy() {
            Node clone = new Node();
            clone.setActId(this.getActId());
            clone.setActInst(this.getActInst());
            clone.setActInstId(this.getActInstId());
            clone.setGroupKey(this.getGroupKey());
            return clone;
        }

        public String getActId() {
            return this.actId;
        }

        public void setActId(String actId) {
            this.actId = actId;
        }

        public Long getActInstId() {
            return this.actInstId;
        }

        public void setActInstId(Long actInstId) {
            this.actInstId = actInstId;
        }

        public String getGroupKey() {
            return this.groupKey;
        }

        public void setGroupKey(String groupKey) {
            this.groupKey = groupKey;
        }

        public List<Node> getPreNodes() {
            return this.preNodes;
        }

        public void addPreNode(Node preNode) {
            Iterator iter = this.preNodes.iterator();
            while (iter.hasNext()) {
                Node i = (Node)iter.next();
                if (!i.getActId().equals(preNode.getActId())) continue;
                iter.remove();
            }
            this.preNodes.add(preNode);
        }

        public boolean removePreNode(Node preNode) {
            return this.preNodes.remove(preNode);
        }

        public List<Node> getNextNodes() {
            return this.nextNodes;
        }

        public void addNextNode(Node nextNode) {
            Iterator iter = this.nextNodes.iterator();
            while (iter.hasNext()) {
                Node i = (Node)iter.next();
                if (!i.getActId().equals(nextNode.getActId())) continue;
                iter.remove();
            }
            this.nextNodes.add(nextNode);
        }

        public boolean removeNextNode(Node nextNode) {
            return this.nextNodes.remove(nextNode);
        }

        public HistoricActivityInstanceEntity getActInst() {
            return this.actInst;
        }

        public void setActInst(HistoricActivityInstanceEntity actInst) {
            this.actInst = actInst;
        }

        public String toString() {
            return String.format("(actId=%s;id=%s)", this.actId, this.actInstId);
        }
    }
}

