/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.procinst;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.FindEntitiesByFiltersCmd;
import kd.bos.workflow.engine.impl.cmd.entity.GetSingleEntityCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;

public class GetParentProcessInstanceInfoCmd
implements Command<List<HistoricProcessInstanceEntity>> {
    private String businessKey;
    private String entityNubmer;
    private String selectedFields;
    private String orderBys;
    private boolean currentRecord;

    public GetParentProcessInstanceInfoCmd(String businessKey, String entityNubmer, String selectedFields, String orderBys, boolean currentRecord) {
        this.businessKey = businessKey;
        this.entityNubmer = entityNubmer;
        this.selectedFields = selectedFields;
        this.orderBys = orderBys;
        this.currentRecord = currentRecord;
    }

    @Override
    public List<HistoricProcessInstanceEntity> execute(CommandContext commandContext) {
        QFilter[] qFilters = null;
        qFilters = WfUtils.isEmpty(this.entityNubmer) ? new QFilter[]{new QFilter("businesskey", "=", (Object)this.businessKey), new QFilter("processtype", "=", (Object)ProcessType.AuditFlow.name())} : new QFilter[]{new QFilter("businesskey", "=", (Object)this.businessKey), new QFilter("ENTITYNUMBER", "=", (Object)this.entityNubmer), new QFilter("processtype", "=", (Object)ProcessType.AuditFlow.name())};
        Object entities = new FindEntitiesByFiltersCmd("wf_hiprocinst", qFilters, "id, superprocessinstanceid", null).execute(commandContext);
        if (null == entities || entities.isEmpty()) {
            return null;
        }
        ArrayList<Long> ids = new ArrayList<Long>(entities.size());
        Long id = null;
        Long superProcessInstanceId = null;
        HistoricProcessInstanceEntity entityForParent = null;
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            HistoricProcessInstanceEntity entity = (HistoricProcessInstanceEntity)iterator.next();
            if (null == entity || WfUtils.isEmpty(id = entity.getId())) continue;
            superProcessInstanceId = entity.getSuperProcessInstanceId();
            if (WfUtils.isEmpty(superProcessInstanceId)) {
                ids.add(id);
                continue;
            }
            entityForParent = (HistoricProcessInstanceEntity)new GetSingleEntityCmd(superProcessInstanceId, "wf_hiprocinst", "processtype").execute(commandContext);
            if (null == entityForParent || ProcessType.AuditFlow.name().equals(entityForParent.getProcessType())) continue;
            ids.add(id);
        }
        QFilter auditFlowQFilter = new QFilter("id", "in", ids);
        QFilter bizFlowQFilter = null;
        qFilters = WfUtils.isEmpty(this.entityNubmer) ? new QFilter[]{new QFilter("businesskey", "=", (Object)this.businessKey), new QFilter("processtype", "=", (Object)ProcessType.BizFlow.name())} : new QFilter[]{new QFilter("businesskey", "=", (Object)this.businessKey), new QFilter("ENTITYNUMBER", "=", (Object)this.entityNubmer), new QFilter("processtype", "=", (Object)ProcessType.BizFlow.name())};
        entities = new FindEntitiesByFiltersCmd("wf_hiprocinst", qFilters, "id", null).execute(commandContext);
        if (null != entities && !entities.isEmpty()) {
            ids = new ArrayList(entities.size());
            Iterator iterator2 = entities.iterator();
            while (iterator2.hasNext()) {
                HistoricProcessInstanceEntity entity = (HistoricProcessInstanceEntity)iterator2.next();
                if (null == entity || WfUtils.isEmpty(id = entity.getId())) continue;
                ids.add(id);
            }
            if (!ids.isEmpty()) {
                bizFlowQFilter = new QFilter("businesskey", "=", (Object)this.businessKey).and(new QFilter("processtype", "=", (Object)ProcessType.AuditFlow.name())).and(new QFilter("superprocessinstanceid", "in", ids));
            }
        }
        QFilter workFlowQFilterFix = null;
        workFlowQFilterFix = null != bizFlowQFilter ? bizFlowQFilter.or(auditFlowQFilter) : auditFlowQFilter;
        qFilters = this.currentRecord ? new QFilter[]{workFlowQFilterFix, new QFilter("endTime", "is null", null)} : new QFilter[]{workFlowQFilterFix};
        entities = new FindEntitiesByFiltersCmd("wf_hiprocinst", qFilters, this.selectedFields, this.orderBys).execute(commandContext);
        if (this.currentRecord && (null == entities || entities.isEmpty())) {
            qFilters = new QFilter[]{workFlowQFilterFix};
            entities = new FindEntitiesByFiltersCmd("wf_hiprocinst", qFilters, this.selectedFields, this.orderBys).execute(commandContext);
        }
        return entities;
    }
}

