/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.DesignerEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityImpl;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public abstract class AbstractCreateProcTemplateByTemplateCmd<T extends DesignerEntity>
implements Command<Long> {
    protected ProcTemplateEntity template;

    public AbstractCreateProcTemplateByTemplateCmd(DynamicObject dynamicObject) {
        this.template = new ProcTemplateEntityImpl(dynamicObject);
    }

    @Override
    public Long execute(CommandContext commandContext) {
        this.createProcTemplate(commandContext);
        return this.template.getId();
    }

    protected void createProcTemplate(CommandContext commandContext) {
        commandContext.getProcTemplateEntityManager().insert(this.template);
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ResourceEntity resource = (ResourceEntity)resourceManager.create();
        String data = this.getNewTemplateResourceData(commandContext);
        resource.setData(data);
        resourceManager.insert(resource);
        Long resourceId = resource.getId();
        String name = String.valueOf(this.template.getName());
        ExtractMultiLanguageWordsUtil.extractWordsAndSaveOrUpdate(resourceId, name, this.template.getId(), "", this.template.getNumber());
        this.template.setResourceId(resourceId);
        commandContext.getProcTemplateEntityManager().update(this.template);
    }

    protected String getCopiedResourceData(CommandContext commandContext) {
        BpmnModel newModel = this.getCopiedBpmnModel(commandContext);
        return GraphCodecUtils.convertBpmnModelToJSON(newModel);
    }

    protected BpmnModel getCopiedBpmnModel(CommandContext commandContext) {
        String fields = String.format("%s,%s,%s,%s,%s,%s", this.getBeCopiedEntityResourceField(), this.getBeCopiedEntityOrgField(), this.getBeCopiedEntityNumberField(), this.getBeCopiedEntityNameField(), this.getBeCopiedEntityDescriptionField(), this.getBeCopiedEntityIdentificationField());
        T beCopiedEntity = this.getBeCopiedEntity(commandContext, fields);
        ResourceEntity beCopiedResource = (ResourceEntity)commandContext.getResourceEntityManager().findById(beCopiedEntity.getResourceId());
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(beCopiedResource.getData());
        DuplicateModel duplicateModel = new DuplicateModel();
        duplicateModel.setModelKey(this.template.getNumber());
        duplicateModel.setModelName(this.template.getName());
        duplicateModel.setModelBusinessId(this.template.getIdentification());
        duplicateModel.setModelDescription(this.template.getDescription());
        if (!this.template.getOrgId().equals(beCopiedEntity.getOrgId())) {
            duplicateModel.setModelOrgunitid(this.template.getOrgId());
        }
        duplicateModel.setModelKeyOld(beCopiedEntity.getNumber());
        duplicateModel.setModelNameOld(beCopiedEntity.getName());
        duplicateModel.setModelDescriptionOld(beCopiedEntity.getDescription());
        duplicateModel.setModelBusinessIdOld(beCopiedEntity.getIdentification());
        BpmnModel newModel = bpmnModel.copy(duplicateModel);
        return newModel;
    }

    protected abstract String getNewTemplateResourceData(CommandContext var1);

    protected abstract T getBeCopiedEntity(CommandContext var1, String var2);

    protected abstract String getBeCopiedEntityResourceField();

    protected abstract String getBeCopiedEntityOrgField();

    protected abstract String getBeCopiedEntityNumberField();

    protected abstract String getBeCopiedEntityNameField();

    protected abstract String getBeCopiedEntityDescriptionField();

    protected abstract String getBeCopiedEntityIdentificationField();
}

