/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntityManager;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class CreateModelByTemplateCmd
implements Command<Long> {
    private Long templateId;
    private ModelEntity model;

    public CreateModelByTemplateCmd(Long templateId, ModelEntity model) {
        this.templateId = templateId;
        this.model = model;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ResourceEntity resource = (ResourceEntity)resourceManager.create();
        String fields = String.format("%s,%s,%s,%s,%s,%s,%s,%s", "resourceid", "org", "number", "name", "description", "identification", "preset", "status");
        ProcTemplateEntity template = (ProcTemplateEntity)commandContext.getProcTemplateEntityManager().findById(this.templateId, fields);
        this.model.setTemplateId(this.templateId);
        this.model.setTemplateNumber(template.getNumber());
        ResourceEntity templateResource = (ResourceEntity)resourceManager.findById(template.getResourceId());
        ProcTemplateReleaseLogEntity releaseLog = commandContext.getProcTemplateReleaseLogEntityManager().getLatestReleaseLog(this.templateId);
        if (releaseLog == null) {
            if (template.isPreset() && template.isEnable()) {
                ProcTemplateReleaseLogEntityManager releaseLogManager = commandContext.getProcTemplateReleaseLogEntityManager();
                releaseLog = (ProcTemplateReleaseLogEntity)releaseLogManager.create();
                releaseLog.setProcTplId(this.templateId);
                ResourceEntity newResource = (ResourceEntity)resourceManager.create();
                newResource.setData(templateResource.getData());
                newResource.setContent(templateResource.getContent());
                newResource.setName(templateResource.getName());
                resourceManager.insert(newResource);
                releaseLog.setVersion(1);
                releaseLog.setNewResourceId(newResource.getId());
                releaseLogManager.insert(releaseLog);
            }
        } else {
            this.model.setTemplateVersion(releaseLog.getVersion());
        }
        commandContext.getModelEntityManager().insert(this.model);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(templateResource.getData());
        DuplicateModel duplicateModel = new DuplicateModel();
        duplicateModel.setModelKey(this.model.getKey());
        duplicateModel.setModelName(this.model.getName());
        duplicateModel.setModelBusinessId(this.model.getBusinessId());
        duplicateModel.setModelDescription(this.model.getDescription());
        duplicateModel.setSubprocess("sub".equals(this.model.getPrimarySubprocess()));
        if (!this.model.getOrgUnitId().equals(template.getOrgId())) {
            duplicateModel.setModelOrgunitid(this.model.getOrgUnitId());
        }
        duplicateModel.setModelKeyOld(template.getNumber());
        duplicateModel.setModelNameOld(template.getName());
        duplicateModel.setModelDescriptionOld(template.getDescription());
        duplicateModel.setModelBusinessIdOld(template.getIdentification());
        BpmnModel newModel = bpmnModel.copy(duplicateModel);
        Process newProcess = newModel.getMainProcess();
        if (ModelType.NoCodeFlow.name().equals(this.model.getType())) {
            newProcess.setResourceId(String.valueOf(this.model.getId()));
        }
        this.model.setOperation(newProcess.getTriggerMode());
        String data = GraphCodecUtils.convertBpmnModelToJSON(newModel);
        resource.setData(data);
        resource.setName(String.format("%s.%s", template.getNumber(), "graph_json"));
        resourceManager.insert(resource);
        Long resourceId = resource.getId();
        this.model.setBPMNXMLID(resourceId);
        commandContext.getModelEntityManager().update(this.model);
        String name = String.valueOf(this.model.getName());
        ExtractMultiLanguageWordsUtil.extractWordsAndSaveOrUpdate(resourceId, name, this.model.getId(), "", this.model.getKey());
        String appType = "wf";
        if ("BizFlow".equals(this.model.getType())) {
            appType = "bpm";
        }
        WfUtils.addOpLogByAppType(appType, "wf_model", "createModelByTemplate", new MultiLangEnumBridge("\u901a\u8fc7\u5f15\u7528\u6d41\u7a0b\u6a21\u677f\u521b\u5efa\u6d41\u7a0b", "CreateModelByTemplateCmd_1", "bos-wf-engine"), new MultiLangEnumBridge("\u6a21\u677f\u6d41\u7a0b[%1$s]\uff0c\u65b0\u5efa\u6d41\u7a0b[%2$s]", "CreateModelByTemplateCmd_2", "bos-wf-engine"), template.getNumber(), this.model.getKey());
        return this.model.getId();
    }
}

