/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.proctpl.CreateModelByTemplateCmd;
import kd.bos.workflow.engine.impl.cmd.proctpl.EntityProcessor;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityManager;

public class CreateProcessesByTemplatesCmd
implements Command<Map<Long, Long>> {
    private String appId;
    private List<Long> templateIds;
    private EntityProcessor entityProcessor;
    private Map<String, String> entityIdRelation;
    private Map<Long, Long> resourceModelMap = new HashMap<Long, Long>();
    private Map<Long, Long> modelTemplateMap = new HashMap<Long, Long>();
    private Log log = LogFactory.getLog(this.getClass());
    private long index = System.currentTimeMillis();

    public CreateProcessesByTemplatesCmd(String appId, List<Long> templateIds, Map<String, String> entityMap, Map<String, String> roleMap) {
        this.appId = appId;
        this.templateIds = templateIds;
        this.entityIdRelation = entityMap != null ? entityMap : new HashMap();
        this.entityProcessor = new EntityProcessor(this.entityIdRelation, roleMap);
    }

    @Override
    public Map<Long, Long> execute(CommandContext commandContext) {
        HashMap<Long, Long> ret = new HashMap<Long, Long>(16);
        DynamicObject app = BizAppServiceHelp.getBizAppByID((String)this.appId);
        if (app == null) {
            this.log.debug(String.format("invalid appId: %s", this.appId));
            return ret;
        }
        if (this.templateIds == null || this.templateIds.isEmpty()) {
            this.log.debug("templateIds is null.");
            return ret;
        }
        this.log.debug(String.format("CreateProcessesByTemplates: appId:%s templateIds:%s entityMap:%s roleMap:%s", this.appId, this.templateIds, this.entityIdRelation, this.entityProcessor.getRoleIdRelationString()));
        ret = new HashMap(this.templateIds.size());
        Date now = WfUtils.now();
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        long userId = requestContext.getCurrUserId();
        ProcTemplateEntityManager tplManager = commandContext.getProcTemplateEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", this.templateIds)};
        List templates = tplManager.findByQueryFilters(filters);
        String processType = ((ProcTemplateEntity)templates.get(0)).getProcessType();
        Long procCategoryId = commandContext.getProcessCategoryEntityManager().getOrCreateCategory(null, this.appId, processType);
        ModelEntityImpl modelEntity = null;
        ArrayList<Long> modelIds = new ArrayList<Long>(templates.size());
        for (ProcTemplateEntity template : templates) {
            String newEntityId;
            String procNumber = this.generateProcNumber(template);
            modelEntity = new ModelEntityImpl();
            modelEntity.setKey(procNumber);
            modelEntity.setBusinessId(procNumber);
            modelEntity.setCategory(procCategoryId);
            modelEntity.setType(template.getProcessType());
            modelEntity.setCreatorId(userId);
            modelEntity.setModifierId(userId);
            modelEntity.setOrgUnitId(orgId);
            String entityId = template.getEntityId();
            String entityNumber = template.getEntityNumber();
            String string = newEntityId = entityId != null ? this.entityIdRelation.get(entityId) : null;
            if (newEntityId != null) {
                modelEntity.setEntraBillId(newEntityId);
                String newEntityNumber = this.entityProcessor.getEntityNumber(newEntityId);
                modelEntity.setEntraBill(newEntityNumber);
            } else {
                modelEntity.setEntraBillId(entityId);
                modelEntity.setEntraBill(entityNumber);
            }
            modelEntity.setName(template.getName());
            modelEntity.setApplicationId(this.appId);
            modelEntity.setCreateDate(now);
            Long templateId = template.getId();
            Long modelId = new CreateModelByTemplateCmd(templateId, modelEntity).execute(commandContext);
            modelIds.add(modelId);
            ret.put(templateId, modelId);
            this.modelTemplateMap.put(modelId, templateId);
        }
        if (this.entityIdRelation.isEmpty()) {
            return ret;
        }
        String fields = String.format("%s,%s", "id", "bpmnxmlid");
        List<ModelEntity> models = commandContext.getModelEntityManager().findModelEntitiesByIds(modelIds, fields);
        for (ModelEntity model : models) {
            this.resourceModelMap.put(model.getBPMNXMLID(), model.getId());
        }
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        List<ResourceEntity> resources = resourceManager.findResourcesByIds(this.resourceModelMap.keySet());
        for (ResourceEntity resource : resources) {
            this.replaceEntityInfoEtc(resourceManager, resource, ret);
        }
        return ret;
    }

    private void replaceEntityInfoEtc(ResourceEntityManager resourceManager, ResourceEntity resource, Map<Long, Long> templateModelMap) {
        String data = resource.getData();
        Long modelId = this.resourceModelMap.get(resource.getId());
        Long templateId = this.modelTemplateMap.get(modelId);
        String newData = this.entityProcessor.getReplacedData(data, templateId, modelId);
        newData = this.entityProcessor.getReplacedData(newData, templateModelMap);
        resource.setData(newData);
        resourceManager.update(resource);
    }

    private String generateProcNumber(ProcTemplateEntity template) {
        String newEntityId;
        String type = null;
        String processType = template.getProcessType();
        String entityNumber = template.getEntityNumber();
        String entityId = template.getEntityId();
        if (WfUtils.isNotEmpty(entityId) && WfUtils.isNotEmpty(newEntityId = this.entityProcessor.getNewEntityId(entityId))) {
            entityNumber = this.entityProcessor.getEntityNumber(newEntityId);
        }
        switch (processType) {
            case "NoCodeFlow": {
                type = "nocode";
                break;
            }
            case "BizFlow": {
                type = "bizflow";
                break;
            }
            default: {
                type = "audit";
            }
        }
        return String.format("Proc_%s_%s_%s", entityNumber, type, this.index++);
    }
}

