/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityManager;

public class DeleteProcTemplateCategoryCmd
implements Command<String> {
    private Long categoryId;
    private boolean confirm;

    public DeleteProcTemplateCategoryCmd(Long categoryId, boolean confirm) {
        this.categoryId = categoryId;
        this.confirm = confirm;
    }

    @Override
    public String execute(CommandContext commandContext) {
        QFilter categoryFilter = null;
        QFilter[] filters = new QFilter[]{new QFilter("parent", "=", (Object)this.categoryId)};
        String field = this.confirm ? "id" : "category";
        ProcTemplateCategoryEntityManager categoryManager = commandContext.getProcTemplateCategoryEntityManager();
        List childrenCategories = categoryManager.findByQueryFilters(filters, "id", null);
        if (!childrenCategories.isEmpty()) {
            HashSet<Long> ids = new HashSet<Long>(childrenCategories.size() + 1);
            ids.add(this.categoryId);
            for (ProcTemplateCategoryEntity category : childrenCategories) {
                ids.add(category.getId());
            }
            categoryFilter = new QFilter(field, "in", ids);
        } else {
            categoryFilter = new QFilter(field, "=", (Object)this.categoryId);
        }
        if (this.confirm) {
            this.confirmDelete(categoryManager, categoryFilter);
            return null;
        }
        return this.verifyCanDelete(commandContext, categoryFilter);
    }

    private void confirmDelete(ProcTemplateCategoryEntityManager categoryManager, QFilter categoryFilter) {
        categoryManager.deleteByFilters(new QFilter[]{categoryFilter});
    }

    private String verifyCanDelete(CommandContext commandContext, QFilter categoryFilter) {
        long count = commandContext.getProcTemplateEntityManager().countByFilter("id", new QFilter[]{categoryFilter}, false);
        if (count > 0L) {
            return ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u4e0b\u5b58\u5728\u5ba1\u6279\u6d41\u6216\u4e1a\u52a1\u6d41\u6d41\u7a0b\u6a21\u677f\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DeleteProcTemplateCategoryCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return null;
    }
}

