/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntityManager;

public class DeleteProcTemplatesCmd
implements Command<Void> {
    private List<Long> templateIds;

    public DeleteProcTemplatesCmd(List<Long> templateIds) {
        this.templateIds = templateIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ProcTemplateEntityManager procTplManager = commandContext.getProcTemplateEntityManager();
        ProcTemplateReleaseLogEntityManager procTplReleaseLogManager = commandContext.getProcTemplateReleaseLogEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", this.templateIds)};
        List templates = procTplManager.findByQueryFilters(filters, "resourceid", null);
        for (ProcTemplateEntity template : templates) {
            resourceManager.delete(template.getResourceId());
            procTplReleaseLogManager.deleteByProcTplId(template.getId());
            procTplManager.delete(template);
        }
        return null;
    }
}

