/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntityManager;

public class EnableProcTemplateCmd
implements Command<List<Long>> {
    private List<Long> templateIds;

    public EnableProcTemplateCmd(List<Long> templateIds) {
        this.templateIds = templateIds;
    }

    @Override
    public List<Long> execute(CommandContext commandContext) {
        ProcTemplateEntityManager templateManager = commandContext.getProcTemplateEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", this.templateIds), new QFilter("status", "=", (Object)"disable")};
        List templates = templateManager.findByQueryFilters(filters);
        ArrayList<Long> retIds = new ArrayList<Long>(templates.size());
        for (ProcTemplateEntity template : templates) {
            this.enableProcTemplate(commandContext, template);
            retIds.add(template.getId());
        }
        return retIds;
    }

    private void enableProcTemplate(CommandContext commandContext, ProcTemplateEntity template) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ProcTemplateReleaseLogEntityManager releaseLogManager = commandContext.getProcTemplateReleaseLogEntityManager();
        Long templateId = template.getId();
        ProcTemplateReleaseLogEntity latestReleaseLog = releaseLogManager.getLatestReleaseLog(templateId);
        ProcTemplateReleaseLogEntity releaseLogEntity = (ProcTemplateReleaseLogEntity)releaseLogManager.create();
        releaseLogEntity.setProcTplId(templateId);
        ResourceEntity templateResource = (ResourceEntity)resourceManager.findById(template.getResourceId());
        ResourceEntity newResource = (ResourceEntity)resourceManager.create();
        newResource.setData(templateResource.getData());
        newResource.setContent(templateResource.getContent());
        resourceManager.insert(newResource);
        releaseLogEntity.setNewResourceId(newResource.getId());
        int version = 1;
        if (latestReleaseLog != null) {
            version = latestReleaseLog.getVersion() + 1;
            releaseLogEntity.setOldResourceId(latestReleaseLog.getNewResourceId());
        }
        releaseLogEntity.setVersion(version);
        releaseLogManager.insert(releaseLogEntity);
        template.setEnable(true);
        commandContext.getProcTemplateEntityManager().update(template);
    }
}

