/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class EntityProcessor {
    private Map<String, String> entityIdRelation = new HashMap<String, String>();
    private Map<String, String> entityIdNameMap = new HashMap<String, String>();
    private Map<String, String> entityIdNumberMap = new HashMap<String, String>();
    private Map<String, String> roleIdRelation = new HashMap<String, String>();
    private static final String TPL = "\"%s\"";
    private static final String SLASHTPL = "\\\\\"%s\\\\\"";
    private static final String SINGLEQUOTTPL = "'%s'";
    private Log log = LogFactory.getLog(this.getClass());

    public EntityProcessor(Map<String, String> entityIdRelation, Map<String, String> roleIdRelation) {
        if (entityIdRelation != null && !entityIdRelation.isEmpty()) {
            this.entityIdRelation = entityIdRelation;
            this.initEntityInfo();
        }
        if (roleIdRelation != null && !roleIdRelation.isEmpty()) {
            this.roleIdRelation = roleIdRelation;
        }
    }

    private void initEntityInfo() {
        HashSet<String> entityIds = new HashSet<String>(this.entityIdRelation.keySet());
        entityIds.addAll(this.entityIdRelation.values());
        QFilter[] filters = new QFilter[]{new QFilter("dentityid", "in", entityIds)};
        DynamicObjectCollection entities = QueryServiceHelper.query((String)"bos_entityobject", (String)"name,number,dentityid", (QFilter[])filters);
        if (entities == null || entities.isEmpty()) {
            return;
        }
        int size = entities.size();
        this.entityIdNameMap = new HashMap<String, String>(size);
        this.entityIdNumberMap = new HashMap<String, String>(size);
        for (DynamicObject entity : entities) {
            String entityId = entity.getString("dentityid");
            String number = entity.getString("number");
            String name = entity.getString("name");
            this.entityIdNameMap.put(entityId, name);
            this.entityIdNumberMap.put(entityId, number);
        }
    }

    public String getReplacedData(String data, Long id, Long newId) {
        for (Map.Entry<String, String> entry : this.entityIdRelation.entrySet()) {
            String entityId = entry.getKey();
            String newEntityId = entry.getValue();
            String entityName = this.entityIdNameMap.get(entityId);
            String newEntityName = this.entityIdNameMap.get(newEntityId);
            String entityNumber = this.entityIdNumberMap.get(entityId);
            String newEntityNumber = this.entityIdNumberMap.get(newEntityId);
            if (WfUtils.isNotEmpty(entityId) && newEntityId != null) {
                data = data.replaceAll(entityId, newEntityId);
                data = data.replaceAll(String.format(SLASHTPL, entityId), String.format(SLASHTPL, newEntityId));
                data = data.replaceAll(String.format(SINGLEQUOTTPL, entityId), String.format(SINGLEQUOTTPL, newEntityId));
            }
            if (WfUtils.isNotEmpty(entityName) && newEntityName != null) {
                data = data.replaceAll(String.format(TPL, entityName), String.format(TPL, newEntityName));
            }
            if (!WfUtils.isNotEmpty(entityNumber) || newEntityNumber == null) continue;
            data = data.replaceAll(String.format(TPL, entityNumber), String.format(TPL, newEntityNumber));
            data = data.replaceAll(String.format(SLASHTPL, entityNumber), String.format(SLASHTPL, newEntityNumber));
            data = data.replaceAll(String.format(SINGLEQUOTTPL, entityNumber), String.format(SINGLEQUOTTPL, newEntityNumber));
        }
        if (WfUtils.isNotEmpty(id) && WfUtils.isNotEmpty(newId)) {
            data = data.replaceAll(String.format(TPL, id), String.format(TPL, newId));
        }
        for (Map.Entry<String, String> entry : this.roleIdRelation.entrySet()) {
            String roleId = entry.getKey();
            String newRoleId = entry.getValue();
            if (!WfUtils.isNotEmpty(roleId) || !WfUtils.isNotEmpty(newRoleId)) continue;
            roleId = roleId.replaceAll("\\+", "\\\\+");
            data = data.replaceAll(String.format(TPL, roleId), String.format(TPL, newRoleId));
            data = data.replaceAll(String.format(SLASHTPL, roleId), String.format(SLASHTPL, newRoleId));
        }
        return data;
    }

    public String getReplacedData(String data, Map<Long, Long> idMap) {
        for (Map.Entry<Long, Long> entry : idMap.entrySet()) {
            Long id = entry.getKey();
            Long newId = entry.getValue();
            data = data.replaceAll(String.format(TPL, id), String.format(TPL, newId));
        }
        return data;
    }

    public void addNullEntityIdRelation(String entityNumber, String entityId) {
        this.entityIdRelation.put(entityId, "");
        this.entityIdNumberMap.put(entityId, entityNumber);
        this.entityIdNumberMap.put("", "");
        this.entityIdNameMap.put("", "");
        try {
            String entityName = String.valueOf(EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName());
            this.entityIdNameMap.put(entityId, entityName);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    public String getNewEntityId(String entityId) {
        return this.entityIdRelation.get(entityId);
    }

    public String getEntityNumber(String entityId) {
        return this.entityIdNumberMap.get(entityId);
    }

    public String getEntityName(String entityId) {
        return this.entityIdNameMap.get(entityId);
    }

    public String getEntityIdRelationString() {
        return String.valueOf(this.entityIdRelation);
    }

    public String getRoleIdRelationString() {
        return String.valueOf(this.roleIdRelation);
    }
}

