/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.proctpl.GetProcTemplatePresetSQLCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import org.apache.commons.io.FilenameUtils;

public class ExportProcTemplatePresetSQL
implements Command<File> {
    private String app;
    private String zipFilePath;
    private List<Long> templateIds;
    private String preinsdataPath;
    private Log log = LogFactory.getLog(this.getClass());
    private GetProcTemplatePresetSQLCmd presetSQLCmd;

    public ExportProcTemplatePresetSQL(String app, String zipFilePath, List<Long> templateIds) {
        this.app = app;
        this.zipFilePath = zipFilePath;
        this.templateIds = templateIds;
        this.presetSQLCmd = new GetProcTemplatePresetSQLCmd(app);
        this.preinsdataPath = String.format("preinsdata%s", File.separator);
    }

    @Override
    public File execute(CommandContext commandContext) {
        File zipFile = new File(FilenameUtils.getName((String)this.zipFilePath));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            ZipEntry dataFolder = new ZipEntry(this.preinsdataPath);
            out.putNextEntry(dataFolder);
            out.closeEntry();
            StringBuilder sqlScripts = new StringBuilder();
            for (Long templateId : this.templateIds) {
                String fileName = this.exportPresetSQL(commandContext, out, templateId);
                sqlScripts.append(String.format("\t<SqlScript Type=\"KSQL\" Separator=\";\" dbkey=\"wf\" Plugin=\"cloud:bos,app:wf,class:presetProcTemplateService\">preinsdata/%s</SqlScript>", fileName)).append("\n");
            }
            String xmlFileContent = this.getWfXmlFileContent(sqlScripts);
            this.writeStringToZipEntry(out, String.format("%s.xml", this.app), xmlFileContent);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
        return zipFile;
    }

    private String getWfXmlFileContent(StringBuilder sqlScripts) {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        content.append("<DataModel dympath=\"metadata\" xmlpath=\"preinsdata/xml\">").append("\n");
        content.append((CharSequence)sqlScripts);
        content.append("</DataModel>");
        return content.toString();
    }

    private String exportPresetSQL(CommandContext commandContext, ZipOutputStream out, Long templateId) throws IOException {
        this.presetSQLCmd.setTemplateId(templateId);
        String presetSQL = this.presetSQLCmd.execute(commandContext);
        String sqlFileName = this.presetSQLCmd.getSqlFileName();
        this.writeStringToZipEntry(out, String.format("%s%s", this.preinsdataPath, sqlFileName), presetSQL);
        return sqlFileName;
    }

    private void writeStringToZipEntry(ZipOutputStream out, String zipEntryPath, String content) throws IOException {
        try (ByteArrayInputStream ins = new ByteArrayInputStream(content.getBytes());){
            ZipEntry xmlFile = new ZipEntry(zipEntryPath);
            out.putNextEntry(xmlFile);
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = ins.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
        }
    }

    @Deprecated
    public String getSQLFileVersion() {
        return this.presetSQLCmd.getSQLFileVersion();
    }
}

