/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;

public class GetProcTemplateCategoryTreeCmd
implements Command<TreeNode> {
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public TreeNode execute(CommandContext commandContext) {
        String rootId = "0";
        TreeNode rootNode = new TreeNode(null, rootId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"GetProcTemplateCategoryTreeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        List<ProcTemplateCategoryEntity> ret = commandContext.getProcTemplateCategoryEntityManager().findAllProcTemplateCategories(this.getSelectFields());
        if (ret.isEmpty()) {
            return rootNode;
        }
        rootNode.setIsOpened(true);
        List<Long> children = null;
        ArrayList<Long> parents = new ArrayList<Long>(16);
        LinkedHashMap<Long, ProcTemplateCategoryEntity> entityMap = new LinkedHashMap<Long, ProcTemplateCategoryEntity>(ret.size());
        LinkedHashMap<Long, ArrayList<Long>> relation = new LinkedHashMap<Long, ArrayList<Long>>(16);
        for (ProcTemplateCategoryEntity entity : ret) {
            Long id = entity.getId();
            entityMap.put(id, entity);
            Long parentId = entity.getParentId();
            if (WfUtils.isEmpty(parentId)) {
                parents.add(id);
                children = (List)relation.get(id);
                if (children != null) continue;
                children = new ArrayList<Long>();
                relation.put(id, (ArrayList<Long>)children);
                continue;
            }
            children = (ArrayList<Long>)relation.get(parentId);
            if (children != null) {
                children.add(id);
                continue;
            }
            this.log.warn(String.format("build relationship failed! id: %s, parentId: %s", id, parentId));
        }
        ProcTemplateCategoryEntity parent = null;
        ProcTemplateCategoryEntity child = null;
        for (Long parentId : parents) {
            parent = (ProcTemplateCategoryEntity)entityMap.get(parentId);
            TreeNode parentNode = new TreeNode(rootId, String.valueOf(parent.getId()), parent.getCategoryName());
            rootNode.addChild(parentNode);
            List childIds = (List)relation.get(parentId);
            if (childIds == null || childIds.isEmpty()) continue;
            parentNode.setIsOpened(true);
            for (Long childId : childIds) {
                child = (ProcTemplateCategoryEntity)entityMap.get(childId);
                TreeNode childNode = new TreeNode(rootId, String.valueOf(child.getId()), child.getCategoryName(), false);
                parentNode.addChild(childNode);
            }
        }
        return rootNode;
    }

    private String getSelectFields() {
        return String.format("%s,%s,%s", "name", "id", "parent");
    }
}

