/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.scheme.CompareVersionDifferenceCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogImpl;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntity;

public class GetProcTemplateChangeRecordsCmd
implements Command<List<ModelModifyLogEntity>> {
    private Long releaseLogId;
    private Log log = LogFactory.getLog(this.getClass());

    public GetProcTemplateChangeRecordsCmd(Long releaseLogId) {
        this.releaseLogId = releaseLogId;
    }

    @Override
    public List<ModelModifyLogEntity> execute(CommandContext commandContext) {
        ProcTemplateReleaseLogEntity releaseLog = (ProcTemplateReleaseLogEntity)commandContext.getProcTemplateReleaseLogEntityManager().findById(this.releaseLogId);
        Long oldResId = releaseLog.getOldResourceId();
        Long newResId = releaseLog.getNewResourceId();
        if (WfUtils.isEmpty(oldResId) || WfUtils.isEmpty(newResId)) {
            this.log.debug(String.format("oldResId(%s) is null or newResId(%s) is null.", oldResId, newResId));
            return new ArrayList<ModelModifyLogEntity>();
        }
        String oldResourceJson = null;
        String newResourceJson = null;
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        EntityQueryBuilder resourceQueryBuilder = resourceManager.createQueryBuilder();
        resourceQueryBuilder.addFilter("id", "in", new Long[]{oldResId, newResId});
        List resources = resourceManager.findByQueryBuilder(resourceQueryBuilder);
        for (ResourceEntity resource : resources) {
            if (oldResId.equals(resource.getId())) {
                oldResourceJson = resource.getData();
                continue;
            }
            newResourceJson = resource.getData();
        }
        ModelModifyLogImpl modifyLog = new ModelModifyLogImpl(null, null, newResId);
        return new CompareVersionDifferenceCmd(newResourceJson, oldResourceJson, modifyLog, new HashSet<String>()).execute(commandContext);
    }
}

