/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.bpmn.model.deploy.ProcTemplateExportModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.GetDeployModelFileCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;

public class GetProcTemplateExportFileCmd
extends GetDeployModelFileCmd {
    private Long templateId;
    private transient CommandContext commandContext;
    private static final long serialVersionUID = 6926638869136939628L;

    public GetProcTemplateExportFileCmd(Long templateId) {
        super(0L);
        this.templateId = templateId;
    }

    @Override
    public DeployFile execute(CommandContext commandContext) {
        this.commandContext = commandContext;
        return this.getDeployModel(commandContext, this.templateId);
    }

    @Override
    protected DynamicObject loadModel(Long id, DeployModel deploy) {
        ProcTemplateEntity template = (ProcTemplateEntity)this.commandContext.getProcTemplateEntityManager().findById(id);
        DynamicObject dynamicObject = template.getDynamicObject();
        ((ProcTemplateExportModel)deploy).getTemplates().add(dynamicObject);
        return dynamicObject;
    }

    @Override
    protected void loadCategory(DeployModel deploy, DynamicObject template) {
        DynamicObject category = template.getDynamicObject("category");
        if (category == null) {
            this.logger.debug(String.format("%s no category.", template.getPkValue()));
            return;
        }
        ProcTemplateCategoryEntityManager categoryManager = this.commandContext.getProcTemplateCategoryEntityManager();
        ProcTemplateCategoryEntity procTplCategory = (ProcTemplateCategoryEntity)categoryManager.findById((Long)category.getPkValue());
        deploy.getCategories().add(procTplCategory.getDynamicObject());
        if (WfUtils.isEmpty(procTplCategory.getParentId())) {
            return;
        }
        ProcTemplateCategoryEntity parentCategory = (ProcTemplateCategoryEntity)categoryManager.findById(procTplCategory.getParentId());
        if (parentCategory != null) {
            deploy.getCategories().add(parentCategory.getDynamicObject());
        }
    }

    @Override
    protected DeployModel getDeployModel() {
        return new ProcTemplateExportModel();
    }

    @Override
    protected long getResourceId(DynamicObject template) {
        return template.getLong("resourceid");
    }

    @Override
    protected String getDeployFileName(DynamicObject template) {
        return String.format("%s.proctpl", template.getString("number"));
    }

    @Override
    protected String getEntityNumber(DynamicObject template) {
        return template.getString("entity");
    }

    @Override
    protected void executeListener(CommandContext commandContext, DynamicObject model) {
    }
}

