/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.Calendar;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.ORM;
import kd.bos.workflow.engine.impl.cmd.proctpl.GetProcTemplateExportFileCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetProcTemplatePresetSQLCmd
implements Command<String> {
    private String app;
    private Long templateId;
    private String sqlFileName;
    private ORM orm = ORM.create();
    private MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"wf_deploysql");
    private EntityType entryEntityType = (EntityType)this.entityType.getAllEntities().get("entryentity");

    protected GetProcTemplatePresetSQLCmd(String app) {
        this.app = app;
    }

    public GetProcTemplatePresetSQLCmd(String app, Long templateId) {
        this.app = app;
        this.templateId = templateId;
    }

    protected void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    protected String getSqlFileName() {
        return this.sqlFileName;
    }

    @Override
    public String execute(CommandContext commandContext) {
        long entryId;
        int i;
        long id = this.orm.genLongId((IDataEntityType)this.entityType);
        DeployFile deployFile = new GetProcTemplateExportFileCmd(this.templateId).execute(commandContext);
        String content = SerializationUtils.serializeToBase64((Object)deployFile.getFileContent());
        String templateFileName = deployFile.getFileName();
        String version = this.getSQLFileVersion();
        String fileName = templateFileName.replace(".proctpl", "");
        this.sqlFileName = String.format("kd_%s_%s_%s.sql", version, this.app, fileName);
        String newline = "\n";
        StringBuilder presetSQL = new StringBuilder();
        presetSQL.append(String.format("DELETE FROM T_WF_DEPLOYSQL WHERE FID = %s;", id)).append(newline);
        presetSQL.append(String.format("DELETE FROM T_WF_DEPLOYSQLDETAIL WHERE FID = %s;", id)).append(newline);
        presetSQL.append(String.format("INSERT INTO T_WF_DEPLOYSQL(FID, FFILENAME, FFILECONTENT, FTYPE) VALUES(%s, '%s', '', 'proctpl');", id, this.sqlFileName)).append(newline);
        int batchSize = 2000;
        int size = content.length();
        int count = size / batchSize;
        int remainder = size % batchSize;
        int nextSubStringSize = 0;
        String insertSQLContentTpl = "INSERT INTO T_WF_DEPLOYSQLDETAIL(FID, FENTRYID, FSEQ, FCONTENT) VALUES(%s, %s, %s, '%s');";
        long[] ids = this.orm.genLongIds((IDataEntityType)this.entryEntityType, count);
        for (i = 0; i < count; ++i) {
            entryId = ids[i];
            nextSubStringSize = (i + 1) * batchSize;
            String batch = content.substring(i * batchSize, nextSubStringSize);
            presetSQL.append(String.format(insertSQLContentTpl, id, entryId, i, batch)).append(newline);
        }
        if (remainder > 0) {
            entryId = this.orm.genLongId((IDataEntityType)this.entryEntityType);
            String lastBatch = content.substring(nextSubStringSize, size);
            presetSQL.append(String.format(insertSQLContentTpl, id, entryId, i, lastBatch)).append(newline);
        }
        return presetSQL.toString();
    }

    protected String getSQLFileVersion() {
        int version = 173;
        Calendar base = Calendar.getInstance();
        base.set(1, 2022);
        base.set(2, 10);
        base.set(5, 27);
        base.set(11, 23);
        base.set(12, 59);
        base.set(13, 59);
        Calendar current = Calendar.getInstance();
        long weekTimeInMillis = 604800000L;
        long interval = current.getTimeInMillis() - base.getTimeInMillis();
        long weeks = interval / weekTimeInMillis;
        if (interval % weekTimeInMillis != 0L) {
            ++weeks;
        }
        return String.format("1.5.%s", (long)version + weeks);
    }
}

