/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.model.ProcessTemplate;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityManager;

public class GetProcessTemplatesCmd
implements Command<List<ProcessTemplate>> {
    private String appId;
    private Log log = LogFactory.getLog(this.getClass());

    public GetProcessTemplatesCmd(String appId) {
        this.appId = appId;
    }

    @Override
    public List<ProcessTemplate> execute(CommandContext commandContext) {
        ArrayList<Object> templates = new ArrayList<ProcessTemplate>(16);
        ProcTemplateCategoryEntityManager categoryManager = commandContext.getProcTemplateCategoryEntityManager();
        ProcTemplateCategoryEntity category = categoryManager.findProcTemplateCategoryByAppId(this.appId, "id");
        if (category == null) {
            this.log.debug(String.format("no category found. appId: %s", this.appId));
            return templates;
        }
        ProcTemplateEntityManager templateManager = commandContext.getProcTemplateEntityManager();
        String fields = String.format("%s,%s,%s,%s,%s", "id", "name", "number", "status", "entity");
        List<ProcTemplateEntity> entities = templateManager.getProcTemplatesByCategoryId(category.getId(), fields);
        if (entities.isEmpty()) {
            this.log.debug(String.format("no template found. appId: %s, categoryId: %s", this.appId, category.getId()));
            return templates;
        }
        templates = new ArrayList(entities.size());
        for (ProcTemplateEntity entity : entities) {
            ProcessTemplate template = new ProcessTemplate();
            template.setId(entity.getId());
            template.setName(entity.getName());
            template.setNumber(entity.getNumber());
            template.setEnable(entity.isEnable());
            template.setEntityNumber(entity.getEntityNumber());
            template.setAppId(this.appId);
            templates.add(template);
        }
        return templates;
    }
}

