/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetReferencedProcTplIdsCmd
implements Command<List<Long>> {
    private List<Long> templateIds;

    public GetReferencedProcTplIdsCmd(List<Long> templateIds) {
        this.templateIds = templateIds;
    }

    @Override
    public List<Long> execute(CommandContext commandContext) {
        HashSet<Long> ids = new HashSet<Long>(this.templateIds.size());
        String params = WfUtils.listToString(this.templateIds, ",");
        String sql = "SELECT FPARENTID FROM T_WF_PROCTPL WHERE FPARENTID IN (%s) GROUP BY FPARENTID HAVING COUNT(FID) > 0;";
        try (DataSet ds = DB.queryDataSet((String)"getBeProcTplReferencedIds", (DBRoute)DBRoute.workflow, (String)String.format(sql, params));){
            for (Row row : ds) {
                ids.add(row.getLong("FPARENTID"));
            }
        }
        sql = "SELECT FTEMPLATEID FROM T_WF_MODEL WHERE FTEMPLATEID IN (%s) GROUP BY FTEMPLATEID HAVING COUNT(FID) > 0;";
        ds = DB.queryDataSet((String)"getBeProcDesignReferencedIds", (DBRoute)DBRoute.workflow, (String)String.format(sql, params));
        var6_6 = null;
        try {
            for (Row row : ds) {
                ids.add(row.getLong("FTEMPLATEID"));
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var6_6 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return new ArrayList<Long>(ids);
    }
}

