/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.deploy.ProcTemplateExportModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.DeployModelCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityManager;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import org.apache.commons.lang.math.NumberUtils;

public class ImportProcTemplateCmd
extends DeployModelCmd {
    private transient ProcTemplateExportModel templateExportModel;

    public ImportProcTemplateCmd(ProcTemplateExportModel templateExportModel, boolean isCover, Boolean isCoverSummaryCfg) {
        super(templateExportModel, isCover, isCoverSummaryCfg);
        this.templateExportModel = templateExportModel;
    }

    @Override
    protected Long importCategoryModelAndResource(CommandContext commandContext) {
        ProcTemplateCategoryEntity category = this.importCategory(commandContext);
        if (this.isCoverModel) {
            this.coverImportTemplate(commandContext, category);
        } else {
            this.importNewTemplate(commandContext, category);
        }
        return null;
    }

    private void coverImportTemplate(CommandContext commandContext, ProcTemplateCategoryEntity category) {
        ProcTemplateEntityManager templateManager = commandContext.getProcTemplateEntityManager();
        List<DynamicObject> templates = this.templateExportModel.getTemplates();
        DynamicObject template = templates.get(0);
        String templateNumber = template.getString("number");
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)templateNumber)};
        List entities = templateManager.findByQueryFilters(filters);
        ProcTemplateEntity templateEntity = (ProcTemplateEntity)entities.get(0);
        templateEntity.setCategoryId(category.getId());
        this.updateTemplateFields(commandContext, template, templateEntity);
        templateManager.update(templateEntity);
        this.createOrUpdateResource(commandContext, template.getLong("resourceid"), templateEntity.getResourceId(), template, templateEntity, false);
    }

    private void importNewTemplate(CommandContext commandContext, ProcTemplateCategoryEntity category) {
        ProcTemplateEntityManager templateManager = commandContext.getProcTemplateEntityManager();
        List<DynamicObject> templates = this.templateExportModel.getTemplates();
        DynamicObject template = templates.get(0);
        ProcTemplateEntity templateEntity = (ProcTemplateEntity)templateManager.create();
        templateEntity.setCategoryId(category.getId());
        templateEntity.setId(template.getLong("id"));
        this.updateTemplateFields(commandContext, template, templateEntity);
        templateEntity.setNumber(template.getString("number"));
        Long resourceId = this.createOrUpdateResource(commandContext, template.getLong("resourceid"), null, template, templateEntity, true);
        templateEntity.setResourceId(resourceId);
        templateManager.insert(templateEntity);
    }

    private void updateTemplateFields(CommandContext commandContext, DynamicObject template, ProcTemplateEntity templateEntity) {
        templateEntity.setDescription(template.getLocaleString("description"));
        templateEntity.setEntityNumber(template.getString("entity_id"));
        templateEntity.setIdentification(template.getString("identification"));
        templateEntity.setName(template.getLocaleString("name"));
        templateEntity.setOrgId(template.getLong("org_id"));
        templateEntity.setCategoryId(template.getLong("category_id"));
        templateEntity.setProcessType(template.getString("processtype"));
        templateEntity.setPreset(template.getBoolean("preset"));
        if (templateEntity.isPreset()) {
            templateEntity.setEnable("enable".equals(template.getString("status")));
        } else {
            templateEntity.setEnable(false);
        }
        Long parentId = template.getLong("parent_id");
        if (WfUtils.isNotEmpty(parentId) && commandContext.getProcTemplateEntityManager().getProcTemplateById(parentId) != null) {
            templateEntity.setParentId(parentId);
            templateEntity.setParentVersion(template.getInt("parentversion"));
            templateEntity.setLevel(template.getString("level"));
        } else {
            templateEntity.setLevel("1");
            templateEntity.setParentId(0L);
            templateEntity.setParentVersion(0);
        }
    }

    private Long createOrUpdateResource(CommandContext commandContext, Long resourceId, Long dbResourceId, DynamicObject originalTemplate, ProcTemplateEntity newTemplate, boolean create) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ResourceEntity templateResource = null;
        templateResource = create ? (ResourceEntity)resourceManager.create() : (ResourceEntity)resourceManager.findById(dbResourceId);
        List<DynamicObject> resources = this.templateExportModel.getResources();
        long originalResourceId = NumberUtils.LONG_ZERO;
        for (DynamicObject resource : resources) {
            if (!resource.getPkValue().equals(resourceId)) continue;
            this.setResourceData(resource, templateResource);
            originalResourceId = resource.getLong("id");
            break;
        }
        if (create) {
            resourceManager.insert(templateResource);
        } else {
            resourceManager.update(templateResource);
        }
        ImportExportProcessUtil.insertOrUpdateResRelation(originalTemplate, originalResourceId, newTemplate, templateResource.getId(), this.isCoverModel);
        return templateResource.getId();
    }

    private ProcTemplateCategoryEntity importCategory(CommandContext commandContext) {
        ProcTemplateCategoryEntity parent;
        List<DynamicObject> categories = this.templateExportModel.getCategories();
        if (categories == null || categories.isEmpty()) {
            return null;
        }
        Long id = 0L;
        Long parentId = 0L;
        String number = "";
        String parentNumber = "";
        int size = categories.size();
        DynamicObject category = null;
        DynamicObject parentCategory = null;
        HashSet<Long> ids = new HashSet<Long>(size);
        HashSet<String> numbers = new HashSet<String>(size);
        for (DynamicObject tplCategory : categories) {
            if (WfUtils.isNotEmpty(tplCategory.getLong("parent_id"))) {
                category = tplCategory;
                id = tplCategory.getLong("id");
                ids.add(id);
                number = tplCategory.getString("number");
                numbers.add(number);
                continue;
            }
            parentCategory = tplCategory;
            parentId = tplCategory.getLong("id");
            ids.add(parentId);
            parentNumber = tplCategory.getString("number");
            numbers.add(parentNumber);
        }
        ProcTemplateCategoryEntityManager categoryManager = commandContext.getProcTemplateCategoryEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids).or(new QFilter("number", "in", numbers))};
        ProcTemplateCategoryEntity existCategory = null;
        ProcTemplateCategoryEntity existParentCategory = null;
        ProcTemplateCategoryEntity existSameNumberCategory = null;
        ProcTemplateCategoryEntity existSameNumberParentCategory = null;
        String fields = String.format("%s,%s", "id", "number");
        List entities = categoryManager.findByQueryFilters(filters, fields, null);
        if (!entities.isEmpty()) {
            for (ProcTemplateCategoryEntity entity : entities) {
                if (id.equals(entity.getId())) {
                    existCategory = entity;
                } else if (parentId.equals(entity.getId())) {
                    existParentCategory = entity;
                }
                if (number.equals(entity.getNumber())) {
                    existSameNumberCategory = entity;
                    continue;
                }
                if (!parentNumber.equals(entity.getNumber())) continue;
                existSameNumberParentCategory = entity;
            }
        }
        if (existCategory == null && existSameNumberCategory != null) {
            existCategory = existSameNumberCategory;
        }
        if (existParentCategory == null && existSameNumberParentCategory != null) {
            existParentCategory = existSameNumberParentCategory;
        }
        if (category != null) {
            ProcTemplateCategoryEntity entity;
            if (existCategory != null) {
                return existCategory;
            }
            parent = existParentCategory;
            if (parent == null) {
                parent = categoryManager.createProcTemplateCategory(parentCategory);
                categoryManager.insert(parent);
            }
            entity = categoryManager.createProcTemplateCategory(category);
            entity.setParentId(parent.getId());
            categoryManager.insert(entity);
            return entity;
        }
        if (existParentCategory != null) {
            return existParentCategory;
        }
        parent = categoryManager.createProcTemplateCategory(parentCategory);
        categoryManager.insert(parent);
        return parent;
    }

    @Override
    protected void executeListener(CommandContext commandContext) {
    }
}

