/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.impl.cmd.proctpl.AbstractCreateProcTemplateByTemplateCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;

public class SaveAsProcTemplateCmd
extends AbstractCreateProcTemplateByTemplateCmd<ModelEntity> {
    protected Long modelId;

    public SaveAsProcTemplateCmd(DynamicObject procTplDynObj) {
        super(procTplDynObj);
        this.modelId = this.template.getResourceId();
        this.template.setResourceId(null);
    }

    @Override
    protected String getNewTemplateResourceData(CommandContext commandContext) {
        return this.getCopiedResourceData(commandContext);
    }

    @Override
    protected BpmnModel getCopiedBpmnModel(CommandContext commandContext) {
        BpmnModel copiedBpmnModel = super.getCopiedBpmnModel(commandContext);
        if (copiedBpmnModel != null && copiedBpmnModel.getMainProcess() != null) {
            Process process = copiedBpmnModel.getMainProcess();
            process.setSubProcess(false);
            List<FlowElement> flowElementList = process.getFlowElementList();
            flowElementList.forEach(element -> {
                if (element instanceof AuditTask) {
                    AuditTask auditTask = (AuditTask)element;
                    List<DecisionOption> decisionOptions = auditTask.getDecisionOptions();
                    decisionOptions.removeIf(option -> option.isRejectToParentProcessScene() || option.isTerminateMainProcessScene());
                }
            });
        }
        return copiedBpmnModel;
    }

    @Override
    protected ModelEntity getBeCopiedEntity(CommandContext commandContext, String fields) {
        return (ModelEntity)commandContext.getModelEntityManager().findById(this.modelId, fields);
    }

    @Override
    protected String getBeCopiedEntityResourceField() {
        return "bpmnxmlid";
    }

    @Override
    protected String getBeCopiedEntityOrgField() {
        return "orgunitid";
    }

    @Override
    protected String getBeCopiedEntityNumberField() {
        return "key";
    }

    @Override
    protected String getBeCopiedEntityIdentificationField() {
        return "businessid";
    }

    @Override
    protected String getBeCopiedEntityNameField() {
        return "name";
    }

    @Override
    protected String getBeCopiedEntityDescriptionField() {
        return "description";
    }
}

