/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.proctpl.EntityProcessor;
import kd.bos.workflow.engine.impl.cmd.proctpl.SaveAsProcTemplateCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class SaveAsTemplateAndReplaceEntityInfoCmd
extends SaveAsProcTemplateCmd {
    private EntityProcessor entityProcessor;
    private Log log = LogFactory.getLog(this.getClass());

    public SaveAsTemplateAndReplaceEntityInfoCmd(DynamicObject procTplDynObj, EntityProcessor entityProcessor) {
        super(procTplDynObj);
        this.entityProcessor = entityProcessor;
        this.updateTemplateEntity();
        this.log.debug(String.format("SaveAsTemplateAndReplaceEntityInfo. modelId: %s, entityMap: %s, roleMap: %s", this.modelId, entityProcessor.getEntityIdRelationString(), entityProcessor.getRoleIdRelationString()));
    }

    private void updateTemplateEntity() {
        String entityNumber = this.template.getDynamicObject().getString("entity");
        if (WfUtils.isEmpty(entityNumber)) {
            this.log.debug(String.format("entityNumber is empty. modelId: %s", this.modelId));
            return;
        }
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        String newEntityId = this.entityProcessor.getNewEntityId(entityId);
        if (newEntityId == null) {
            this.log.debug(String.format("not entityId in entityMap, modelId: %s, entityId: %s, entityNumber: %s", this.modelId, entityId, entityNumber));
            this.entityProcessor.addNullEntityIdRelation(entityNumber, entityId);
            return;
        }
        String newEntityNumber = this.entityProcessor.getEntityNumber(newEntityId);
        this.template.setEntityNumber(newEntityNumber);
    }

    @Override
    protected String getCopiedResourceData(CommandContext commandContext) {
        String data = super.getCopiedResourceData(commandContext);
        return this.entityProcessor.getReplacedData(data, this.modelId, this.template.getId());
    }
}

