/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.proctpl.AbstractCreateProcTemplateByTemplateCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;

public class SaveProcTemplateCmd
extends AbstractCreateProcTemplateByTemplateCmd<ProcTemplateEntity> {
    public SaveProcTemplateCmd(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public Long execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.template.getId())) {
            this.createProcTemplate(commandContext);
        } else {
            this.updateProcTemplate(commandContext);
        }
        return this.template.getId();
    }

    private void updateProcTemplate(CommandContext commandContext) {
        commandContext.getProcTemplateEntityManager().update(this.template);
        Long resourceId = this.template.getResourceId();
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ResourceEntity resource = (ResourceEntity)resourceManager.findById(resourceId);
        JSONObject data = JSON.parseObject((String)resource.getData());
        JSONObject properties = data.getJSONObject("properties");
        if (this.template.getName() != null) {
            properties.put("name", (Object)this.template.getName().getLocaleValue());
        }
        if (this.template.getDescription() != null) {
            properties.put("documentation", (Object)this.template.getDescription().getLocaleValue());
        } else {
            properties.put("documentation", null);
        }
        properties.put("businessId", (Object)this.template.getIdentification());
        properties.put("orgUnitId", (Object)this.template.getOrgId());
        resource.setData(data.toJSONString());
        resourceManager.update(resource);
        String name = String.valueOf(this.template.getName());
        ExtractMultiLanguageWordsUtil.extractWordsAndSaveOrUpdate(resourceId, name, this.template.getId(), "", this.template.getNumber());
    }

    @Override
    protected String getNewTemplateResourceData(CommandContext commandContext) {
        Long parentId = this.getBeCopiedTemplateId();
        String data = WfUtils.isNotEmpty(parentId) ? this.getCopiedResourceData(commandContext) : this.getDefaultResourceData();
        return data;
    }

    @Override
    protected ProcTemplateEntity getBeCopiedEntity(CommandContext commandContext, String fields) {
        return (ProcTemplateEntity)commandContext.getProcTemplateEntityManager().findById(this.getBeCopiedTemplateId(), fields);
    }

    protected Long getBeCopiedTemplateId() {
        return this.template.getParentId();
    }

    private String getDefaultResourceData() {
        ArrayList<Map<String, Object>> configs = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> config = new HashMap<String, Object>();
        Long orgId = this.template.getOrgId();
        String number = this.template.getNumber();
        config.put("name", this.template.getName());
        config.put("documentation", this.template.getDescription());
        config.put("number", number);
        config.put("businessid", this.template.getIdentification());
        config.put("orgUnitId", orgId);
        config.put("type", "Process");
        config.put("processType", this.template.getProcessType());
        DynamicObject entity = this.template.getEntity();
        config.put("entraBillId", this.template.getEntityId());
        config.put("entraBill", entity.getString("number"));
        config.put("entraBillName", entity.getString("name"));
        configs.add(config);
        HashMap<String, String> startConfig = new HashMap<String, String>();
        startConfig.put("type", "StartSignalEvent");
        startConfig.put("name", ResManager.loadKDString((String)"\u5f00\u59cb", (String)"SaveProcTemplateCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        configs.add(startConfig);
        HashMap<String, String> sequenceFlowConfig = new HashMap<String, String>();
        sequenceFlowConfig.put("type", "SequenceFlow");
        configs.add(sequenceFlowConfig);
        HashMap<String, String> endConfig = new HashMap<String, String>();
        endConfig.put("type", "EndNoneEvent");
        endConfig.put("name", ResManager.loadKDString((String)"\u7ed3\u675f", (String)"SaveProcTemplateCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        configs.add(endConfig);
        String modelType = GraphCodecUtils.getModelTypeByProcessType(this.template.getProcessType());
        BpmnModel bpmnModel = GraphCodecUtils.getDefaultBpmnModel(modelType, configs);
        return GraphCodecUtils.convertBpmnModelToJSON(bpmnModel);
    }

    @Override
    protected String getBeCopiedEntityResourceField() {
        return "resourceid";
    }

    @Override
    protected String getBeCopiedEntityOrgField() {
        return "org";
    }

    @Override
    protected String getBeCopiedEntityNumberField() {
        return "number";
    }

    @Override
    protected String getBeCopiedEntityNameField() {
        return "name";
    }

    @Override
    protected String getBeCopiedEntityDescriptionField() {
        return "description";
    }

    @Override
    protected String getBeCopiedEntityIdentificationField() {
        return "identification";
    }
}

