/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.engine.impl.cmd.proctpl.EntityProcessor;
import kd.bos.workflow.engine.impl.cmd.proctpl.SaveAsProcTemplateCmd;
import kd.bos.workflow.engine.impl.cmd.proctpl.SaveAsTemplateAndReplaceEntityInfoCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityConstants;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;

public class SaveProcessesAsTemplatesCmd
implements Command<Map<Long, Long>> {
    private String appId;
    private List<Long> modelIds;
    private Map<String, String> entityIdRelation;
    private EntityProcessor entityProcessor;
    private Log log = LogFactory.getLog(this.getClass());

    public SaveProcessesAsTemplatesCmd(String appId, List<Long> modelIds) {
        this.appId = appId;
        this.modelIds = modelIds;
    }

    public SaveProcessesAsTemplatesCmd(String appId, List<Long> modelIds, Map<String, String> entityMap, Map<String, String> roleMap) {
        this(appId, modelIds);
        this.entityIdRelation = entityMap;
        this.entityProcessor = new EntityProcessor(entityMap, roleMap);
    }

    @Override
    public Map<Long, Long> execute(CommandContext commandContext) {
        HashMap<Long, Long> ret = new HashMap<Long, Long>(16);
        QFilter[] modelFilters = new QFilter[]{new QFilter("id", "in", this.modelIds)};
        List modelEntities = commandContext.getModelEntityManager().findByQueryFilters(modelFilters);
        if (modelEntities.isEmpty()) {
            this.log.debug(String.format("no models found. %s, %s", this.appId, this.modelIds));
            return ret;
        }
        ret = new HashMap(modelEntities.size());
        String processType = ((ModelEntity)modelEntities.get(0)).getType();
        ProcTemplateCategoryEntity category = this.getOrCreateProcTplCategory(commandContext, processType);
        for (ModelEntity modelEntity : modelEntities) {
            Long modelId = modelEntity.getId();
            DynamicObject template = BusinessDataServiceHelper.newDynamicObject((String)"wf_proctemplate");
            template.set("resourceid", (Object)modelId);
            template.set("entity", (Object)modelEntity.getEntityNumber());
            template.set("name", (Object)modelEntity.getName());
            template.set("description", (Object)modelEntity.getDescription());
            template.set("category", (Object)category.getId());
            template.set("org", (Object)modelEntity.getOrgId());
            template.set("level", (Object)"1");
            template.set("processtype", (Object)modelEntity.getType());
            template.set("status", (Object)"disable");
            String number = CodeRuleServiceHelper.getNumber((String)"wf_proctemplate", (DynamicObject)template, (String)String.valueOf(RequestContext.get().getOrgId()));
            template.set("number", (Object)number);
            template.set("identification", (Object)number);
            Long templateId = null;
            templateId = this.entityIdRelation != null && !this.entityIdRelation.isEmpty() ? new SaveAsTemplateAndReplaceEntityInfoCmd(template, this.entityProcessor).execute(commandContext) : new SaveAsProcTemplateCmd(template).execute(commandContext);
            ret.put(modelId, templateId);
        }
        if (ModelType.NoCodeFlow.name().equals(processType)) {
            this.replaceReferencedModelIds(commandContext, ret);
        }
        return ret;
    }

    private ProcTemplateCategoryEntity getOrCreateProcTplCategory(CommandContext commandContext, String processType) {
        ProcTemplateCategoryEntityManager categoryManager = commandContext.getProcTemplateCategoryEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("applicationid", "=", (Object)this.appId)};
        List categories = categoryManager.findByQueryFilters(filters);
        if (!categories.isEmpty()) {
            return (ProcTemplateCategoryEntity)categories.get(0);
        }
        DynamicObject app = BizAppServiceHelp.getBizAppByID((String)this.appId);
        String appNumber = app.getString("number");
        ILocaleString appName = app.getLocaleString("name");
        ProcTemplateCategoryEntity category = this.createProcTemplateCategory(categoryManager, appNumber, appName, this.appId, processType);
        if (ModelType.NoCodeFlow.name().equals(processType)) {
            category.setParentId(ProcTemplateCategoryEntityConstants.CATEGORY_NOCODE);
            categoryManager.insert(category);
        } else {
            DynamicObject cloud = app.getDynamicObject("bizcloud");
            String cloudId = cloud.getString("id");
            filters = new QFilter[]{new QFilter("applicationid", "=", (Object)cloudId)};
            categories = categoryManager.findByQueryFilters(filters);
            if (!categories.isEmpty()) {
                category.setParentId(((ProcTemplateCategoryEntity)categories.get(0)).getId());
            } else {
                String cloudNumber = cloud.getString("number");
                ILocaleString cloudName = cloud.getLocaleString("name");
                ProcTemplateCategoryEntity parentCategory = this.createProcTemplateCategory(categoryManager, cloudNumber, cloudName, cloudId, processType);
                categoryManager.insert(parentCategory);
                category.setParentId(parentCategory.getId());
            }
            categoryManager.insert(category);
        }
        return category;
    }

    private ProcTemplateCategoryEntity createProcTemplateCategory(ProcTemplateCategoryEntityManager categoryManager, String number, ILocaleString name, String applicationId, String processType) {
        ProcTemplateCategoryEntity category = (ProcTemplateCategoryEntity)categoryManager.create();
        category.setNumber(number);
        category.setName(name);
        category.setApplicationId(applicationId);
        category.setProcessType(processType);
        return category;
    }

    private void replaceReferencedModelIds(CommandContext commandContext, Map<Long, Long> modelTemplateMap) {
        List<ProcTemplateEntity> templates = commandContext.getProcTemplateEntityManager().getProcTemplatesByIds(modelTemplateMap.values(), "resourceid");
        HashSet<Long> templateResourceIds = new HashSet<Long>(templates.size());
        for (ProcTemplateEntity template : templates) {
            templateResourceIds.add(template.getResourceId());
        }
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        List<ResourceEntity> resources = resourceManager.findResourcesByIds(templateResourceIds);
        for (ResourceEntity resource : resources) {
            String data = resource.getData();
            resource.setData(this.entityProcessor.getReplacedData(data, modelTemplateMap));
            resourceManager.update(resource);
        }
    }
}

