/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.proctpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityManager;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;

public class UpdateProcTemplateCmd
implements Command<Void> {
    private Long templateId;
    private String modelJson;

    public UpdateProcTemplateCmd(Long templateId, String modelJson) {
        this.templateId = templateId;
        this.modelJson = modelJson;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ProcTemplateEntityManager procTplManager = commandContext.getProcTemplateEntityManager();
        ProcTemplateEntity template = (ProcTemplateEntity)procTplManager.findById(this.templateId);
        JSONObject data = JSON.parseObject((String)this.modelJson);
        JSONObject properties = data.getJSONObject("properties");
        template.setName((ILocaleString)new LocaleString(properties.getString("name")));
        String description = properties.getString("documentation");
        if (description != null) {
            template.setDescription((ILocaleString)new LocaleString(description));
        }
        template.setIdentification(properties.getString("businessId"));
        template.setOrgId(properties.getLong("orgUnitId"));
        template.setEntityNumber(properties.getString("entraBill"));
        Long resourceId = template.getResourceId();
        ResourceEntity resource = (ResourceEntity)resourceManager.findById(resourceId);
        resource.setData(this.modelJson);
        resourceManager.update(resource);
        procTplManager.update(template);
        String name = String.valueOf(template.getName());
        ExtractMultiLanguageWordsUtil.extractWordsAndSaveOrUpdate(resourceId, name, template.getId(), "", template.getNumber());
        return null;
    }
}

