/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.SensitiveFieldInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.startup.GetSensitiveFieldChangeCmd;
import kd.bos.workflow.engine.impl.cmd.startup.SensitiveFieldStartUpUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.service.TryTriggerProcessTask;

public class EnterSensitiveFieldChangeCmd
implements Command<Map<String, Object>> {
    private Log logger = LogFactory.getLog(this.getClass());
    private String entityId;
    private DynamicObject[] dataEntities;
    private String operationKey;
    private Map<String, Object> wfVar;
    private String category;
    private boolean fromApi;

    public EnterSensitiveFieldChangeCmd(String entityId, DynamicObject[] dataEntities, String operationKey, Map<String, Object> wfVar, String category, boolean fromApi) {
        this.entityId = entityId;
        this.dataEntities = dataEntities;
        this.operationKey = operationKey;
        this.wfVar = wfVar;
        this.category = category;
        this.fromApi = fromApi;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (!WfConfigurationUtil.sensitiveChangeSwitch()) {
                return map;
            }
            if (WfConfigurationUtil.canRunWorkflow() && ("submit".equals(this.operationKey) || WfConfigurationUtil.sensitivePermiOperateList().contains(this.operationKey)) || this.fromApi) {
                TryTriggerProcessTask tryTrigger = new TryTriggerProcessTask();
                boolean ret = tryTrigger.existProcess(this.entityId, this.operationKey);
                if (!ret) {
                    return map;
                }
                ArrayList<SensitiveFieldInfo> sensitiveFieldInfos = new ArrayList<SensitiveFieldInfo>(1);
                int length = 0;
                if (this.dataEntities != null && this.dataEntities.length > 0) {
                    length = this.dataEntities.length;
                    DynamicObject dataEntity = this.dataEntities[0];
                    boolean basicCheck = SensitiveFieldStartUpUtil.basicCheck(this.category, this.operationKey, dataEntity, this.entityId);
                    if (basicCheck || this.fromApi) {
                        dataEntity = this.getFullDataEntity(this.entityId, dataEntity, this.wfVar);
                        SensitiveFieldInfo sensitiveFieldInfo = new GetSensitiveFieldChangeCmd(this.entityId, this.operationKey, dataEntity, this.category, null).execute(commandContext);
                        this.logger.debug(String.format("sensitiveFieldInfo:%s", sensitiveFieldInfo == null ? "null" : sensitiveFieldInfo.toString()));
                        if (sensitiveFieldInfo != null) {
                            sensitiveFieldInfos.add(sensitiveFieldInfo);
                        }
                    }
                }
                if (WfConfigurationUtil.isShowSensitiveChange() && sensitiveFieldInfos.size() == 1 && ((SensitiveFieldInfo)sensitiveFieldInfos.get(0)).getIsSensitiveChange().booleanValue() && length == 1 && !this.fromApi) {
                    map.put("openSensitiveFieldPage", "true");
                }
                if (CollectionUtil.isNotEmpty(sensitiveFieldInfos)) {
                    map.put("sensitiveFieldInfos", SerializationUtils.toJsonString(sensitiveFieldInfos));
                }
            }
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
        return map;
    }

    private DynamicObject getFullDataEntity(String entityId, DynamicObject dataEntity, Map<String, Object> wfVar) {
        if (wfVar != null && wfVar.get("byIds") != null && Boolean.parseBoolean(wfVar.get("byIds").toString()) && dataEntity != null && dataEntity.getPkValue() != null) {
            try {
                return WfUtils.findBusinessObject(dataEntity.getPkValue().toString(), entityId);
            }
            catch (Exception ex) {
                this.logger.info("get wfmsg:" + WfUtils.getExceptionStacktrace(ex));
            }
        }
        return dataEntity;
    }
}

