/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.util.DynamicProcessDefinitionHelper;

public class FindFinalLatestProcessDefinitionByEntityTypeCmd
implements Command<Map<String, Object>> {
    private Log logger = LogFactory.getLog(FindFinalLatestProcessDefinitionByEntityTypeCmd.class);
    private DynamicObject model;
    private String businessKey;
    private String operation;
    private String entityNumber;

    public FindFinalLatestProcessDefinitionByEntityTypeCmd(DynamicObject model, String businessKey, String operation, String entityNumber) {
        this.model = model;
        this.businessKey = businessKey;
        this.operation = operation;
        this.entityNumber = entityNumber;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        Map<String, Object> target = null;
        ProcessDefinitionEntityManager defMgr = commandContext.getProcessDefinitionEntityManager();
        List<Map<String, Object>> processDefList = defMgr.findLatestProcessDefinitionByEntityType(this.entityNumber, this.operation);
        this.logger.debug("find processDefList contains[" + (processDefList == null ? 0 : processDefList.size()) + "]! ");
        BusinessModelVariableScope bizScope = new BusinessModelVariableScope(this.model);
        List<Map<String, Object>> targets = DynamicProcessDefinitionHelper.filterProcessByCondition(processDefList, bizScope, this.operation, this.entityNumber);
        this.logger.debug("after filter,processDefList contains[" + (processDefList == null ? 0 : processDefList.size()) + "]! ");
        if (targets == null || targets.size() == 0) {
            String msg = "no suitable process is found for [" + this.entityNumber + "] and [" + this.businessKey + "]";
            this.logger.debug(msg);
            return target;
        }
        for (Map<String, Object> t : targets) {
            if (!WfUtils.isNotEmpty((String)t.get("startcondition"))) continue;
            target = t;
            break;
        }
        if (target == null) {
            target = targets.get(0);
        }
        return target;
    }
}

