/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntity;
import kd.bos.workflow.service.ProcessStatusEnum;

public class GetProcessStatusCmd
implements Command<ProcessStatusEnum> {
    protected String businessKey;
    protected Long curJobId;
    protected Map<String, Object> variables;

    public GetProcessStatusCmd(String businessKey, Long curJobId) {
        this.businessKey = businessKey;
        this.curJobId = curJobId;
        this.variables = new HashMap<String, Object>();
    }

    public GetProcessStatusCmd(String businessKey, Long curJobId, Map<String, Object> variables) {
        this.businessKey = businessKey;
        this.curJobId = curJobId;
        this.variables = variables;
    }

    @Override
    public ProcessStatusEnum execute(CommandContext commandContext) {
        List<JobEntity> jobs;
        if (this.variables != null && !this.variables.isEmpty()) {
            Object processType = this.variables.get("processType");
            Object processDefId = this.variables.get("procdefid");
            if (ModelType.NoCodeFlow.name().equals(processType) && processDefId != null && StringUtils.isNotBlank((CharSequence)String.valueOf(processDefId))) {
                return ProcessStatusEnum.NONE;
            }
        }
        if (null != (jobs = commandContext.getJobEntityManager().findJobByMsgTypeAndBusKey(new String[]{"address-process-event", "start-process-event", "start-callactivity-event", "async-continuation", "multi-async-continuation", "async-trigger"}, this.businessKey))) {
            this.filterCurJob(jobs);
        }
        if (jobs != null && jobs.size() > 0) {
            JobEntity job = jobs.get(0);
            if (WfUtils.isEmpty(job.getExceptionMessage())) {
                return this.getRunningState(job);
            }
            return this.getRetryState(job);
        }
        List<SuspendedJobEntity> suspendJobs = commandContext.getSuspendedJobEntityManager().findJobByMsgTypeAndBusKey(new String[]{"address-process-event", "start-process-event", "start-callactivity-event", "async-continuation", "multi-async-continuation", "async-trigger"}, this.businessKey);
        if (suspendJobs != null && suspendJobs.size() > 0) {
            return this.getSuspendState(suspendJobs.get(0));
        }
        HistoricProcessInstance ps = null;
        boolean existProcess = commandContext.getExecutionEntityManager().existActiveExecutionsByBusinessKey(this.businessKey);
        ps = existProcess ? (HistoricProcessInstance)commandContext.getHistoricProcessInstanceEntityManager().create() : commandContext.getHistoricProcessInstanceEntityManager().findLatestHistoricProcessInstanceByBusinessKey(this.businessKey);
        if (ps != null) {
            if (ps.getEndTime() != null) {
                return ProcessStatusEnum.PROCESSNORMALFINISHED;
            }
            return ProcessStatusEnum.PROCESSWAIT;
        }
        return ProcessStatusEnum.NONE;
    }

    protected ProcessStatusEnum getSuspendState(SuspendedJobEntity job) {
        switch (job.getJobHandlerType()) {
            case "address-process-event": {
                return ProcessStatusEnum.ADDRESSMSGSUSPEND;
            }
            case "start-process-event": 
            case "start-callactivity-event": {
                return ProcessStatusEnum.STARTMSGSUSPEND;
            }
            case "async-continuation": 
            case "async-trigger": 
            case "multi-async-continuation": {
                return ProcessStatusEnum.PROCESSSUSPEND;
            }
        }
        return null;
    }

    protected ProcessStatusEnum getRetryState(JobEntity job) {
        switch (job.getJobHandlerType()) {
            case "address-process-event": {
                return ProcessStatusEnum.ADDRESSMSGONTRYINGWHENERRORED;
            }
            case "start-process-event": 
            case "start-callactivity-event": {
                return ProcessStatusEnum.STARTMSGONTRYINGWHENERRORED;
            }
            case "async-continuation": 
            case "async-trigger": 
            case "multi-async-continuation": {
                return ProcessStatusEnum.STARTMSGONTRYINGWHENERRORED;
            }
        }
        return null;
    }

    protected ProcessStatusEnum getRunningState(JobEntity job) {
        switch (job.getJobHandlerType()) {
            case "address-process-event": {
                return ProcessStatusEnum.ADDRESSMSGRUNING;
            }
            case "start-process-event": {
                return ProcessStatusEnum.STARTMSGRUNING;
            }
            case "async-continuation": 
            case "async-trigger": 
            case "multi-async-continuation": {
                return ProcessStatusEnum.TRIGGERMSGRUNING;
            }
        }
        return null;
    }

    protected void filterCurJob(List<JobEntity> jobs) {
        Iterator<JobEntity> iter = jobs.iterator();
        while (iter.hasNext()) {
            JobEntity entity = iter.next();
            if (!entity.getId().equals(this.curJobId)) continue;
            iter.remove();
        }
    }
}

