/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.util.Iterator;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.cmd.startup.GetProcessStatusCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntity;
import kd.bos.workflow.service.ProcessStatusEnum;

public class GetProcessStatusWithProcDefIdCmd
extends GetProcessStatusCmd {
    private Log logger = LogFactory.getLog(GetProcessStatusWithProcDefIdCmd.class);
    private Long procDefId;
    private String entityNumber;

    public GetProcessStatusWithProcDefIdCmd(String entityNumber, String businessKey, Long curJobId, Long procDefId) {
        super(businessKey, curJobId);
        this.procDefId = procDefId;
        this.entityNumber = entityNumber;
    }

    @Override
    public ProcessStatusEnum execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.entityNumber) || WfUtils.isEmpty(this.businessKey) || WfUtils.isEmpty(this.procDefId)) {
            this.logger.debug(String.format("entityNumber:[%s]\uff0cbusinessKey[%s]\uff0cprocDefId[%s]\uff0c\u5165\u53c2\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u6d41\u7a0b\u72b6\u6001\u3002", this.entityNumber, this.businessKey, this.procDefId));
            return null;
        }
        List<JobEntity> jobs = commandContext.getJobEntityManager().findJobByMsgTypeAndBusKey(new String[]{"start-process-event", "async-continuation", "async-trigger"}, this.businessKey);
        if (null != jobs) {
            this.filterCurJob(jobs);
            this.filterByEntityNumberAndProcDefId(jobs);
        }
        if (jobs != null && jobs.size() > 0) {
            JobEntity job = jobs.get(0);
            if (WfUtils.isEmpty(job.getExceptionMessage())) {
                return this.getRunningState(job);
            }
            return this.getRetryState(job);
        }
        List<SuspendedJobEntity> suspendJobs = commandContext.getSuspendedJobEntityManager().findJobByMsgTypeAndBusKey(new String[]{"address-process-event", "start-process-event", "async-continuation", "async-trigger"}, this.businessKey);
        this.filterSuspendedJobByEntityNumberAndProcDefId(suspendJobs);
        if (suspendJobs != null && suspendJobs.size() > 0) {
            return this.getSuspendState(suspendJobs.get(0));
        }
        boolean existProcess = commandContext.getExecutionEntityManager().existActiveExecutionsByEntityNumberAndPkAndProcDefId(this.entityNumber, this.businessKey, this.procDefId);
        if (existProcess) {
            return ProcessStatusEnum.PROCESSWAIT;
        }
        HistoricProcessInstance ps = commandContext.getHistoricProcessInstanceEntityManager().findLatestHiprocinstByEntityNumberAndPkAndProcDefId(this.entityNumber, this.businessKey, this.procDefId);
        if (ps != null) {
            if (ps.getEndTime() == null) {
                return ProcessStatusEnum.PROCESSWAIT;
            }
            return ProcessStatusEnum.PROCESSNORMALFINISHED;
        }
        return ProcessStatusEnum.NONE;
    }

    private void filterSuspendedJobByEntityNumberAndProcDefId(List<SuspendedJobEntity> suspendJobs) {
        Iterator<SuspendedJobEntity> iterator = suspendJobs.iterator();
        while (iterator.hasNext()) {
            SuspendedJobEntity suspendedJob = iterator.next();
            if (suspendedJob != null && this.entityNumber.equals(suspendedJob.getEntityNumber()) && this.procDefId.equals(suspendedJob.getProcessDefinitionId())) continue;
            iterator.remove();
        }
    }

    private void filterByEntityNumberAndProcDefId(List<JobEntity> jobs) {
        Iterator<JobEntity> iterator = jobs.iterator();
        while (iterator.hasNext()) {
            JobEntity job = iterator.next();
            if (job != null && this.entityNumber.equals(job.getEntityNumber()) && this.procDefId.equals(job.getProcessDefinitionId())) continue;
            iterator.remove();
        }
    }
}

