/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.SensitiveFieldInfo;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SensitiveFieldUtil;

public class GetSensitiveFieldChangeCmd
implements Command<SensitiveFieldInfo> {
    protected static Log logger = LogFactory.getLog(WfConfigurationUtil.class);
    private String formId;
    private String opKey;
    private DynamicObject dataEntity;
    private String nodeType;
    private Long taskId;

    public GetSensitiveFieldChangeCmd(String formId, String opKey, DynamicObject dataEntity, String nodeType, Long taskId) {
        this.formId = formId;
        this.opKey = opKey;
        this.dataEntity = dataEntity;
        this.nodeType = nodeType;
        this.taskId = taskId;
    }

    @Override
    public SensitiveFieldInfo execute(CommandContext commandContext) {
        SensitiveFieldInfo sensitiveFieldInfo;
        block6: {
            sensitiveFieldInfo = null;
            try {
                Object pk = this.dataEntity.getPkValue();
                List<Object> tasks = new ArrayList();
                if (WfUtils.isNotEmpty(this.taskId)) {
                    tasks = this.getTaskByTaskIdAndCategory(commandContext);
                    for (TaskEntity taskEntity : tasks) {
                        String handleState = taskEntity.getHandleState();
                        if (!"dismissed".equals(handleState)) continue;
                        String variableKey = taskEntity.getBusinessKey() + taskEntity.getTaskDefinitionKey().toLowerCase() + "sensitivefieldinfo";
                        Object variable = taskEntity.getExecution().getVariable(variableKey);
                        if (variable == null) continue;
                        logger.debug("variable:" + variable);
                        sensitiveFieldInfo = this.addSensitiveFieldChange((String)variable);
                        this.addSensitiveFieldParams(pk, sensitiveFieldInfo, taskEntity);
                        break block6;
                    }
                    break block6;
                }
                if (pk == null || (tasks = this.getTaskByBusinesskeyAndCategory(commandContext, pk)) == null || tasks.isEmpty()) break block6;
                for (TaskEntity taskEntity : tasks) {
                    String handleState = taskEntity.getHandleState();
                    if (!"dismissed".equals(handleState)) continue;
                    BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId());
                    UserTask userTask = (UserTask)bpmnModel.getFlowElement(taskEntity.getTaskDefinitionKey());
                    boolean continueFlow = true;
                    if (BpmnModelUtil.instanceofUserTaskOnly(userTask.getType())) {
                        boolean bl = continueFlow = userTask != null && userTask.getOperationStr() != null && Arrays.asList(userTask.getOperationStr().split(",")).contains(this.opKey);
                    }
                    if (!continueFlow) continue;
                    String variableKey = taskEntity.getBusinessKey() + taskEntity.getTaskDefinitionKey().toLowerCase() + "sensitivefieldinfo";
                    Object variable = taskEntity.getExecution().getVariable(variableKey);
                    if (variable == null) continue;
                    logger.debug("variable:" + variable);
                    sensitiveFieldInfo = this.addSensitiveFieldChange((String)variable);
                    this.addSensitiveFieldParams(pk, sensitiveFieldInfo, taskEntity);
                    break;
                }
            }
            catch (Exception e) {
                logger.error("formId:" + this.formId + ",operate\uff1a" + this.opKey + ",sensitiveFieldInfo:" + (sensitiveFieldInfo == null ? "null" : sensitiveFieldInfo.toString()) + ",errorInfo:" + e.getMessage() + ",stacktrace:" + WfUtils.getExceptionStacktrace(e));
            }
        }
        return sensitiveFieldInfo;
    }

    private List<TaskEntity> getTaskByBusinesskeyAndCategory(CommandContext commandContext, Object pk) {
        TaskEntityManager taskMgr = commandContext.getProcessEngineConfiguration().getTaskEntityManager();
        QFilter q1 = new QFilter("businessKey", "=", (Object)pk.toString());
        QFilter q2 = new QFilter("category", "=", (Object)this.nodeType);
        return taskMgr.findByQueryFilters(new QFilter[]{q1, q2});
    }

    private List<TaskEntity> getTaskByTaskIdAndCategory(CommandContext commandContext) {
        TaskEntityManager taskMgr = commandContext.getProcessEngineConfiguration().getTaskEntityManager();
        QFilter q1 = new QFilter("id", "=", (Object)this.taskId);
        QFilter q2 = new QFilter("category", "=", (Object)this.nodeType);
        return taskMgr.findByQueryFilters(new QFilter[]{q1, q2});
    }

    private void addSensitiveFieldParams(Object pk, SensitiveFieldInfo sensitiveFieldInfo, TaskEntity task) {
        String taskdefinitionkey = task.getTaskDefinitionKey();
        if (sensitiveFieldInfo.getIsSensitiveChange().booleanValue() && taskdefinitionkey != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String changkey = SensitiveFieldUtil.buildSensitiveFieldKey(pk.toString(), taskdefinitionkey.toLowerCase());
            params.put("changkey", changkey);
            sensitiveFieldInfo.setParams(params);
        }
    }

    private SensitiveFieldInfo addSensitiveFieldChange(String sensitivefieldrecordStr) {
        if (StringUtils.isBlank((CharSequence)sensitivefieldrecordStr)) {
            return null;
        }
        Map sensitivefieldrecords = (Map)SerializationUtils.fromJsonString((String)sensitivefieldrecordStr, Map.class);
        HashSet<String> flag = new HashSet<String>();
        HashMap<String, Map<String, Object>> resultSensitivefieldrecords = new HashMap<String, Map<String, Object>>();
        for (Map.Entry sensitivefieldrecordEntry : sensitivefieldrecords.entrySet()) {
            String key = (String)sensitivefieldrecordEntry.getKey();
            Map oldValue = (Map)sensitivefieldrecordEntry.getValue();
            if (!WfUtils.isNotEmpty(key)) continue;
            if (key.contains("/")) {
                this.addEntryValue(sensitivefieldrecords, flag, key, oldValue, resultSensitivefieldrecords);
                continue;
            }
            Object value = this.dataEntity.get(key);
            Map recordMap = (Map)sensitivefieldrecords.get(key);
            recordMap.put("name", recordMap.get("name"));
            recordMap.put("oldValue", oldValue.get("oldValue"));
            recordMap.put("newValue", SensitiveFieldUtil.formatValue(value));
            resultSensitivefieldrecords.put(key, recordMap);
        }
        SensitiveFieldInfo sensitiveFieldInfo = new SensitiveFieldInfo();
        sensitiveFieldInfo.setSensitiveChangeMsg(resultSensitivefieldrecords);
        StringBuilder changeFieldNames = new StringBuilder();
        ILocaleString sensitiveChangeLog = this.compareValue(resultSensitivefieldrecords, changeFieldNames);
        if (WfUtils.isNotEmpty(sensitiveChangeLog)) {
            sensitiveChangeLog = GetSensitiveFieldChangeCmd.mulitLangAppend(WfUtils.getPromptWordLocaleString("\u5173\u952e\u5b57\u6bb5\u4fee\u6539\u8be6\u60c5\uff1a", "GetSensitiveFieldChangeCmd_1", "bos-wf-engine"), sensitiveChangeLog);
            int length = changeFieldNames.length() - 1;
            if (length > 0) {
                changeFieldNames.deleteCharAt(length);
            }
            sensitiveFieldInfo.setChangeFieldNames(changeFieldNames.toString());
            sensitiveFieldInfo.setIsSensitiveChange(true);
        }
        sensitiveFieldInfo.setSensitiveChangeLog(sensitiveChangeLog);
        logger.debug("sensitiveFieldInfo:" + sensitiveFieldInfo.toString());
        return sensitiveFieldInfo;
    }

    private void addEntryValue(Map<String, Map<String, Object>> sensitivefieldrecords, Set<String> flag, String key, Map<String, Object> oldValue, Map<String, Map<String, Object>> resultSensitivefieldrecords) {
        String[] entrykey = key.split("/");
        Object sensitiveNameValue = oldValue.get("name");
        if (!flag.contains(entrykey[0] + "." + entrykey[2])) {
            this.extractEntityNewValue(sensitivefieldrecords, sensitiveNameValue, entrykey, flag, resultSensitivefieldrecords);
        }
        Map<String, Object> resultSensitivefieldMap = resultSensitivefieldrecords.get(key);
        Map<String, Object> recordMap = sensitivefieldrecords.get(key);
        if (resultSensitivefieldMap == null || resultSensitivefieldMap.isEmpty()) {
            if (recordMap == null || recordMap.isEmpty()) {
                recordMap = new HashMap<String, Object>();
            }
            recordMap.put("newValue", null);
            resultSensitivefieldrecords.put(key, recordMap);
        }
    }

    private ILocaleString compareValue(Map<String, Map<String, Object>> sensitivefieldrecords, StringBuilder changeFieldNames) {
        LocaleString sensitiveChangeLog = new LocaleString();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Map.Entry<String, Map<String, Object>> sensitivefieldrecordEntry : sensitivefieldrecords.entrySet()) {
            Map<String, Object> recordMap = sensitivefieldrecordEntry.getValue();
            if (StringUtils.equals((CharSequence)String.valueOf(recordMap.get("newValue")), (CharSequence)String.valueOf(recordMap.get("oldValue")))) continue;
            Map nameMap = (Map)recordMap.get("name");
            LocaleString name = new LocaleString();
            for (Map.Entry nameEntry : nameMap.entrySet()) {
                name.setItem((String)nameEntry.getKey(), (Object)(WfUtils.isEmptyString(nameEntry.getValue()) ? "" : nameEntry.getValue().toString()));
            }
            String localeName = name.getLocaleValue();
            sensitiveChangeLog = this.buildChangeLog((ILocaleString)sensitiveChangeLog, recordMap, (ILocaleString)name);
            String filedKey = sensitivefieldrecordEntry.getKey();
            if (filedKey.contains("/")) {
                String[] strings = filedKey.split("/");
                filedKey = strings[0] + "." + strings[2];
            }
            if (!fieldNames.add(filedKey)) continue;
            changeFieldNames.append(localeName).append(',');
        }
        return sensitiveChangeLog;
    }

    private ILocaleString buildChangeLog(ILocaleString sensitiveChange, Map<String, Object> recordMap, ILocaleString name) {
        GetSensitiveFieldChangeCmd.mulitLangAppendString(sensitiveChange, name, "\u3010");
        sensitiveChange = GetSensitiveFieldChangeCmd.mulitLangAppend(sensitiveChange, WfUtils.getPromptWordLocaleString("\u65e7\u503c\uff1a", "GetSensitiveFieldChangeCmd_2", "bos-wf-engine"));
        String oldValue = String.valueOf(recordMap.get("oldValue"));
        sensitiveChange = this.addValueLog(sensitiveChange, oldValue);
        sensitiveChange = GetSensitiveFieldChangeCmd.mulitLangAppend(sensitiveChange, WfUtils.getPromptWordLocaleString("\uff1b\u65b0\u503c\uff1a", "GetSensitiveFieldChangeCmd_3", "bos-wf-engine"));
        String newValue = String.valueOf(recordMap.get("newValue"));
        sensitiveChange = this.addValueLog(sensitiveChange, newValue);
        GetSensitiveFieldChangeCmd.mulitLangAppendString(sensitiveChange, "\u3011\uff1b");
        return sensitiveChange;
    }

    private ILocaleString addValueLog(ILocaleString sensitiveChange, String value) {
        if ("null".equals(value)) {
            sensitiveChange = GetSensitiveFieldChangeCmd.mulitLangAppend(sensitiveChange, WfUtils.getPromptWordLocaleString("\u7a7a\u503c", "GetSensitiveFieldChangeCmd_4", "bos-wf-engine"));
        } else {
            GetSensitiveFieldChangeCmd.mulitLangAppendString(sensitiveChange, String.valueOf(value));
        }
        return sensitiveChange;
    }

    private void extractEntityNewValue(Map<String, Map<String, Object>> sensitivefieldrecords, Object sensitiveNameValue, String[] entrykey, Set<String> flag, Map<String, Map<String, Object>> resultSensitivefieldrecords) {
        flag.add(entrykey[0] + "." + entrykey[2]);
        DynamicObjectCollection dynamicObjectCollection = this.dataEntity.getDynamicObjectCollection(entrykey[0]);
        if (WfUtils.isNotEmptyForCollection((Collection)dynamicObjectCollection)) {
            Integer sensitiveFieldsEntrythreshold = WfConfigurationUtil.getSensitiveFieldsEntrythreshold();
            if (sensitiveFieldsEntrythreshold == null) {
                sensitiveFieldsEntrythreshold = 30;
            }
            Integer num = 0;
            for (DynamicObject dynamic : dynamicObjectCollection) {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
                if (num > sensitiveFieldsEntrythreshold) break;
                Object pkValue = dynamic.getPkValue();
                Object value = dynamic.get(entrykey[2]);
                Map<String, Object> recordMap = sensitivefieldrecords.get(String.join((CharSequence)"/", entrykey[0], pkValue.toString(), entrykey[2]));
                if (recordMap == null) {
                    recordMap = new HashMap<String, Object>();
                }
                recordMap.put("newValue", SensitiveFieldUtil.formatValue(value));
                recordMap.put("name", sensitiveNameValue);
                if (Long.valueOf("0").equals(pkValue)) {
                    pkValue = "seq_" + dynamic.getString("seq");
                }
                resultSensitivefieldrecords.put(String.join((CharSequence)"/", entrykey[0], pkValue.toString(), entrykey[2]), recordMap);
            }
        }
    }

    public static ILocaleString mulitLangAppend(ILocaleString lString1, ILocaleString lString2) {
        return WfMultiLangUtils.jointILocaleString(lString1, lString2, "");
    }

    public static ILocaleString mulitLangAppendString(ILocaleString lString, ILocaleString lstr, String string) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            String l = lang.toString();
            String itemStr = WfUtils.isEmpty((String)lString.getItem(l)) ? "" : (String)lString.getItem(l);
            String str = "";
            if (WfUtils.isNotEmpty(lstr)) {
                str = WfUtils.isNotEmpty((String)lstr.getItem(l)) ? (String)lstr.getItem(l) : "";
            }
            lString.setItem(l, (Object)(itemStr + str + string));
        }
        return lString;
    }

    public static ILocaleString mulitLangAppendString(ILocaleString lString, String string) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            String l = lang.toString();
            String itemStr = WfUtils.isEmpty((String)lString.getItem(l)) ? "" : (String)lString.getItem(l);
            lString.setItem(l, (Object)(itemStr + string));
        }
        return lString;
    }
}

