/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.AllowNextPersonSetting;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.ParticipantStrategy;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorHelper;
import kd.bos.workflow.engine.impl.cmd.startup.AddressProcessCmd;
import kd.bos.workflow.engine.impl.cmd.startup.AssignPersonUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.participant.ParticipantSceneContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.AddressProcessUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SensitiveFieldUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;
import kd.bos.workflow.exception.WFErrorCode;

public class GetWfAssignPersonsCmd
implements Command<Map<String, Object>> {
    public static final String ADDRESSSCENSE = "ADDRESSSCENSE";
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String MODELTYPE = "modeltype";
    private static final String MOBILEBASE = "mobilebase";
    private static final String MOBILEBILL = "mobilebill";
    private static final String MOBILEFORM = "mobileform";
    private static final String MOBILELIST = "mobilelist";
    private static final String ACTIVE = "active";
    private static final String USERTASK = "UserTask";
    private static final String CATEGORY = "category";
    private static final String BYIDS = "byIds";
    private static final String WF_TASK = "wf_task";
    private static final String REJECT = "reject";
    private String formId;
    private String opKey;
    private DynamicObject dataEntity;
    private Long procdefId;
    private Long procInstId;
    private Map<String, Boolean> nodeIdType = new HashMap<String, Boolean>();
    private String nodeIdForCurrent = null;
    private CommandContext commandContext;
    private Map<String, Object> param;
    private Boolean isInsideTask = Boolean.FALSE;
    private static final String[] mobileType = new String[]{"mobilebase", "mobilebill", "mobileform", "mobilelist"};

    public GetWfAssignPersonsCmd(String formId, String opKey, DynamicObject dataEntity) {
        this.formId = formId;
        this.opKey = opKey;
        this.dataEntity = dataEntity;
    }

    public GetWfAssignPersonsCmd(String formId, String opKey, DynamicObject dataEntity, Map<String, Object> param) {
        this.formId = formId;
        this.opKey = opKey;
        this.dataEntity = dataEntity;
        this.param = param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        this.logger.debug("GetWfAssignPersonsCmd.execute formId: " + this.formId + ";opKey: " + this.opKey + ";param: " + this.param);
        this.commandContext = commandContext;
        HashMap<String, Object> taskInfo = new HashMap<String, Object>();
        taskInfo.put("wfAssignPersons", Boolean.FALSE);
        boolean isThroughBasicCheck = AssignPersonUtil.basicCheck(this.formId, this.opKey);
        if (!isThroughBasicCheck) {
            return taskInfo;
        }
        if (this.param != null && this.param.get(BYIDS) != null && this.dataEntity != null && this.dataEntity.getPkValue() != null) {
            try {
                String entityId = this.dataEntity.getDataEntityType().getName();
                DynamicObject dta = WfUtils.findBusinessObject(this.dataEntity.getPkValue().toString(), entityId);
                if (dta != null) {
                    this.dataEntity = dta;
                }
            }
            catch (Exception ex) {
                this.logger.info("GetWfAssignPersonsCmd.execute get exception wfmsg:" + WfUtils.getExceptionStacktrace(ex));
            }
        }
        String businessKey = null;
        if (null != this.dataEntity && this.dataEntity.getPkValue() != null) {
            businessKey = String.valueOf(this.dataEntity.getPkValue());
        }
        taskInfo.put("formId", this.formId);
        boolean isFirstProcStart = this.firstProcStart(businessKey, taskInfo);
        boolean isRestartAddress = false;
        if (isFirstProcStart) {
            try {
                commandContext.addAttribute(ADDRESSSCENSE, "TRUE");
                AddressProcessCmd addressProcessCmd = new AddressProcessCmd(this.opKey, this.dataEntity);
                this.procdefId = addressProcessCmd.execute(commandContext);
            }
            finally {
                commandContext.removeAttribute(ADDRESSSCENSE);
            }
        } else {
            isRestartAddress = this.isFirstNodeAndRestartAddress(taskInfo, businessKey);
            if (!isRestartAddress) {
                taskInfo.put("newprocessdefinitionid", this.procdefId);
            }
            taskInfo.put("addressbusinesskey", businessKey);
        }
        if (WfUtils.isEmpty(this.procdefId)) {
            return taskInfo;
        }
        AllowNextPersonSettingModel allowNextPersonSettingModel = this.getAllowNextPersonSettingModel(isFirstProcStart || isRestartAddress);
        if (allowNextPersonSettingModel != null) {
            this.showFinalResult(allowNextPersonSettingModel, taskInfo);
        }
        this.logger.debug(String.format("GetWfAssignPersonsCmd.execute [taskInfo] [taskInfo wfAssignPersons] [formId] [opKey] is [%s][%s][%s][%s]", WfUtils.mapToString(taskInfo), taskInfo.get("wfAssignPersons"), this.formId, this.opKey));
        return taskInfo;
    }

    private boolean isFirstNodeAndRestartAddress(Map<String, Object> taskInfo, String businessKey) {
        Object taskIdStr = taskInfo.remove("taskids");
        if (taskIdStr == null || ((List)taskIdStr).size() == 0) {
            this.logger.debug("GetWfAssignPersonsCmd.isFirstNodeAndRestartAddress no task no need address.");
            return false;
        }
        List<TaskEntity> taskIds = this.commandContext.getTaskEntityManager().findByTaskIds((List)taskIdStr);
        List tasks = taskIds.stream().filter(taskEntity -> WfUtils.isEmpty(taskEntity.getExecution().getSuperExecutionId())).collect(Collectors.toList());
        if (tasks == null || tasks.size() == 0) {
            this.logger.debug("GetWfAssignPersonsCmd.isFirstNodeAndRestartAddress have task - subprocesstask.");
            return false;
        }
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(((TaskEntity)tasks.get(0)).getProcessDefinitionId(), ((TaskEntity)tasks.get(0)).getProcessInstanceId());
        if (model == null) {
            return false;
        }
        TaskEntity task = null;
        FlowElement flowElement = null;
        for (TaskEntity taskEntity2 : tasks) {
            flowElement = model.getFlowElement(taskEntity2.getTaskDefinitionKey());
            if (!BpmnModelUtil.isFirstNodeByModel((FlowNode)flowElement)) continue;
            task = taskEntity2;
            break;
        }
        if (task == null) {
            this.logger.debug("GetWfAssignPersonsCmd.isFirstNodeAndRestartAddress find top parent task, but not the first usertask.");
            return false;
        }
        ProcessEngineConfigurationImpl procEngineCfg = this.commandContext.getProcessEngineConfiguration();
        TaskHelper taskHelper = procEngineCfg.getTaskHelper();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("backrejectednode", task.getProcessInstance().getVariable("backrejectednode"));
        variables.put("auditName", task.getProcessInstance().getVariable("auditName"));
        String buildSensitiveFieldKey = SensitiveFieldUtil.buildSensitiveFieldKey(task.getBusinessKey(), task.getTaskDefinitionKey());
        variables.put(buildSensitiveFieldKey, task.getProcessInstance().getVariable(buildSensitiveFieldKey));
        taskHelper.wrapBackToRejectVariables(this.commandContext, task, variables, model, (UserTask)flowElement);
        if (variables.get("nextNodeId") != null && "dynBackToRejectNode".equals(variables.get("dynType"))) {
            FlowElement flowNode = model.getFlowElement((String)variables.get("nextNodeId"));
            boolean isSSCApproval = flowNode != null && "SSCApprove".equalsIgnoreCase(flowNode.getType());
            this.logger.info("GetWfAssignPersonsCmd.isFirstNodeAndRestartAddress RejectBackToSSCApprove is " + isSSCApproval);
            taskInfo.put("RejectBackToSSCApprove", isSSCApproval);
        }
        if (!WfConfigurationUtil.isNeedRestart() || WfUtils.isSyncRun()) {
            this.logger.debug("GetWfAssignPersonsCmd.isFirstNodeAndRestartAddress WfConfigurationUtil.isNeedRestart() is false");
            return false;
        }
        List<Variable> processVariables = model.getMainProcess().getVariables();
        for (Variable variable : processVariables) {
            if (!"notrestartaddress".equals(variable.getName()) || !Boolean.parseBoolean((String)variable.getDefaultValue())) continue;
            this.logger.debug("\u5f53\u524d\u6d41\u7a0b\u5b58\u5728\u53d8\u91cf\uff0c\u4e14\u4e0d\u9700\u8981\u91cd\u65b0\u5bfb\u5740");
            return false;
        }
        AddressProcessUtils.restartAddress(this.commandContext, businessKey, this.opKey, task.getEntityNumber(), variables, task.getProcessDefinitionId(), task.getProcessInstanceId(), this.dataEntity);
        Object procDefinitionId = variables.get("newprocessdefinitionid");
        if (procDefinitionId != null) {
            this.procdefId = (Long)procDefinitionId;
            this.procInstId = null;
            taskInfo.put("newprocessdefinitionid", procDefinitionId);
            taskInfo.put("newschmeid", variables.get("newschmeid"));
            taskInfo.remove("RejectBackToSSCApprove");
            this.logger.info("GetWfAssignPersonsCmd.isFirstNodeAndRestartAddress need address.");
            return true;
        }
        this.logger.debug("GetWfAssignPersonsCmd.isFirstNodeAndRestartAddress not the first usertask no need address.");
        return false;
    }

    private Boolean whetherOpenWindow(String personScene) {
        String modelType = (String)this.param.get(MODELTYPE);
        List<String> mobileTypeList = Arrays.asList(mobileType);
        if (mobileTypeList.contains(modelType) && "assign".equals(personScene)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean isMob() {
        String modelType = (String)this.param.get(MODELTYPE);
        List<String> mobileTypeList = Arrays.asList(mobileType);
        if (mobileTypeList.contains(modelType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean showFinalResult(AllowNextPersonSettingModel allowNextPersonSettingModel, Map<String, Object> taskInfo) {
        Boolean dismissed = Boolean.FALSE;
        if (this.nodeIdType != null && this.nodeIdType.get(this.nodeIdForCurrent) != null) {
            this.logger.debug("GetWfAssignPersonsCmd.showFinalResult nodeIdType: " + this.nodeIdType);
            dismissed = this.nodeIdType.get(this.nodeIdForCurrent);
        }
        Boolean isWfAssignPersons = Boolean.FALSE;
        String allowNextPersonScene = null;
        String allowNextPersonWayAssign = null;
        String sceneNextNodeAssignValue = null;
        AllowNextPersonSetting allowNextPersonSetting = allowNextPersonSettingModel.getAllowNextPersonSetting();
        Boolean whetherOpenWindow = Boolean.FALSE;
        if (allowNextPersonSetting != null && allowNextPersonSettingModel.isAllowNextPersonWhenMatch()) {
            ParticipantSceneContext participantSceneContext = new ParticipantSceneContext(allowNextPersonSetting);
            allowNextPersonScene = participantSceneContext.getParticipantScene();
            whetherOpenWindow = this.whetherOpenWindow(allowNextPersonScene);
            this.logger.debug("GetWfAssignPersonsCmd.showFinalResult whetherOpenWindow: " + whetherOpenWindow + "allowNextPersonScene\uff1a" + allowNextPersonScene);
            if (whetherOpenWindow.booleanValue()) {
                sceneNextNodeAssignValue = participantSceneContext.getSceneNextNodeAssignValue();
                this.logger.debug("GetWfAssignPersonsCmd.showFinalResult sceneNextNodeAssignValue\uff1a" + sceneNextNodeAssignValue);
                boolean reEnter = this.isReEnter();
                whetherOpenWindow = this.procInstId != null && this.isInsideTask != null && this.isInsideTask != false && (dismissed != false || reEnter) ? Boolean.FALSE : participantSceneContext.getIsAllowOpenWinow(this.procInstId, this.procdefId, this.nodeIdForCurrent, this.dataEntity, this.commandContext, null);
                if (whetherOpenWindow.booleanValue()) {
                    allowNextPersonWayAssign = participantSceneContext.getParticipantWay();
                    this.logger.debug("GetWfAssignPersonsCmd.showFinalResult allowNextPersonWayAssign\uff1a" + allowNextPersonWayAssign);
                    if ("assign".equals(allowNextPersonScene)) {
                        if (StringUtils.isBlank((CharSequence)sceneNextNodeAssignValue)) {
                            throw new KDBizException(WFErrorCode.stopProcessWhenAfterPersonStrategyNotNodes(), new Object[0]);
                        }
                        LinkedHashMap<String, String> selectNodeInfo = new LinkedHashMap<String, String>();
                        if (StringUtils.isNotBlank((CharSequence)sceneNextNodeAssignValue)) {
                            Map nextNodeObject = (Map)SerializationUtils.fromJsonString((String)sceneNextNodeAssignValue, Map.class);
                            for (Map.Entry entry : nextNodeObject.entrySet()) {
                                String selectNodeId = (String)entry.getKey();
                                String selectNodeName = (String)entry.getValue();
                                selectNodeInfo.put(selectNodeId, selectNodeName);
                            }
                            String keyListValue = SerializationUtils.toJsonString(selectNodeInfo);
                            taskInfo.put("nodeassignvalues", keyListValue);
                        }
                    } else if ("only".equals(allowNextPersonScene)) {
                        if (taskInfo.get("RejectBackToSSCApprove") != null && ((Boolean)taskInfo.get("RejectBackToSSCApprove")).booleanValue()) {
                            whetherOpenWindow = Boolean.FALSE;
                            taskInfo.remove("RejectBackToSSCApprove");
                            this.logger.info("GetWfAssignPersonsCmd.showFinalResult whetherOpenWindow false because RejectBackToSSCApprove.");
                        } else {
                            List<IPreComputorRecordItem> preComputorRecordItemList = participantSceneContext.getPreComputorRecordItemList();
                            if (preComputorRecordItemList.size() > 0) {
                                IPreComputorRecordItem iPreComputorRecordItem = preComputorRecordItemList.get(0);
                                taskInfo.put("nextNodeId", iPreComputorRecordItem.getNodeId());
                                taskInfo.put("nextNodes", SerializationUtils.toJsonString(preComputorRecordItemList));
                                String nextNodeName = iPreComputorRecordItem.getNodeName().getLocaleValue();
                                if (preComputorRecordItemList.size() > 1 && this.isMob().booleanValue() || preComputorRecordItemList.size() == 1) {
                                    taskInfo.put("nextnodename", nextNodeName);
                                }
                            } else {
                                whetherOpenWindow = Boolean.FALSE;
                                this.logger.info("GetWfAssignPersonsCmd.showFinalResult whetherOpenWindow false because of preComputorRecordItemList is empty.");
                            }
                        }
                    }
                } else {
                    if (participantSceneContext.getPreComputorRecordItemList().size() == 0) {
                        participantSceneContext.setPreComputorRecordItemList(this.procInstId, this.procdefId, this.nodeIdForCurrent, this.dataEntity, this.commandContext, null);
                    }
                    this.checkSubmitRuls(participantSceneContext, allowNextPersonScene);
                }
            } else {
                Map<String, Object> afterPreComputorRecordItem = PreComputorHelper.getNextPreComputorRecordItem(this.procInstId, this.procdefId, this.dataEntity, this.commandContext, this.nodeIdForCurrent);
                List filterPreComputorRecordItemList = (List)afterPreComputorRecordItem.get("afternodes");
                this.checkSubmitRuls(participantSceneContext, allowNextPersonScene, filterPreComputorRecordItemList);
            }
            isWfAssignPersons = whetherOpenWindow;
        } else {
            boolean isStopSubmit = WfConfigurationUtil.isStopSubmitWhenNextPersonEmpty(this.formId);
            if (isStopSubmit) {
                try {
                    this.stopProcessWhenNextPersonEmpty();
                }
                catch (Exception exception) {
                    this.logger.warn("GetWfAssignPersonsCmd.showFinalResult Exception :" + exception.getMessage());
                    throw exception;
                }
            }
        }
        BusinessModelVariableScope variableScope = new BusinessModelVariableScope(this.dataEntity);
        Long schemeId = BpmnModelUtil.filterSchemeByProcdefId(this.commandContext, this.procdefId, variableScope);
        taskInfo.put("schemeid", schemeId);
        taskInfo.put("wfAssignPersons", isWfAssignPersons);
        taskInfo.put("procdefid", this.procdefId);
        taskInfo.put("nodeId", this.nodeIdForCurrent);
        taskInfo.put("procinstid", this.procInstId);
        taskInfo.put("participantscene", allowNextPersonScene);
        taskInfo.put("participantway", allowNextPersonWayAssign);
        return whetherOpenWindow;
    }

    private boolean isReEnter() {
        boolean isReEnter = false;
        if (WfUtils.isNotEmpty(this.procInstId) && WfUtils.isNotEmpty(this.nodeIdForCurrent) && this.isInsideTask != null && this.isInsideTask.booleanValue()) {
            Process process;
            UserTask firstUserTask;
            QFilter q3;
            QFilter q2;
            QFilter q1;
            HistoricActivityInstanceEntityManager hiActInstEntityManager = this.commandContext.getHistoricActivityInstanceEntityManager();
            List hiActInstEntities = hiActInstEntityManager.findByQueryFilters(new QFilter[]{q1 = new QFilter("processInstanceId", "=", (Object)this.procInstId), q2 = new QFilter("activityId", "=", (Object)this.nodeIdForCurrent), q3 = new QFilter("endTime", "is not null", null)});
            if (hiActInstEntities != null && hiActInstEntities.size() > 0) {
                isReEnter = true;
            }
            if (!isReEnter && (firstUserTask = BpmnModelUtil.getFirstUserTask(process = ProcessDefinitionUtil.getProcessByProcInstId(this.procInstId))) != null && WfUtils.isNotEmpty(this.nodeIdForCurrent) && this.nodeIdForCurrent.equals(firstUserTask.getId())) {
                isReEnter = true;
            }
        }
        return isReEnter;
    }

    private void stopProcessWhenNextPersonEmpty() {
        Map<String, Object> afterPreComputorRecordItem = PreComputorHelper.getNextPreComputorRecordItem(this.procInstId, this.procdefId, this.dataEntity, this.commandContext, this.nodeIdForCurrent);
        List preComputorRecordItemList = (List)afterPreComputorRecordItem.get("afternodes");
        if (preComputorRecordItemList != null && preComputorRecordItemList.size() > 0) {
            for (IPreComputorRecordItem preComputorRecordItem : preComputorRecordItemList) {
                List assigneeList = preComputorRecordItem.getAssignee();
                if (assigneeList.size() > 0) continue;
                String nodeType = preComputorRecordItem.getNodeType();
                String nodeName = preComputorRecordItem.getNodeName().getLocaleValue();
                if (!WfUtils.isEmptyForCollection(assigneeList) || !WfUtils.isAuditTypeNode(nodeType)) continue;
                this.throwEmptyException(nodeName);
            }
        }
    }

    private void throwEmptyException(String nodeName) {
        Process process;
        String procDefKey = null;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procdefId, this.procInstId);
        if (null != bpmnModel && null != (process = bpmnModel.getMainProcess())) {
            procDefKey = process.getNumber();
        }
        throw new KDBizException(WFErrorCode.stopProcessWhenNextPersonEmptyError(), new Object[]{procDefKey, nodeName});
    }

    public void checkSubmitRuls(ParticipantSceneContext participantSceneContext, String allowNextPersonScene) {
        this.checkSubmitRuls(participantSceneContext, allowNextPersonScene, null);
    }

    public void checkSubmitRuls(ParticipantSceneContext participantSceneContext, String allowNextPersonScene, List<IPreComputorRecordItem> preComputorRecordItemList) {
        if (preComputorRecordItemList == null) {
            preComputorRecordItemList = participantSceneContext.getPreComputorRecordItemList();
        }
        if (preComputorRecordItemList.size() > 0) {
            IPreComputorRecordItem iPreComputorRecordItem = preComputorRecordItemList.get(0);
            String nextNodeName = iPreComputorRecordItem.getNodeName().getLocaleValue();
            String nextNodeType = iPreComputorRecordItem.getNodeType();
            List nextAssignList = iPreComputorRecordItem.getAssignee();
            if (nextAssignList.size() == 0) {
                this.checkWFConfigRul(allowNextPersonScene, nextNodeType, nextNodeName);
            }
        }
        this.checkAssignPersonRul(preComputorRecordItemList);
    }

    private void checkWFConfigRul(String allowNextPersonScene, String nextNodeType, String emptyParticipantNodeName) {
        boolean isStopSubmit = WfConfigurationUtil.isStopSubmitWhenNextPersonEmpty(this.formId);
        if (WfUtils.isAuditTypeNode(nextNodeType) && isStopSubmit) {
            this.throwEmptyException(emptyParticipantNodeName);
        }
    }

    private void checkAssignPersonRul(List<IPreComputorRecordItem> preComputorRecordItemList) {
        AuditTask auditTask;
        ParticipantStrategy participantStrategy;
        BpmnModel bpmnModel;
        FlowElement flowElement;
        String nextNodeId = "";
        List assignList = new ArrayList();
        if (preComputorRecordItemList != null && preComputorRecordItemList.size() > 0) {
            IPreComputorRecordItem iPreComputorRecordItem = preComputorRecordItemList.get(0);
            assignList = iPreComputorRecordItem.getAssignee();
            nextNodeId = iPreComputorRecordItem.getNodeId();
        }
        if ((flowElement = (bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procdefId, this.procInstId)).getFlowElement(nextNodeId)) instanceof AuditTask && (participantStrategy = (auditTask = (AuditTask)flowElement).getParticipantStrategy()) != null) {
            Boolean isSinglePersonAssign = participantStrategy.isSingleParticipant();
            Boolean isEmptyparticipant = participantStrategy.isEmptyParticipant();
            if (isSinglePersonAssign != null && isSinglePersonAssign.booleanValue() || isEmptyparticipant != null && isEmptyparticipant.booleanValue()) {
                if (isSinglePersonAssign != null && isSinglePersonAssign.booleanValue() && assignList != null && assignList.size() > 1) {
                    throw new KDBizException(WFErrorCode.stopProcessWhenAfterPersonStrategyNotSingle(), new Object[0]);
                }
                if (isEmptyparticipant != null && isEmptyparticipant.booleanValue() && assignList != null && assignList.size() == 0) {
                    throw new KDBizException(WFErrorCode.stopProcessWhenAfterPersonStrategyIsEmpty(), new Object[0]);
                }
            }
        }
    }

    private AllowNextPersonSettingModel getAllowNextPersonSettingModel(boolean isFirstProcStart) {
        AllowNextPersonSettingModel allowNextPersonSettingModel;
        block4: {
            BpmnModel bpmnModel;
            block5: {
                allowNextPersonSettingModel = null;
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procdefId, this.procInstId);
                if (null == bpmnModel) break block4;
                Process process = bpmnModel.getMainProcess();
                if (!isFirstProcStart || null == process) break block5;
                allowNextPersonSettingModel = process.getAllowNextPersonSettingModel();
                UserTask userTask = BpmnModelUtil.getFirstUserTask(bpmnModel.getMainProcess());
                if (userTask == null) break block4;
                this.nodeIdForCurrent = userTask.getId();
                break block4;
            }
            if (WfUtils.isEmptyForMap(this.nodeIdType)) {
                return allowNextPersonSettingModel;
            }
            Set<String> set = this.nodeIdType.keySet();
            for (String this.nodeIdForCurrent : set) {
                FlowElement element = bpmnModel.getFlowElement(this.nodeIdForCurrent);
                if (!(element instanceof UserTask) || null == element) continue;
                UserTask userTask = (UserTask)element;
                String operation = userTask.getOperationStr();
                List<Object> operationList = new ArrayList<String>(4);
                if (operation.contains(",")) {
                    String[] operations = operation.split(",");
                    operationList = Arrays.asList(operations);
                } else {
                    operationList.add(operation);
                }
                if (!WfUtils.isNotEmpty(operation) || !operationList.contains(this.opKey) || null == (allowNextPersonSettingModel = userTask.getAllowNextPersonSettingModel()) || !allowNextPersonSettingModel.isAllowNextPersonWhenMatch()) continue;
                AllowNextPersonSetting allowNextPersonSetting = allowNextPersonSettingModel.getAllowNextPersonSetting();
                if (allowNextPersonSetting == null) break;
                Boolean reAssignPerson = allowNextPersonSetting.getReAssignPerson();
                this.isInsideTask = reAssignPerson == null ? Boolean.FALSE : reAssignPerson;
                break;
            }
        }
        return allowNextPersonSettingModel;
    }

    private boolean firstProcStart(String businessKey, Map<String, Object> rt) {
        boolean isProcStart = true;
        if (StringUtils.isBlank((CharSequence)businessKey) || "0".equalsIgnoreCase(businessKey)) {
            return isProcStart;
        }
        QFilter q1 = new QFilter("businesskey", "=", (Object)businessKey);
        QFilter[] filters = new QFilter[]{q1};
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)WF_TASK, (String)"handlestate,taskdefinitionkey,processinstanceid,processdefinitionid,category,active", (QFilter[])filters);
        if (null == tasks || 0 == tasks.length) {
            String entityNumber = (String)rt.get("formId");
            if (!this.checkIsFirstStartProc(businessKey, entityNumber)) {
                return false;
            }
            return isProcStart;
        }
        isProcStart = false;
        String taskKey = null;
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (DynamicObject task : tasks) {
            if (null == task || !task.getBoolean(ACTIVE) || !USERTASK.equals(task.get(CATEGORY))) continue;
            if (WfUtils.isEmpty(this.procdefId)) {
                this.procdefId = task.getLong("processdefinitionid");
            }
            if (WfUtils.isEmpty(this.procInstId)) {
                this.procInstId = task.getLong("processinstanceid");
                rt.put("procinstid", this.procInstId);
            }
            taskKey = task.getString("taskdefinitionkey");
            taskIds.add(task.getLong("id"));
            this.nodeIdType.put(taskKey, "dismissed".equals(task.getString("handlestate")));
        }
        rt.put("taskids", taskIds);
        this.logger.debug("GetWfAssignPersonsCmd.firstProcStart isProcStart:" + isProcStart + "; nodeIdType:" + this.nodeIdType);
        return isProcStart;
    }

    private boolean checkIsFirstStartProc(String businessKey, String formId) {
        boolean flag = true;
        QFilter qBusinessKey = new QFilter("businesskey", "=", (Object)businessKey);
        QFilter qEndTime = new QFilter("endtime", "is null", null);
        QFilter qEntityNumber = new QFilter("entitynumber", "=", (Object)formId);
        QFilter[] qFilters = new QFilter[]{qBusinessKey, qEndTime, qEntityNumber};
        Object[] procInstInfo = BusinessDataServiceHelper.load((String)"wf_hiprocinst", (String)"processdefinitionid,processinstanceid,processtype", (QFilter[])qFilters);
        if (procInstInfo != null && procInstInfo.length > 0 && procInstInfo[0].getLong("processinstanceid") != 0L) {
            this.logger.info("GetWfAssignPersonsCmd.checkIsFirstStartProc judge firstProcStart:{}", procInstInfo);
            flag = false;
        }
        return flag;
    }
}

