/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;
import kd.bos.workflow.engine.runtime.Execution;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class SignalEventReceivedCmd
implements Command<Void> {
    private Log logger = LogFactory.getLog(this.getClass());
    protected final String eventName;
    protected final Long executionId;
    protected final Map<String, Object> payload;
    protected final boolean async;
    protected String version;

    public SignalEventReceivedCmd(String eventName, Long executionId, Map<String, Object> processVariables) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.payload = processVariables != null ? new HashMap<String, Object>(processVariables) : null;
        this.async = false;
    }

    public SignalEventReceivedCmd(String eventName, boolean async, Map<String, Object> processVariables, String version) {
        this.eventName = eventName;
        this.async = async;
        this.executionId = null;
        this.payload = processVariables;
        this.version = version;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        try (TraceSpan tracer = Tracer.create((String)"WF_START", (String)WfTracerHelper.wrapTagValue("startEventReceived", this.eventName, this.version));){
            List<EventSubscriptionEntity> signalEvents = null;
            EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
            if (this.executionId == null) {
                signalEvents = eventSubscriptionEntityManager.findSignalEventSubscriptionsByEventName(this.eventName, this.version);
                this.logger.debug(String.format("find eventsubscription,size is %s", signalEvents == null ? 0 : signalEvents.size()));
            } else {
                ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
                if (execution == null) {
                    throw new WFObjectNotFoundException("Cannot find execution with id '" + this.executionId + "'", Execution.class);
                }
                if (execution.isSuspended()) {
                    throw new WFEngineException("Cannot throw signal event '" + this.eventName + "' because execution '" + this.executionId + "' is suspended");
                }
                signalEvents = eventSubscriptionEntityManager.findSignalEventSubscriptionsByNameAndExecution(this.eventName, this.executionId);
                this.logger.debug(String.format("find eventsubscription by executionId,size is %s", signalEvents == null ? 0 : signalEvents.size()));
                if (signalEvents == null || signalEvents.isEmpty()) {
                    throw new WFEngineException("Execution '" + this.executionId + "' has not subscribed to a signal event with name '" + this.eventName + "'.");
                }
            }
            if (null != signalEvents && !signalEvents.isEmpty()) {
                ArrayList<Long> procDefIds = new ArrayList<Long>(2);
                for (EventSubscriptionEntity signalEventSubscriptionEntity : signalEvents) {
                    if (procDefIds.contains(signalEventSubscriptionEntity.getProcessDefinitionId())) continue;
                    procDefIds.add(signalEventSubscriptionEntity.getProcessDefinitionId());
                    if (!(signalEventSubscriptionEntity instanceof SignalEventSubscriptionEntity) || !((SignalEventSubscriptionEntity)signalEventSubscriptionEntity).isGlobalScoped()) continue;
                    String businessKey = (String)this.payload.get("_businessKey_");
                    Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createSignalEvent(ActivitiEventType.ACTIVITY_SIGNALED, signalEventSubscriptionEntity.getActivityId(), this.eventName, this.payload, signalEventSubscriptionEntity.getExecutionId(), signalEventSubscriptionEntity.getProcessInstanceId(), signalEventSubscriptionEntity.getProcessDefinitionId(), businessKey));
                    eventSubscriptionEntityManager.eventReceived(signalEventSubscriptionEntity, this.payload, this.async);
                }
            }
        }
        return null;
    }
}

