/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.bpmn.model.ValuedDataObject;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentManager;
import kd.bos.workflow.engine.impl.util.ProcessInstanceHelper;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.engine.runtime.ProcessInstance;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class StartProcessInstanceCmd<T>
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected Long processDefinitionId;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected String businessKey;
    protected String processInstanceName;
    protected ProcessInstanceHelper processInstanceHelper;

    public StartProcessInstanceCmd(String processDefinitionKey, Long processDefinitionId, String businessKey, Map<String, Object> variables) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = variables;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        DeploymentManager deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinition = null;
        if (this.processDefinitionId != null) {
            processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
            if (processDefinition == null) {
                throw new WFObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
            }
        } else if (this.processDefinitionKey != null) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(this.processDefinitionKey);
            if (processDefinition == null) {
                throw new WFObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "'", ProcessDefinition.class);
            }
        } else {
            throw new WFIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
        }
        this.processInstanceHelper = commandContext.getProcessEngineConfiguration().getProcessInstanceHelper();
        ProcessInstance processInstance = this.createAndStartProcessInstance(processDefinition, this.businessKey, this.processInstanceName, this.variables, this.transientVariables);
        return processInstance;
    }

    protected ProcessInstance createAndStartProcessInstance(ProcessDefinition processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables) {
        return this.processInstanceHelper.createAndStartProcessInstance(processDefinition, businessKey, processInstanceName, variables, transientVariables);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

