/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.orm.ORM;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;

public class TryTriggerProcessByEventCmd
implements Command<List<JobEntity>>,
Serializable {
    private static final long serialVersionUID = -2244529801243383671L;
    private String[] billIds;
    private String entityNumber;
    private String eventNumber;
    private Map<String, Object> variables;

    public TryTriggerProcessByEventCmd(String[] billIds, String entityNumber, String eventNumber, Map<String, Object> variables) {
        this.billIds = billIds;
        this.entityNumber = entityNumber;
        this.eventNumber = eventNumber;
        this.variables = variables;
    }

    @Override
    public List<JobEntity> execute(CommandContext commandContext) {
        ArrayList<JobEntity> jobEntities = new ArrayList<JobEntity>();
        if (this.billIds == null || this.billIds.length == 0) {
            return jobEntities;
        }
        JobManager jobManager = commandContext.getJobManager();
        try (TraceSpan tracer = Tracer.create((String)"BIZTOWORKFLOW", (String)WfTracerHelper.wrapTagValue("TryTriggerProcessByEvent", this.entityNumber, this.eventNumber));){
            long[] ids = ORM.create().genLongIds("wf_job", this.billIds.length);
            for (int i = 0; i < this.billIds.length; ++i) {
                String billId = this.billIds[i];
                JobEntity job = jobManager.createEventAddressMessageJob(this.entityNumber, billId, this.eventNumber, this.variables);
                job.setId(ids[i]);
                jobEntities.add(job);
            }
        }
        return jobEntities;
    }
}

