/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class TryTriggerProcessByProcNumberCmd
implements Command<Void> {
    private String procNumber;
    private DynamicObject[] objs;
    private Map<String, Object> variables;
    private Log log = LogFactory.getLog(this.getClass());

    public TryTriggerProcessByProcNumberCmd(String procNumber, DynamicObject[] objs, Map<String, Object> variables) {
        this.procNumber = procNumber;
        this.objs = objs;
        this.variables = variables == null ? new HashMap(8) : variables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.objs == null || this.objs.length == 0) {
            this.log.debug("dynammicObjects is null or empty.");
            return null;
        }
        ProcessDefinitionEntity processDefinition = commandContext.getProcessDefinitionEntityManager().findLatestEnableProcessDefinitionByKey(this.procNumber);
        if (processDefinition == null) {
            this.log.debug(String.format("Cannot find the latest enabled process: %s", this.procNumber));
            return null;
        }
        String version = processDefinition.getVersion();
        String processType = processDefinition.getType();
        String entityNumber = this.objs[0].getDataEntityType().getName();
        String signalName = BizFlowUtil.getSignalEvent(processType, this.procNumber, entityNumber);
        try (TraceSpan tracer = Tracer.create((String)"BIZTOWORKFLOW", (String)WfTracerHelper.wrapTagValue("TryTriggerProcessByProcNumber", this.procNumber));){
            for (int i = 0; i < this.objs.length; ++i) {
                String businessKey = String.valueOf(this.objs[i].getPkValue());
                BusinessModelVariableScope bizScope = new BusinessModelVariableScope(businessKey, entityNumber);
                Long schemeId = BpmnModelUtil.filterSchemeByProcdefId(commandContext, processDefinition.getId(), bizScope);
                this.variables.put("_businessKey_", businessKey);
                this.variables.put("_entityNumber_", entityNumber);
                this.variables.put("_initiator_", this.getInitiatorId());
                this.variables.put("SCHEMEID", schemeId);
                this.variables.put("processType", processType);
                commandContext.getProcessEngineConfiguration().getRuntimeService().signalEventReceivedAsync(signalName, version, this.variables);
            }
        }
        return null;
    }

    private String getInitiatorId() {
        String initiator = (String)this.variables.get("_initiator_");
        if (WfUtils.isNotEmpty(initiator)) {
            return initiator;
        }
        return RequestContext.get().getUserId();
    }
}

