/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.startup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;

public class TryTriggerProcessCmd
implements Command<List<JobEntity>>,
Serializable {
    private static final long serialVersionUID = 6819137312945949955L;
    private String operation;
    private Map<String, Object> variables;
    private DynamicObject[] objs;

    public TryTriggerProcessCmd(DynamicObject[] objs, String operation, Map<String, Object> variables) {
        this.objs = objs;
        this.operation = operation;
        this.variables = variables;
    }

    @Override
    public List<JobEntity> execute(CommandContext commandContext) {
        ArrayList<JobEntity> jobEntitys = new ArrayList<JobEntity>();
        if (this.objs == null || this.objs.length == 0) {
            return jobEntitys;
        }
        String entityNumber = this.objs[0].getDataEntityType().getName();
        if (!WfUtils.isTesting() && entityNumber.startsWith("wf_tripreqbill_edit") && this.operation.equalsIgnoreCase("save")) {
            this.operation = "wf_" + this.operation;
        }
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>(16);
        }
        try (TraceSpan tracer = Tracer.create((String)"BIZTOWORKFLOW", (String)WfTracerHelper.wrapTagValue("TryTriggerProcess", entityNumber, this.operation));){
            long[] ids = ORM.create().genLongIds("wf_job", this.objs.length);
            for (int i = 0; i < this.objs.length; ++i) {
                JobEntity job;
                String billId = this.objs[i].getPkValue().toString();
                String billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, this.objs[i]);
                this.variables.put("_billno_", billNo);
                this.variables.put("jobId", ids[i]);
                if (this.variables.get("addressbusinesskey") != null && this.variables.get("addressbusinesskey").equals(billId)) {
                    this.variables.remove("addressbusinesskey");
                    job = commandContext.getJobManager().createAddressMessageJob(billId, this.operation, entityNumber, this.variables);
                } else {
                    HashMap<String, Object> variable = new HashMap<String, Object>(this.variables);
                    variable.remove("newprocessdefinitionid");
                    variable.remove("newschmeid");
                    job = commandContext.getJobManager().createAddressMessageJob(billId, this.operation, entityNumber, variable);
                }
                job.setId(ids[i]);
                jobEntitys.add(job);
            }
        }
        return jobEntitys;
    }
}

