/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.system;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.WFMessageServiceHelper;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.exception.WFEngineException;

public class SendMessageToAdminsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 3421698460468102069L;
    private static Log logger = LogFactory.getLog(SendMessageToAdminsCmd.class);
    private JobEntity job;
    private boolean suspend;
    private WFEngineException engineException;

    public SendMessageToAdminsCmd(JobEntity job, boolean suspend, WFEngineException engineException) {
        this.job = job;
        this.suspend = suspend;
        this.engineException = engineException;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.job == null) {
            logger.warn("\u5411\u6d41\u7a0b\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f\u524d\u53c2\u6570Job\u4e3anull");
            return null;
        }
        try {
            Set<Long> userIds = commandContext.getAdministratorEntityManager().findAdminsByProcessDefinitionId(this.job.getProcessDefinitionId());
            List<Long> userIdsFromAppEntry = WfAdminUtil.getUserIdsFromAppEntry(this.job.getProcessDefinitionId());
            userIds.addAll(userIdsFromAppEntry);
            if (userIds == null || userIds.isEmpty()) {
                String errorPerson = String.format(ResManager.loadKDString((String)"Job\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u76f8\u5173\u6d41\u7a0b\u7ba1\u7406\u5458\u3002", (String)"SendMessageToAdminsCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.job.getId());
                String errorOld = this.job.getExceptionMessage();
                String errorMsg = WfUtils.isEmptyString(errorOld) ? errorPerson : errorOld + " " + errorPerson;
                logger.debug(errorMsg);
                this.job.setExceptionMessage(errorMsg);
                return null;
            }
            MessageContext ctx = new MessageContext();
            ctx.setBusinessKey(this.job.getBusinessKey());
            ctx.setElementId(this.job.getElementId());
            ctx.setEntityNumber(this.job.getEntityNumber());
            ctx.setProcessDefinitionId(this.job.getProcessDefinitionId());
            ctx.setProcessInstanceId(this.job.getProcessInstanceId());
            MessageInfo msg = MessageServiceUtil.buildAlarmMessageInfo(this.job.getProcessInstanceId(), this.job.getElementId());
            msg.setUserIds(new ArrayList<Long>(userIds));
            msg.setMessageContent(this.getMessage(commandContext));
            msg.setEntityNumber("wf_deadletterjob");
            ctx.setEntityNumber("wf_deadletterjob");
            msg.setContentUrl(this.getContentUrl());
            msg.setBizDataId(Long.valueOf(this.job.getDynamicObject().getLong("rootjobid")));
            msg.setType("alarm");
            msg.setTplScene(MessageTypeEnum.ADMINALARM.getNumber());
            WFMessageServiceHelper.sendMessageToAdmins(ctx, msg);
            logger.debug(String.format("%s%s%s", "\u5411\u6d41\u7a0b\u7ba1\u7406\u5458\u3010", userIds.toString(), "\u3011\u53d1\u9001\u6d88\u606f\u6210\u529f"));
        }
        catch (Exception e) {
            logger.warn(String.format("job[%s]\u5411\u6d41\u7a0b\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f[%s]", this.job.getId(), e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private ILocaleString getMessage(CommandContext commandContext) {
        String errMsg;
        LocaleString message = new LocaleString();
        String string = errMsg = this.engineException == null ? "" : this.engineException.getMessage();
        if (this.suspend) {
            message = WfUtils.getPromptWordLocaleString("\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", "SendMessageToAdminsCmd_7", "bos-wf-engine");
        } else {
            ILocaleString multiLangValue = WfUtils.getPromptWordLocaleString("\u6d41\u7a0b\u5728\u6267\u884c\u8fc7\u7a0b\u4e2d\u51fa\u9519\u201c%s\u201d\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", "SendMessageToAdminsCmd_9", "bos-wf-engine");
            message = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{multiLangValue, new LocaleString(errMsg)});
        }
        ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.job.getExecutionId());
        if (executionEntity != null && ProcessType.AuditFlow.name().equals(executionEntity.getProcessType()) && executionEntity.getCurrentFlowElement() != null && "CallActivity".equals(executionEntity.getCurrentFlowElement().getType()) && WfUtils.isEmpty(executionEntity.getSubject()) && WfUtils.isNotEmpty(executionEntity.getParentId())) {
            executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(executionEntity.getParentId());
        }
        if (executionEntity != null && WfUtils.isNotEmpty(executionEntity.getSubject())) {
            ILocaleString subject = executionEntity.getSubject();
            ILocaleString billName = executionEntity.getEntraBillName();
            ILocaleString activityName = executionEntity.getActivityName();
            if (this.suspend) {
                ILocaleString multiLangValue = WfUtils.getPromptWordLocaleString("\u4e3b\u9898\u4e3a\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5df2\u5728\u201c%3$s\u201d\u6302\u8d77\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", "SendMessageToAdminsCmd_11", "bos-wf-engine");
                message = WfMultiLangUtils.getMultiLangValue(multiLangValue, subject, billName, activityName);
            } else {
                ILocaleString multiLangValue = WfUtils.getPromptWordLocaleString("\u4e3b\u9898\u4e3a\u201c%1$s\u201d\u7684\u201c%2$s\u201d\uff0c\u5728\u6267\u884c\u201c%3$s\u201d\u8fc7\u7a0b\u4e2d\u51fa\u9519\u201c%4$s\u201d\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", "SendMessageToAdminsCmd_13", "bos-wf-engine");
                message = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{multiLangValue, subject, billName, activityName, new LocaleString(errMsg)});
            }
        } else {
            ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(this.job.getProcessDefinitionId());
            if (processDefinitionEntity != null) {
                String key = processDefinitionEntity.getKey();
                String version = processDefinitionEntity.getVersion();
                if (this.suspend) {
                    ILocaleString multiLangValue = WfUtils.getPromptWordLocaleString("\u6d41\u7a0b\u201c%1$s\uff1a%2$s\u201d\u5df2\u6302\u8d77\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", "SendMessageToAdminsCmd_15", "bos-wf-engine");
                    message = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{multiLangValue, new LocaleString(key), new LocaleString(version)});
                } else {
                    ILocaleString multiLangValue = WfUtils.getPromptWordLocaleString("\u6d41\u7a0b\u201c%1$s\uff1a%2$s\u201d\u6267\u884c\u8fc7\u7a0b\u4e2d\u51fa\u9519\u201c%3$s\u201d\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", "SendMessageToAdminsCmd_17", "bos-wf-engine");
                    message = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{multiLangValue, new LocaleString(key), new LocaleString(version), new LocaleString(errMsg)});
                }
            }
        }
        return message;
    }

    private String getContentUrl() {
        String clientUrl = UrlService.getDomainContextUrl();
        StringBuilder urlWithEncodedParams = new StringBuilder(clientUrl);
        if (!clientUrl.trim().endsWith("/")) {
            urlWithEncodedParams.append("/");
        }
        urlWithEncodedParams.append("index.html?").append("&formId=wf_deadletterjob#/dform?formId=wf_deadletterjob").append("&pkId=").append(YunzhijiaCommonUtil.encode(String.valueOf(this.job.getId()))).append("&operationStatus=view");
        return urlWithEncodedParams.toString();
    }
}

