/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.system;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.system.DefaultMessageBuilder;
import kd.bos.workflow.engine.impl.cmd.system.entity.HandlerConfig;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.QueryWrapper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.runtime.Job;
import kd.bos.workflow.exception.WFEngineException;

public class SendMessageToCreator
implements Command<Void> {
    private static final Log log = LogFactory.getLog(SendMessageToCreator.class);
    private final Job job;
    private final WFEngineException exception;
    public static final String EMPTY = "empty";
    DeadLetterJobEntity deadLetterJob;

    public SendMessageToCreator(Job job, DeadLetterJobEntity deadLetterJob, WFEngineException exception) {
        this.job = job;
        this.exception = exception;
        this.deadLetterJob = deadLetterJob;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        Long processDefId = this.exception.getProcessDefId();
        if (processDefId == null) {
            return null;
        }
        if (!this.isRemind(processDefId)) {
            return null;
        }
        String configuration = this.job.getJobHandlerConfiguration();
        ObjectMapper JSON2 = new ObjectMapper();
        JSON2.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        HandlerConfig handlerConfig = new HandlerConfig();
        try {
            handlerConfig = (HandlerConfig)JSON2.readValue(configuration, HandlerConfig.class);
        }
        catch (JsonProcessingException e) {
            log.debug("json\u89e3\u6790\u5f02\u5e38\uff0c\u5c1a\u672a\u8986\u76d6\u5f53\u524d\u573a\u666f");
            return null;
        }
        String initiator = "";
        if (handlerConfig.getVariables() != null && handlerConfig.getVariables().getInitiator() != null) {
            initiator = handlerConfig.getVariables().getInitiator();
        } else if (handlerConfig.getRequestcontext() != null) {
            initiator = handlerConfig.getRequestcontext().getUserid();
        }
        MessageInfo messageInfo = new MessageInfo();
        String channels = this.findTplChannel("alarmNotation");
        ILocaleString content = this.buildContent();
        messageInfo.setMessageTitle(content);
        messageInfo.setMessageContent(content);
        if (EMPTY.equals(channels)) {
            messageInfo.setNotifyType("mcenter");
        } else {
            messageInfo.setNotifyType(channels);
            messageInfo.setTplScene("alarmNotation");
            if (channels.contains("yunzhijia")) {
                messageInfo.setPubaccNumber("flowassist");
            }
        }
        messageInfo.setEntityNumber("wf_deadletterjob");
        messageInfo.setBizDataId(this.job.getId());
        messageInfo.setUserIds((List)Lists.newArrayList((Object[])new Long[]{Long.valueOf(initiator)}));
        messageInfo.setMessageTag(WfUtils.getPromptWordLocaleString("\u5de5\u4f5c\u6d41", "MessageScheduleHelper_1", "bos-wf-engine"));
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        return null;
    }

    private boolean isRemind(Long processDefinitionId) {
        return ProcessDefinitionUtil.getBpmnModel(processDefinitionId, null, null).getMainProcess().getSuspendRemindSubmitter();
    }

    private ILocaleString buildContent() {
        LocaleString subject = new LocaleString("");
        LocaleString billType = new LocaleString("");
        String billno = "";
        if (this.deadLetterJob == null) {
            return DefaultMessageBuilder.build((ILocaleString)subject, (ILocaleString)billType, billno);
        }
        try {
            subject = this.deadLetterJob.getSubject();
            String entityNumber = this.deadLetterJob.getEntityNumber();
            DynamicObject billDef = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityNumber)});
            billType = billDef.getLocaleString("name");
            DynamicObject billInstance = BusinessDataServiceHelper.loadSingle((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(this.job.getBusinessKey()))});
            billno = billInstance.getString("billno");
            return DefaultMessageBuilder.build((ILocaleString)subject, (ILocaleString)billType, billno);
        }
        catch (Exception e) {
            return DefaultMessageBuilder.build((ILocaleString)subject, (ILocaleString)billType, billno);
        }
    }

    private String findTplChannel(String TplScene) {
        QFilter[] qFilters = new QueryWrapper().eq("msgscene", TplScene).eq("msgtype", "message").getQFilters();
        DynamicObjectCollection channels = QueryServiceHelper.query((String)"msg_template", (String)"msgchannel", (QFilter[])qFilters);
        if (channels.isEmpty()) {
            return EMPTY;
        }
        List msgChannels = channels.stream().map(item -> item.getString("msgchannel")).collect(Collectors.toList());
        String join = Joiner.on((char)',').join(msgChannels);
        return join;
    }
}

