/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.system;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.system.DefaultMessageBuilder;
import kd.bos.workflow.engine.impl.cmd.system.entity.UserIdAndProcessInstance;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.QueryWrapper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class SendMessageToStartUser
implements Command<Void> {
    public static final String EMPTY = "empty";
    private final JobEntity job;

    public SendMessageToStartUser(JobEntity job) {
        this.job = job;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        MessageInfo messageInfo = new MessageInfo();
        Long processInstanceId = this.job.getProcessInstanceId();
        ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId);
        if (executionEntity == null) {
            return null;
        }
        UserIdAndProcessInstance userIdAndProcessInstance = this.buildUserIdAndProcessInstance(executionEntity);
        if (!this.isRemind(userIdAndProcessInstance.getProcessInstance())) {
            return null;
        }
        messageInfo.setUserIds(userIdAndProcessInstance.getUserId());
        String channels = this.findTplChannel("alarmNotation");
        ILocaleString build = DefaultMessageBuilder.build(executionEntity.getSubject(), executionEntity.getEntraBillName(), executionEntity.getBillNo());
        messageInfo.setMessageContent(build);
        messageInfo.setMessageTitle(build);
        if (EMPTY.equals(channels)) {
            messageInfo.setNotifyType("mcenter");
        } else {
            messageInfo.setTplScene("alarmNotation");
            messageInfo.setNotifyType(channels);
            if (channels.contains("yunzhijia")) {
                messageInfo.setPubaccNumber("flowassist");
            }
        }
        messageInfo.setEntityNumber("wf_deadletterjob");
        messageInfo.setBizDataId(this.job.getRootJobId());
        messageInfo.setMessageTag(WfUtils.getPromptWordLocaleString("\u5de5\u4f5c\u6d41", "MessageScheduleHelper_1", "bos-wf-engine"));
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        return null;
    }

    private boolean isRemind(Long processInstanceId) {
        return ProcessDefinitionUtil.getBpmnModel(null, null, processInstanceId).getMainProcess().getSuspendRemindSubmitter();
    }

    private String findTplChannel(String TplScene) {
        QFilter[] qFilters = new QueryWrapper().eq("msgscene", TplScene).eq("msgtype", "message").getQFilters();
        DynamicObjectCollection channels = QueryServiceHelper.query((String)"msg_template", (String)"msgchannel", (QFilter[])qFilters);
        if (channels.isEmpty()) {
            return EMPTY;
        }
        List msgChannels = channels.stream().map(item -> item.getString("msgchannel")).collect(Collectors.toList());
        String join = Joiner.on((char)',').join(msgChannels);
        return join;
    }

    private UserIdAndProcessInstance buildUserIdAndProcessInstance(ExecutionEntity execution) {
        UserIdAndProcessInstance result = new UserIdAndProcessInstance();
        ExecutionEntity superExecution = execution.getSuperExecution();
        if (superExecution != null) {
            String processType = superExecution.getProcessType();
            if (ModelType.AuditFlow.name().equals(processType)) {
                result.setUserId(Lists.newArrayList((Object[])new Long[]{superExecution.getStartUserId()}));
                result.setProcessInstance(superExecution.getProcessInstanceId());
                return result;
            }
            if (ModelType.BizFlow.name().equals(processType)) {
                result.setUserId(Lists.newArrayList((Object[])new Long[]{execution.getStartUserId()}));
                result.setProcessInstance(execution.getProcessInstanceId());
                return result;
            }
        }
        result.setUserId(Lists.newArrayList((Object[])new Long[]{execution.getStartUserId()}));
        result.setProcessInstance(execution.getProcessInstanceId());
        return result;
    }
}

