/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.Attachment;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskInfo;

public class AddCommentEntityCmd
implements Command<Attachment> {
    private Comment comment;
    private Map<String, Object> attch;

    public AddCommentEntityCmd(Comment comment) {
        this.comment = comment;
    }

    public AddCommentEntityCmd(Comment comment, Map<String, Object> attch) {
        this.comment = comment;
        this.attch = attch;
    }

    @Override
    public Attachment execute(CommandContext commandContext) {
        Long taskId = this.comment.getTaskId();
        TaskInfo task = (TaskInfo)commandContext.getTaskEntityManager().findById(taskId);
        if (null == task) {
            task = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
        }
        CommentEntity commentEntity = (CommentEntity)this.comment;
        commentEntity.setProcessInstanceId(task.getProcessInstanceId());
        commentEntity.setActivityId(task.getTaskDefinitionKey());
        if (WfUtils.isEmpty(commentEntity.getGroupId())) {
            if (WfUtils.isNotEmpty(task.getParentTaskId())) {
                commentEntity.setGroupId(String.valueOf(task.getParentTaskId()));
            } else {
                commentEntity.setGroupId(taskId.toString());
            }
        }
        commentEntity.setResultNumber(this.comment.getResultNumber());
        if (WfUtils.isEmpty(commentEntity.getType())) {
            commentEntity.setType("suggestion");
        }
        Long userId = commentEntity.getUserId();
        if (WfUtils.isEmpty(commentEntity.getAssignee())) {
            ILocaleString userserName = WfUtils.findUserName(userId);
            commentEntity.setAssignee(userserName);
        }
        commentEntity.setResultName(this.comment.getCommentResult());
        commentEntity.setBusinessKey(task.getBusinessKey());
        commentEntity.setEntityNumber(task.getEntityNumber());
        commentEntity.setProcessType(task.getProcessType());
        commentEntity.setStep(commandContext.getCommentEntityManager().calculateStep(task.getProcessInstanceId()));
        commandContext.getCommentEntityManager().insert((CommentEntity)this.comment);
        WfOperationLogUtil.recordOperationLogFromComment(commandContext, commentEntity, null, null);
        if (this.attch != null && !this.attch.isEmpty()) {
            commandContext.getProcessEngineConfiguration().getTaskHelper().addHiAttachment(commentEntity, this.attch);
        }
        return null;
    }
}

