/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.AddYunzhijiaTaskParam;
import kd.bos.workflow.exception.WFException;

public class AddOneYunzhijiaCompletedChildTaskCmd
implements Command<Void> {
    private AddYunzhijiaTaskParam auditTaskParam;
    private HistoricProcessInstanceEntity procInstEntity;
    private String decisionType = "";
    private String resultNumber = "";
    private ILocaleString resultName = null;
    YunzhijiaTask yunzhijiaTask;

    public AddOneYunzhijiaCompletedChildTaskCmd(AddYunzhijiaTaskParam auditTaskParam) {
        this.auditTaskParam = auditTaskParam;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.auditTaskParam == null || WfUtils.isEmpty(this.auditTaskParam.getProcInstId()) || WfUtils.isEmpty(this.auditTaskParam.getActId()) || WfUtils.isEmpty(this.auditTaskParam.getAssigneeId()) || WfUtils.isEmpty(this.auditTaskParam.getAuditNumber()) || WfUtils.isEmpty(this.auditTaskParam.getApprovalMsg())) {
            throw new WFException(String.format("param has empty value, auditTaskParam=%s", this.auditTaskParam));
        }
        this.checkParam();
        HistoricTaskInstanceEntity parentTask = commandContext.getHistoricTaskInstanceEntityManager().findRecentlyParentTaskByActId(this.auditTaskParam.getProcInstId(), this.auditTaskParam.getActId());
        if (parentTask == null) {
            throw new WFException(String.format("not find parentTask, procInstId=%s,actId=%s", this.auditTaskParam.getProcInstId(), this.auditTaskParam.getActId()));
        }
        HistoricTaskInstanceEntity subTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("parentTaskId", "=", (Object)parentTask.getId())}).get(0);
        this.procInstEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.auditTaskParam.getProcInstId());
        HistoricTaskInstanceEntity newTaskInst = this.createHistoricTaskInst(commandContext, subTask);
        HistoricActivityInstanceEntity newActInst = this.createActInst(commandContext, subTask.getId(), newTaskInst);
        this.createHistoricIdentityLink(commandContext, newTaskInst);
        this.createComment(commandContext, newTaskInst, newActInst);
        return null;
    }

    private void checkParam() {
        boolean find = false;
        Process process = ProcessDefinitionUtil.getProcessByProcInstId(this.auditTaskParam.getProcInstId());
        if (process == null) {
            throw new KDBizException(String.format("process is null, procInstId=%s", this.auditTaskParam.getProcInstId()));
        }
        this.yunzhijiaTask = (YunzhijiaTask)process.getFlowElement(this.auditTaskParam.getActId());
        List<DecisionOption> decisionOptions = this.yunzhijiaTask.getDecisionOptions();
        for (DecisionOption decision : decisionOptions) {
            if (!this.auditTaskParam.getAuditNumber().equalsIgnoreCase(decision.getNumber())) continue;
            String multiKey = BpmnModelUtil.getDecisionNameMultiKey(this.yunzhijiaTask.getId(), decision.getId());
            this.resultName = BpmnModelUtil.getMultiLangFieldValue(this.auditTaskParam.getProcInstId(), multiKey, decision.getName());
            this.decisionType = decision.getAuditType();
            this.resultNumber = decision.getNumber();
            find = true;
            break;
        }
        if (!find) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u51b3\u7b56\u9879\u7f16\u7801\u4e0e\u8282\u70b9\u51b3\u7b56\u9879\u914d\u7f6e\u7684\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CompleteTaskCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
    }

    private HistoricIdentityLinkEntity createHistoricIdentityLink(CommandContext commandContext, HistoricTaskInstanceEntity newTaskInst) {
        HistoricIdentityLinkEntity historicIdentityLink = (HistoricIdentityLinkEntity)commandContext.getHistoricIdentityLinkEntityManager().create();
        historicIdentityLink.setType("participant");
        historicIdentityLink.setUserId(newTaskInst.getAssigneeId());
        historicIdentityLink.setUserName(newTaskInst.getTaskAssignee());
        historicIdentityLink.setTaskId(newTaskInst.getId());
        historicIdentityLink.setParenttaskid(newTaskInst.getParentTaskId());
        historicIdentityLink.setProcessInstanceId(newTaskInst.getProcessInstanceId());
        historicIdentityLink.setProcessDefId(newTaskInst.getProcessDefinitionId());
        historicIdentityLink.setEndTime(WfUtils.now());
        historicIdentityLink.setUserNameFormatter(newTaskInst.getTaskAssignee());
        historicIdentityLink.setDisplay(true);
        historicIdentityLink.setCurrenSubject(newTaskInst.getSubject());
        commandContext.getHistoricIdentityLinkEntityManager().insert(historicIdentityLink);
        return historicIdentityLink;
    }

    private HistoricActivityInstanceEntity createActInst(CommandContext commandContext, Long subTaskId, HistoricTaskInstanceEntity newTaskInst) {
        HistoricActivityInstanceEntity existedAct = commandContext.getHistoricActivityInstanceEntityManager().findActivityByTaskId(subTaskId);
        HistoricActivityInstanceEntity historicActivityInstance = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().create();
        historicActivityInstance.setExecutionType(existedAct.getExecutionType());
        historicActivityInstance.setTargetElementId(existedAct.getTargetElementId());
        historicActivityInstance.setCycle(existedAct.getCycle());
        historicActivityInstance.setSourceElementId(existedAct.getSourceElementId());
        historicActivityInstance.setLevel(existedAct.getLevel());
        historicActivityInstance.setActivityId(existedAct.getActivityId());
        historicActivityInstance.setAssigneeId(this.auditTaskParam.getAssigneeId());
        historicActivityInstance.setActivityName(existedAct.getActivityName());
        historicActivityInstance.setActivityType(existedAct.getActivityType());
        historicActivityInstance.setBizTraceNo(existedAct.getBizTraceNo());
        historicActivityInstance.setBusinessKey(existedAct.getBusinessKey());
        historicActivityInstance.setStep(existedAct.getStep());
        historicActivityInstance.setBillNo(existedAct.getBillNo());
        historicActivityInstance.setEntityNumber(existedAct.getEntityNumber());
        historicActivityInstance.setParentTaskId(existedAct.getParentTaskId());
        historicActivityInstance.setEndTime(WfUtils.now());
        historicActivityInstance.setForkPath(existedAct.getForkPath());
        historicActivityInstance.setJoinFlag(existedAct.getJoinFlag());
        historicActivityInstance.setProcessDefinitionId(existedAct.getProcessDefinitionId());
        historicActivityInstance.setProcessInstanceId(existedAct.getProcessInstanceId());
        historicActivityInstance.setTaskId(newTaskInst.getId());
        historicActivityInstance.setAssignee(newTaskInst.getTaskAssignee());
        commandContext.getHistoricActivityInstanceEntityManager().insert(historicActivityInstance);
        return historicActivityInstance;
    }

    private HistoricTaskInstanceEntity createHistoricTaskInst(CommandContext commandContext, HistoricTaskInstanceEntity subTask) {
        HistoricTaskInstanceEntityImpl taskEntity = (HistoricTaskInstanceEntityImpl)commandContext.getHistoricTaskInstanceEntityManager().create();
        taskEntity.setHandleState(this.decisionType);
        ILocaleString userName = WfUtils.findUserName(this.auditTaskParam.getAssigneeId());
        taskEntity.setParticipantName(userName);
        taskEntity.setCategory(subTask.getCategory());
        taskEntity.setExecutionType("byHand");
        taskEntity.setAssigneeId(this.auditTaskParam.getAssigneeId());
        taskEntity.setAssignee(userName);
        taskEntity.setPresentAssignee(subTask.getPresentAssignee());
        taskEntity.setProcessType(subTask.getProcessType());
        taskEntity.setTaskDefinitionKey(subTask.getTaskDefinitionKey());
        taskEntity.setBillNo(subTask.getBillNo());
        taskEntity.setControl(subTask.getControl());
        taskEntity.setEndType(subTask.getEndType());
        taskEntity.setEntityNumber(subTask.getEntityNumber());
        taskEntity.setEntityName(subTask.getEntityName());
        taskEntity.setFormKey(subTask.getFormKey());
        taskEntity.setMobileFormKey(subTask.getMobileFormKey());
        taskEntity.setName(subTask.getName());
        taskEntity.setOrgUnitId(this.procInstEntity.getMainOrgId());
        taskEntity.setOrgViewId(this.procInstEntity.getOrgViewId());
        taskEntity.setParentTaskId(subTask.getParentTaskId());
        taskEntity.setCategory(subTask.getCategory());
        taskEntity.setSource(subTask.getSource());
        taskEntity.setStarterId(subTask.getStarterId());
        taskEntity.setStartNameFormat(subTask.getStartNameFormat());
        taskEntity.setStartName(subTask.getStartName().getLocaleValue());
        taskEntity.setBillType(subTask.getBillType());
        taskEntity.setBusinessKey(subTask.getBusinessKey());
        taskEntity.setDisplay(subTask.isDisplay());
        taskEntity.setProcessingMobilePage(subTask.getProcessingMobilePage());
        taskEntity.setProcessingPage(subTask.getProcessingPage());
        taskEntity.setSenderId(subTask.getSenderId());
        taskEntity.setSenderName(subTask.getSenderName().getLocaleValue());
        taskEntity.setSenderNameFormat(subTask.getSenderNameFormat());
        taskEntity.setSubject(subTask.getSubject());
        taskEntity.setDeleteReason("task complete");
        taskEntity.setEndTime(WfUtils.now());
        taskEntity.setProcessDefinitionId(subTask.getProcessDefinitionId());
        taskEntity.setProcessInstanceId(subTask.getProcessInstanceId());
        commandContext.getHistoricTaskInstanceEntityManager().insert(taskEntity);
        return taskEntity;
    }

    private CommentEntity createComment(CommandContext commandContext, HistoricTaskInstanceEntity task, HistoricActivityInstanceEntity newActInst) {
        CommentEntity comment = (CommentEntity)commandContext.getCommentEntityManager().create();
        comment.setDecisionType(this.decisionType);
        comment.setResultNumber(this.resultNumber);
        comment.setResultName(this.resultName);
        comment.setExecutionType(task.getExecutionType());
        comment.setMessage(this.auditTaskParam.getApprovalMsg());
        comment.setType("comment");
        comment.setActivityId(task.getTaskDefinitionKey());
        comment.setProcessInstanceId(task.getProcessInstanceId());
        comment.setStep(newActInst.getStep());
        comment.setGroupId(String.valueOf(task.getParentTaskId()));
        comment.setHandleState(task.getHandleState());
        comment.setUserNameFormatter(task.getTaskAssignee());
        comment.setBillNo(task.getBillNo());
        comment.setProcessType(task.getProcessType());
        comment.setBusinessKey(task.getBusinessKey());
        comment.setTerminalWay(RequestContext.get().getClient());
        comment.setBackToBack(this.yunzhijiaTask.getBackToBackVote());
        comment.setBillType(task.getBillType());
        comment.setCategory(task.getCategory());
        comment.setCurrentSubject(task.getSubject());
        comment.setDisplay(task.isDisplay());
        comment.setEndType(task.getEndType());
        comment.setEntityName(task.getEntityName());
        comment.setStarterId(task.getStarterId());
        comment.setStartNameFormat(task.getStartNameFormat());
        comment.setStartName(task.getStartName());
        comment.setEntityNumber(task.getEntityNumber());
        comment.setPresentAssignee(task.getPresentAssignee());
        comment.setProcessingMobilePage(task.getProcessingMobilePage());
        comment.setProcessingPage(task.getProcessingPage());
        comment.setSenderName(task.getSenderName());
        comment.setSenderNameFormat(task.getSenderNameFormat());
        comment.setAssignee(task.getPresentAssignee());
        comment.setUserId(task.getAssigneeId());
        comment.setTaskId(task.getId());
        comment.setTime(WfUtils.now());
        comment.setActivityName(task.getName());
        commandContext.getCommentEntityManager().insert(comment);
        return comment;
    }
}

