/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntityManager;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.Attachment;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.ThirdCommentInfo;

public class AddTrdCommentEntityCmd
implements Command<Attachment> {
    private static final String IDVARIABLE = "id";
    private static final String NUMBER = "number";
    private static final String BOSUSER = "bos_user";
    private ThirdCommentInfo thirdCommentInfo;
    private boolean update = Boolean.FALSE;

    public AddTrdCommentEntityCmd(ThirdCommentInfo thirdCommentInfo) {
        this.thirdCommentInfo = thirdCommentInfo;
    }

    public AddTrdCommentEntityCmd(ThirdCommentInfo thirdCommentInfo, boolean update) {
        this.thirdCommentInfo = thirdCommentInfo;
        this.update = update;
    }

    @Override
    public Attachment execute(CommandContext commandContext) {
        Map attchments;
        String sourceSystem;
        String sourceApp;
        String resultNumber;
        ThirdCommentEntityManager thirdCommentEntityManager = commandContext.getTrdCommentEntityManager();
        ThirdCommentEntity trdComment = new ThirdCommentEntityImpl();
        trdComment.setId(this.thirdCommentInfo.getId());
        trdComment.setProcessInstanceId(this.thirdCommentInfo.getProcessInstanceId());
        if (WfUtils.isEmpty(trdComment.getId())) {
            trdComment.setId(DBServiceHelper.genGlobalLongId());
        }
        if (this.update) {
            trdComment = (ThirdCommentEntity)thirdCommentEntityManager.findById(this.thirdCommentInfo.getId());
        }
        Long taskId = this.thirdCommentInfo.getTaskId();
        trdComment.setTaskId(taskId);
        if (taskId != null) {
            TaskInfo task = (TaskInfo)commandContext.getTaskEntityManager().findById(taskId);
            if (task == null) {
                task = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
            }
            if (task != null) {
                trdComment.setProcessInstanceId(task.getProcessInstanceId());
                trdComment.setActivityId(task.getTaskDefinitionKey());
                if (WfUtils.isEmpty(trdComment.getGroupId())) {
                    if (WfUtils.isNotEmpty(task.getParentTaskId())) {
                        trdComment.setGroupId(String.valueOf(task.getParentTaskId()));
                    } else {
                        trdComment.setGroupId(taskId.toString());
                    }
                }
                trdComment.setBusinessKey(task.getBusinessKey());
                trdComment.setEntityNumber(task.getEntityNumber());
                trdComment.setStep(thirdCommentEntityManager.calculateStep(task.getProcessInstanceId()));
                trdComment.setActivityName(task.getName());
            } else {
                this.setInfosByNoTask(trdComment);
            }
        } else {
            this.setInfosByNoTask(trdComment);
        }
        Long userId = this.thirdCommentInfo.getUserId();
        String userNumber = this.thirdCommentInfo.getUserNum();
        if (StringUtils.isNotBlank((Object)userId)) {
            trdComment.setUserId(userId);
        } else if (StringUtils.isNotBlank((CharSequence)userNumber)) {
            userId = this.getUserIdByNumber(userNumber);
            trdComment.setUserId(userId);
        }
        if (trdComment.getUserId() != null && WfUtils.isNotEmpty(userId)) {
            ILocaleString userserName = WfUtils.findUserName(userId);
            trdComment.setAssignee(userserName);
        }
        if ((resultNumber = this.thirdCommentInfo.getResultNumber()) != null) {
            trdComment.setResultNumber(resultNumber);
        }
        String decisiontype = this.thirdCommentInfo.getDecisiontype();
        if (resultNumber != null) {
            trdComment.setDecisionType(decisiontype);
        }
        String resultName = this.thirdCommentInfo.getResultName();
        ILocaleString resultNameLocal = this.thirdCommentInfo.getResultNameLocale();
        if (resultNameLocal != null) {
            trdComment.setResultName(resultNameLocal);
        } else if (StringUtils.isNotBlank((CharSequence)resultName)) {
            ILocaleString resultNameVal = WfUtils.getMultiLangValue(resultName);
            trdComment.setResultName(resultNameVal);
        }
        Long auditTime = this.thirdCommentInfo.getAuditTime();
        Date dateTime = new Date();
        if (auditTime != null) {
            dateTime = new Date(auditTime);
        }
        trdComment.setTime(dateTime);
        String auditMessage = this.thirdCommentInfo.getAuditMesssage();
        ILocaleString auditMessageLocale = this.thirdCommentInfo.getAuditMessageLocale();
        if (auditMessageLocale != null) {
            trdComment.setMessage(auditMessageLocale);
        } else if (StringUtils.isNotBlank((CharSequence)auditMessage)) {
            ILocaleString auditMessageVal = WfUtils.getMultiLangValue(auditMessage);
            trdComment.setMessage(auditMessageVal);
        }
        String terminal = this.thirdCommentInfo.getTerminal();
        if (StringUtils.isNotBlank((CharSequence)terminal)) {
            trdComment.setTerminalWay(terminal);
        } else {
            trdComment.setTerminalWay("api");
        }
        String subactivityName = this.thirdCommentInfo.getSubactivityName();
        if (StringUtils.isNotBlank((CharSequence)subactivityName)) {
            trdComment.setSubactivityname(subactivityName);
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceApp = this.thirdCommentInfo.getSourceApp()))) {
            trdComment.setSourceApp(sourceApp);
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceSystem = this.thirdCommentInfo.getSourceSystem()))) {
            trdComment.setSourceSystem(sourceSystem);
        }
        trdComment.setType("suggestion");
        if (this.update) {
            thirdCommentEntityManager.update(trdComment);
        } else {
            thirdCommentEntityManager.insert(trdComment);
        }
        WfOperationLogUtil.recordOperationLogFromComment(commandContext, trdComment, null, null);
        if (this.update) {
            QFilter taskIdQFilter = new QFilter("contentid", "=", (Object)trdComment.getId());
            commandContext.getHistoricAttachmentEntityManager().deleteByFilters(new QFilter[]{taskIdQFilter});
        }
        if ((attchments = this.thirdCommentInfo.getAttchments()) != null && !attchments.isEmpty()) {
            HistoricAttachmentEntityManager entityManager = commandContext.getHistoricAttachmentEntityManager();
            for (Map.Entry attchment : attchments.entrySet()) {
                HistoricAttachmentEntity entity = (HistoricAttachmentEntity)entityManager.create();
                entity.setName((ILocaleString)attchment.getValue());
                entity.setUrlId((Long)attchment.getKey());
                entity.setContentId(trdComment.getId());
                entity.setType("comment");
                entity.setUserId(userId);
                entity.setTaskId(taskId);
                entity.setProcessInstanceId(this.thirdCommentInfo.getProcessInstanceId());
                entityManager.insert(entity);
            }
        }
        return null;
    }

    private void setInfosByNoTask(ThirdCommentEntity trdComment) {
        ILocaleString activityNameLocale;
        String group;
        String businesskey;
        String bizidentifykey = this.thirdCommentInfo.getBizidentifykey();
        if (StringUtils.isNotBlank((CharSequence)bizidentifykey)) {
            trdComment.setBizIdentifyKey(bizidentifykey);
        }
        if (StringUtils.isNotBlank((CharSequence)(businesskey = this.thirdCommentInfo.getBusinesskey()))) {
            trdComment.setBusinessKey(businesskey);
        }
        if (StringUtils.isNotBlank((CharSequence)(group = this.thirdCommentInfo.getGroup()))) {
            trdComment.setGroupId(group);
        }
        if (null != (activityNameLocale = this.thirdCommentInfo.getActivityNameLocale())) {
            trdComment.setActivityName(activityNameLocale);
            return;
        }
        String activityName = this.thirdCommentInfo.getActivityName();
        if (StringUtils.isNotBlank((CharSequence)activityName)) {
            activityNameLocale = new LocaleString(activityName);
            trdComment.setActivityName(activityNameLocale);
        }
    }

    public Long getUserIdByNumber(String userNumber) {
        if (StringUtils.isNotBlank((CharSequence)userNumber)) {
            ArrayList<String> userNumbers = new ArrayList<String>(1);
            userNumbers.add(userNumber);
            List<Long> userIds = this.getUserIdsByNumbers(userNumbers);
            if (userIds.isEmpty()) {
                return null;
            }
            return userIds.get(0);
        }
        return null;
    }

    public List<Long> getUserIdsByNumbers(List<String> userNumbers) {
        ArrayList<Long> userIds = new ArrayList<Long>(userNumbers.size());
        QFilter numberFilter = new QFilter(NUMBER, "in", userNumbers);
        QFilter[] numberFilters = new QFilter[]{numberFilter};
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)BOSUSER, (String)IDVARIABLE, (QFilter[])numberFilters);
        for (Map.Entry userEntry : userMap.entrySet()) {
            Long userId;
            DynamicObject userObject = (DynamicObject)userEntry.getValue();
            if (userObject == null || !StringUtils.isNotBlank((Object)(userId = Long.valueOf(userObject.getLong(IDVARIABLE))))) continue;
            userIds.add(userId);
        }
        return userIds;
    }
}

