/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskCoordinateRequestCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferDealWithCoordinateCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferDealWithSameUserCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TasksTransferEventParams;

public class AdminTransferTaskCmd
implements Command<Map<String, String>>,
Serializable {
    private static final long serialVersionUID = -4544432358434166458L;
    private String taskIds;
    private String originUserId;
    private String transferIds;
    private transient ILocaleString suggestion;
    private Boolean subscribe;
    private Boolean worksBatchTransfer = Boolean.FALSE;
    private List<TasksTransferEventParams> tasksTransferEventParams = new ArrayList<TasksTransferEventParams>();
    private transient Map<Long, ILocaleString> userInfo = new HashMap<Long, ILocaleString>();
    private Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
    private Boolean isAutoTransfer = Boolean.FALSE;

    public AdminTransferTaskCmd(String taskIds, String transferIds, ILocaleString suggestion, Boolean subscribe) {
        this.taskIds = taskIds;
        this.transferIds = transferIds;
        this.suggestion = suggestion;
        this.subscribe = subscribe;
    }

    public AdminTransferTaskCmd(String taskIds, String transferIds, ILocaleString suggestion, Boolean subscribe, Boolean isAutoTransfer) {
        this(taskIds, transferIds, suggestion, subscribe);
        this.isAutoTransfer = isAutoTransfer;
    }

    public AdminTransferTaskCmd(String taskIds, String originUserId, String transferIds, ILocaleString suggestion, Boolean subscribe, Boolean worksBatchTransfer) {
        this(taskIds, transferIds, suggestion, subscribe);
        this.originUserId = originUserId;
        this.worksBatchTransfer = worksBatchTransfer;
    }

    @Override
    public Map<String, String> execute(CommandContext commandContext) {
        StringBuilder resultsb = new StringBuilder();
        HashMap<String, String> results = new HashMap<String, String>();
        String[] taskIdsArray = this.taskIds.split(",");
        int success = 0;
        int fail = 0;
        ArrayList<String> failMsgList = new ArrayList<String>(taskIdsArray.length);
        ArrayList<String> successMsgList = new ArrayList<String>(taskIdsArray.length);
        if (taskIdsArray.length > 0) {
            for (String taskIdStr : taskIdsArray) {
                String result = "";
                Long taskId = Long.valueOf(taskIdStr);
                TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
                if (task != null) {
                    try {
                        result = this.transferTask(commandContext, task);
                    }
                    catch (Exception e) {
                        result = e.getMessage();
                    }
                    if ("OK".equals(result)) {
                        TaskHelper.dealWithCompositeTask(taskId);
                    }
                }
                if ("OK".equalsIgnoreCase(result)) {
                    ++success;
                    if (task == null) continue;
                    successMsgList.add(task.getBillNo() + " " + task.getName());
                    continue;
                }
                ++fail;
                if (task == null) {
                    failMsgList.add("task " + taskId + " is null");
                } else {
                    failMsgList.add(task.getBillNo() + " " + task.getName() + ":" + result);
                }
                resultsb.append(result).append("\r\n");
            }
        }
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Object> eventMap = new HashMap<String, Object>();
            eventMap.put("tasksTransferEventParams", this.tasksTransferEventParams);
            eventMap.put("transferOpinion", this.suggestion);
            eventMap.put("transferId", this.transferIds);
            eventMap.put("transferType", "AdminTransfer");
            new EventTriggerCmd(TaskEventTypeEnum.TASK_TRANSFER_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
        }
        String title = String.format(ResManager.loadKDString((String)"%1$s%2$s\u6761\u4efb\u52a1\uff0c\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"AdminTransferTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName(), taskIdsArray.length, success, fail);
        if (this.worksBatchTransfer != null && this.worksBatchTransfer.booleanValue()) {
            title = String.format(ResManager.loadKDString((String)"\u5171\u79fb\u4ea4%1$s\u6761\u5f85\u5904\u7406\u4efb\u52a1\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"AdminTransferTaskCmd_23", (String)"bos-wf-engine", (Object[])new Object[0]), taskIdsArray.length, success, fail);
        }
        StringBuilder details = new StringBuilder();
        if (resultsb.length() > 0) {
            details.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0:", (String)"AdminTransferTaskCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])).append((CharSequence)resultsb);
        }
        results.put("title", title);
        results.put("details", details.toString());
        results.put("failMsgList", Joiner.on((String)",").join(failMsgList));
        results.put("successMsgList", Joiner.on((String)",").join(successMsgList));
        return results;
    }

    private String transferTask(CommandContext commandContext, TaskEntity task) {
        String validationInfo;
        Long taskId = task.getId();
        List<Long> originUsers = this.getParticipantIdsByTaskId(commandContext, taskId);
        List<Long> currentParticipantIds = this.getCurrentParticipantIds();
        TasksTransferEventParams tasksTransferEventParam = new TasksTransferEventParams();
        tasksTransferEventParam.setTaskId(taskId);
        tasksTransferEventParam.setOwnerId(originUsers);
        tasksTransferEventParam.setBusinessKey(task.getBusinessKey());
        tasksTransferEventParam.setBillNo(task.getBillNo());
        tasksTransferEventParam.setEntityNumber(task.getEntityNumber());
        boolean autoCoordinateRecord = false;
        if (!WfUtils.isEmpty(this.originUserId)) {
            autoCoordinateRecord = CoordinateRecordUtil.isAutoCoordinateRecord(taskId, Long.valueOf(this.originUserId));
        }
        if (!("YunzhijiaTask".equals(task.getCategory()) && autoCoordinateRecord || WfUtils.isEmpty(validationInfo = this.getValidationInfo(currentParticipantIds, originUsers, task)))) {
            return validationInfo;
        }
        if (!WfUtils.isEmpty(this.originUserId) && autoCoordinateRecord) {
            this.transferCoordinateTask(commandContext, taskId, currentParticipantIds, Boolean.TRUE);
        } else if (!WfUtils.isEmpty(this.originUserId) && CoordinateRecordUtil.isCoordinateRecord(taskId, Long.valueOf(this.originUserId))) {
            this.transferCoordinateTask(commandContext, taskId, currentParticipantIds, Boolean.FALSE);
        } else {
            this.transferToHandleTask(commandContext, task, taskId, originUsers, currentParticipantIds);
        }
        if (this.worksBatchTransfer != null && Boolean.TRUE.equals(this.worksBatchTransfer) && !WfUtils.isEmpty(this.originUserId)) {
            commandContext.getWorksTransferLogEntityManager().insertWorksTransferLog(Long.valueOf(this.originUserId), this.transferIds, taskId, 0L, 0L, "", "task");
        }
        this.tasksTransferEventParams.add(tasksTransferEventParam);
        return "OK";
    }

    private void transferCoordinateTask(CommandContext commandContext, Long taskId, List<Long> currentParticipantIds, Boolean isAuto) {
        QFilter filter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter filter2 = new QFilter("type", "=", (Object)"coordinate");
        QFilter filter3 = new QFilter("userid", "=", (Object)Long.valueOf(this.originUserId));
        QFilter filter4 = new QFilter("ownerid", "!=", (Object)1L);
        if (isAuto.booleanValue()) {
            filter4 = new QFilter("ownerid", "=", (Object)1L);
        }
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3, filter4};
        List identityLinks = commandContext.getIdentityLinkEntityManager().findByQueryFilters(filters);
        if (identityLinks == null || identityLinks.isEmpty()) {
            return;
        }
        ILocaleString coordinateMsg = ((IdentityLinkEntity)identityLinks.get(0)).getTransferOpinion();
        Boolean isPublic = ((IdentityLinkEntity)identityLinks.get(0)).getIsPublic();
        for (Map.Entry entry : coordinateMsg.entrySet()) {
            String lang = (String)entry.getKey();
            coordinateMsg.setItem(lang, (Object)String.format((String)entry.getValue(), WfConfigurationUtil.getCoordinateNameByLanguage(lang)));
        }
        if (isAuto.booleanValue()) {
            Long ownerId = WfConstanst.ADMIN;
            new TaskCoordinateRequestCmd(taskId, Boolean.TRUE, Long.valueOf(this.originUserId), currentParticipantIds, coordinateMsg, ownerId, isPublic, isAuto, Boolean.TRUE).execute(commandContext);
        } else {
            new TaskCoordinateRequestCmd(taskId, Boolean.TRUE, Boolean.TRUE, currentParticipantIds, coordinateMsg, Long.valueOf(this.originUserId), isPublic).execute(commandContext);
        }
    }

    private void transferToHandleTask(CommandContext commandContext, final TaskEntity task, Long taskId, List<Long> originUsers, List<Long> currentParticipantIds) {
        new TaskTransferDealWithCoordinateCmd(taskId, this.transferIds, true).execute(commandContext);
        String orinignalParticipant = this.collectorOrinignalParticipant(commandContext, taskId);
        this.deleteOldTaskHandleLog(commandContext, taskId);
        List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
        for (IdentityLinkEntity identityLink : identityLinks) {
            if (!WfUtils.isNotEmpty(identityLink.getDelegateId())) continue;
            originUsers.remove(identityLink.getUserId());
        }
        new ResumeDelegateTasksCmd(taskId).execute(commandContext);
        IdentityLinkEntity identityLinkEntity = this.deleteOldIdentityLink(commandContext, task, this.transferIds);
        ArrayList<TaskHandleLogEntity> entities = null == currentParticipantIds ? new ArrayList<TaskHandleLogEntity>(0) : new ArrayList(currentParticipantIds.size());
        TaskHandleLogEntity entity = null;
        if (currentParticipantIds != null && !currentParticipantIds.isEmpty()) {
            for (Long transferId : currentParticipantIds) {
                entity = this.insertNewTaskHandleLog(task, transferId, commandContext, orinignalParticipant);
                entities.add(entity);
                this.insertNewIdentityLink(task, identityLinkEntity, transferId, commandContext);
            }
            if (null != entities && !entities.isEmpty()) {
                this.dispatchTransferEvent(entities, originUsers);
            }
            this.dealWithToDoInfo(taskId, originUsers, currentParticipantIds, commandContext);
        }
        commandContext.getHistoryManager().recordTaskParticipant(taskId, 0L, currentParticipantIds);
        String ownerId = this.originUserId != null ? this.originUserId : (originUsers == null ? Long.valueOf(0L) : originUsers.get(0));
        commandContext.getTaskEntityManager().updateYzjTaskMemberInfoVariables(commandContext, task, ownerId, this.transferIds);
        new TaskTransferDealWithSameUserCmd(taskId, currentParticipantIds).execute(commandContext);
        if (!task.isBizTask()) {
            final Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
            final String activitiId = task.getTaskDefinitionKey();
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("withdraw-transfer"){

                @Override
                public void closed(CommandContext commandContext) {
                    commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((UserTask)process.getFlowElement(activitiId), task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
                }
            });
        }
    }

    private String collectorOrinignalParticipant(CommandContext commandContext, Long taskId) {
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        List<TaskHandleLogEntity> taskHandleLogEntities = taskHandleLogEntityManager.findEntitiesByTaskIdAndType(taskId, "transfer");
        if (CollectionUtil.isNotEmpty(taskHandleLogEntities) && taskHandleLogEntities.get(0).getOriginalParticipant() != null) {
            return taskHandleLogEntities.get(0).getOriginalParticipant();
        }
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinksByTaskId(taskId);
        String orinignalParticipant = null;
        if (CollectionUtil.isNotEmpty(identityLinkEntitys)) {
            List userId = identityLinkEntitys.stream().map(identityLinkEntity -> String.valueOf(identityLinkEntity.getUserId())).collect(Collectors.toList());
            orinignalParticipant = userId.stream().collect(Collectors.joining(","));
        }
        return orinignalParticipant;
    }

    private String getValidationInfo(List<Long> currentParticipantIds, List<Long> originUsers, TaskEntity task) {
        if (null == originUsers) {
            return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"AdminTransferTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), task.getBillNo());
        }
        if (originUsers.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u6ca1\u6709\u53c2\u4e0e\u4eba\u3002", (String)"AdminTransferTaskCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), task.getBillNo());
        }
        for (Long currentParticipantId : currentParticipantIds) {
            if (!WfUtils.isEmpty(this.queryUserName(currentParticipantId))) continue;
            return String.format(ResManager.loadKDString((String)"\u4eba\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AdminTransferTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0]);
        }
        if (originUsers.size() == currentParticipantIds.size() && originUsers.containsAll(currentParticipantIds) && !this.isCoordinateRecord(task)) {
            return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u53c2\u4e0e\u4eba\u6ca1\u6709\u53d1\u751f\u53d8\u5316\u3002", (String)"AdminTransferTaskCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]), task.getBillNo());
        }
        if ("YunzhijiaTask".equals(task.getCategory()) && currentParticipantIds.size() > 1) {
            return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u662f\u4f1a\u5ba1\u8282\u70b9\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u591a\u4e2a\u53c2\u4e0e\u4eba\u3002", (String)"AdminTransferTaskCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), task.getBillNo());
        }
        if ("SSCApprove".equals(task.getCategory())) {
            return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u662f\u5171\u4eab\u5ba1\u6279\u8282\u70b9\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba\u3002", (String)"AdminTransferTaskCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), task.getBillNo());
        }
        return null;
    }

    private boolean isCoordinateRecord(TaskEntity task) {
        Long taskId = task.getId();
        if (WfUtils.isEmpty(this.originUserId)) {
            return false;
        }
        return CoordinateRecordUtil.isAutoCoordinateRecord(taskId, Long.valueOf(this.originUserId)) || CoordinateRecordUtil.isCoordinateRecord(taskId, Long.valueOf(this.originUserId));
    }

    private List<Long> getCurrentParticipantIds() {
        ArrayList<Long> currentParticipantIds = null;
        String[] transferIdsArray = this.transferIds.split(",");
        if (WfUtils.isNotEmptyForArrays(transferIdsArray)) {
            currentParticipantIds = new ArrayList(transferIdsArray.length);
            for (String transferId : transferIdsArray) {
                currentParticipantIds.add(Long.valueOf(transferId));
            }
        } else {
            currentParticipantIds = new ArrayList<Long>(1);
        }
        return currentParticipantIds;
    }

    private void deleteOldTaskHandleLog(CommandContext commandContext, Long taskId) {
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        QFilter taskFilter = new QFilter("taskId", "=", (Object)taskId);
        QFilter userFilter = new QFilter("ownerId", "=", (Object)this.currentUserId);
        QFilter typeFilter = new QFilter("type", "=", (Object)"transfer");
        taskHandleLogEntityManager.deleteByFilters(new QFilter[]{taskFilter, userFilter, typeFilter});
    }

    private IdentityLinkEntity deleteOldIdentityLink(CommandContext commandContext, TaskEntity task, String transferIds) {
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        HistoricIdentityLinkEntityManager hiUserMgr = commandContext.getHistoricIdentityLinkEntityManager();
        RuleTaskRelationEntityManager ruleMgr = commandContext.getRuleTaskRelationEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinksByTaskId(task.getId(), identityLinkEntityManager.getSelectFields());
        ArrayList<IdentityLinkEntity> newIdentityLinkEntitys = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntitys) {
            if (!"coordinate".equals(identityLinkEntity.getType()) || identityLinkEntity.getOwnerId() != 1L) {
                newIdentityLinkEntitys.add(identityLinkEntity);
            }
            if (!transferIds.contains(identityLinkEntity.getUserId().toString())) continue;
            newIdentityLinkEntitys.add(identityLinkEntity);
        }
        task.getIdentityLinks().removeAll(newIdentityLinkEntitys);
        IdentityLinkEntity identityLinkEntity = null;
        for (IdentityLinkEntity identity : newIdentityLinkEntitys) {
            if (identityLinkEntity == null) {
                identityLinkEntity = identity;
            }
            identityLinkEntityManager.delete(identity);
            hiUserMgr.delete(identity.getId());
            ruleMgr.deleteEntitiesByTaskIdAndTypeAndUserId(task.getId(), "coordinate", identity.getUserId().toString());
        }
        return identityLinkEntity;
    }

    private TaskHandleLogEntity insertNewTaskHandleLog(TaskEntity task, Long transferId, CommandContext commandContext, String orinignalParticipant) {
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        TaskHandleLogEntityImpl taskHandleLogEntity = new TaskHandleLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        taskHandleLogEntity.setAssigneeid(transferId);
        taskHandleLogEntity.setAssignee(this.queryUserName(transferId));
        taskHandleLogEntity.setOwnerId(this.currentUserId);
        taskHandleLogEntity.setCreateDate(date);
        taskHandleLogEntity.setModifyDate(date);
        taskHandleLogEntity.setType("transfer");
        taskHandleLogEntity.setTaskId(task.getId());
        if (this.suggestion != null && this.suggestion.toString() != null) {
            taskHandleLogEntity.setOpinion(this.suggestion);
        }
        if (this.subscribe != null) {
            taskHandleLogEntity.setSubscribe(this.subscribe);
        }
        taskHandleLogEntity.setProcessDefinitionId(task.getProcessDefinitionId());
        taskHandleLogEntity.setProcessInstanceId(task.getProcessInstanceId());
        taskHandleLogEntity.setBusinessKey(task.getBusinessKey());
        taskHandleLogEntity.setBillNo(task.getBillNo());
        taskHandleLogEntity.setIsadminforward(true);
        taskHandleLogEntity.setActivityId(task.getTaskDefinitionKey());
        taskHandleLogEntity.setActivityName(task.getName());
        taskHandleLogEntity.setOriginalParticipant(orinignalParticipant);
        taskHandleLogEntityManager.insert(taskHandleLogEntity);
        if (this.isAutoTransfer.booleanValue()) {
            taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u7cfb\u7edf\u81ea\u52a8\u8f6c\u4ea4", "AdminTransferTaskCmd_22", "bos-wf-engine"));
        } else if (this.worksBatchTransfer != null && this.worksBatchTransfer.booleanValue()) {
            taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u79fb\u4ea4\u5ba1\u6279\u4efb\u52a1", "AdminTransferTaskCmd_25", "bos-wf-engine"));
            taskHandleLogEntity.setOpinion(null);
        } else {
            taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba", "AdminTransferTaskCmd_21", "bos-wf-engine"));
        }
        WfOperationLogUtil.recordOperationLogFromTaskHandle(commandContext, taskHandleLogEntity, null, null);
        return taskHandleLogEntity;
    }

    private ILocaleString queryUserName(Long uid) {
        ILocaleString username = null;
        username = this.userInfo.get(uid);
        if (username != null) {
            return username;
        }
        username = WfUtils.findUserName(uid);
        this.userInfo.put(uid, username);
        return username;
    }

    private void insertNewIdentityLink(TaskEntity task, IdentityLinkEntity identityLinkEntity, Long transferId, CommandContext commandContext) {
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        IdentityLinkEntityImpl idety = new IdentityLinkEntityImpl();
        idety.setUserId(transferId);
        idety.setUserName(WfUtils.findUserName(transferId));
        ILocaleString participantDisplayInfo = ParticipantHelper.getParticipantDisplayInfo(task, Collections.singletonList(transferId)).get(transferId);
        idety.setUserNameFormatter(participantDisplayInfo);
        if (this.suggestion != null && this.suggestion.toString() != null) {
            idety.setTransferOpinion(this.suggestion);
        }
        if (identityLinkEntity != null) {
            idety.setParenttaskid(identityLinkEntity.getParenttaskid());
            idety.setProcessDefId(identityLinkEntity.getProcessDefId());
            idety.setTaskId(identityLinkEntity.getTaskId());
        }
        idety.setType("participant");
        idety.setProcessInstanceId(task.getProcessInstanceId());
        identityLinkEntityManager.insert(idety);
        task.getIdentityLinks().add(idety);
    }

    private void dispatchTransferEvent(List<TaskHandleLogEntity> entities, List<Long> originUsers) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (!eventDispatcher.isEnabled() || null == entities || entities.isEmpty()) {
            return;
        }
        eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_TRANSFER, entities));
    }

    private void dealWithToDoInfo(Long taskId, List<Long> originUsers, List<Long> transferIds, CommandContext commandContext) {
        ArrayList<Long> originUsersToDelete = new ArrayList<Long>();
        for (Long originUser : originUsers) {
            if (transferIds.contains(originUser)) continue;
            originUsersToDelete.add(originUser);
        }
        if (!originUsersToDelete.isEmpty()) {
            commandContext.getMessageService().deleteToDo(taskId, originUsersToDelete);
        }
        ArrayList<Long> transferIdsToCreate = new ArrayList<Long>();
        for (Long transferId : transferIds) {
            if (originUsers.contains(transferId)) continue;
            transferIdsToCreate.add(transferId);
        }
        if (!transferIdsToCreate.isEmpty()) {
            commandContext.getMessageService().createTransferToDo(taskId, transferIdsToCreate);
        }
    }

    private List<Long> getParticipantIdsByTaskId(CommandContext commandContext, Long taskId) {
        ArrayList<Long> ids = null;
        List<IdentityLinkEntity> participants = commandContext.getIdentityLinkEntityManager().findIdentityLinkByTaskIdAndType(taskId, "participant");
        if (participants != null && !participants.isEmpty()) {
            ids = new ArrayList<Long>(participants.size());
            for (IdentityLinkEntity participant : participants) {
                ids.add(participant.getUserId());
            }
        }
        return ids;
    }
}

