/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.FlowRecordUtil;

public class AllApprovalRecordCmd
implements Command<List<ApprovalRecordItem>> {
    private Log logger = LogFactory.getLog(this.getClass());
    protected Long processInstanceId;
    protected String businesskey;

    public AllApprovalRecordCmd(Long processInstanceId, String businesskey) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ApprovalRecordItem> execute(CommandContext commandContext) {
        this.logger.debug("\u5ba1\u6279\u8bb0\u5f55\uff0cbusinessKey\uff1a" + this.businesskey);
        try {
            if (!WfUtils.isNotEmpty(this.businesskey)) return this.getOperateLogItems(commandContext);
            if (!WfUtils.isEmpty(this.processInstanceId)) return this.getOperateLogItems(commandContext);
            String sql = "select a.FPROCINSTID proinstid from t_wf_hiprocinst a where a.FBUSINESSKEY = ? order by a.fcreatedate desc";
            Object[] params = new Object[]{this.businesskey};
            try (DataSet ds = DB.queryDataSet((String)"ApprovalRecord.t_wf_execution.queryExecutionInfo", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    this.processInstanceId = r.getLong("proinstid");
                    return this.getOperateLogItems(commandContext);
                }
                List<ApprovalRecordItem> list = Collections.emptyList();
                return list;
            }
        }
        catch (KDException e) {
            this.logger.warn(e.getStackTraceMessage());
            return Collections.emptyList();
        }
    }

    private List<ApprovalRecordItem> getOperateLogItems(CommandContext commandContext) {
        String fields = commandContext.getOperationLogEntityManager().getSelectFields();
        List<OperationLogEntity> entities = commandContext.getOperationLogEntityManager().findOperationLogByBusinessKey(this.businesskey, fields, "createdate,step");
        ILocaleString opinion = null;
        ArrayList<ApprovalRecordItem> approvalRecordItems = new ArrayList<ApprovalRecordItem>(0);
        for (OperationLogEntity entity : entities) {
            String commentId;
            Map<String, Object> attachmentInfo;
            ApprovalRecordItem item = new ApprovalRecordItem();
            item.setCommentId(String.valueOf(entity.getId()));
            item.setBizIdentifyKey(entity.getBizIdentifyKey());
            Long taskId = entity.getTaskId();
            item.setTaskId(String.valueOf(taskId));
            ILocaleString iLocaleString = opinion = WfUtils.isEmpty(entity.getNOpinion()) ? entity.getOpinion() : entity.getNOpinion();
            if (null != opinion) {
                item.setMessage(opinion.toString());
            }
            if ((attachmentInfo = FlowRecordUtil.getProcessAttachmentInfo(this.processInstanceId, taskId, commentId = String.valueOf(entity.getCommentId()))) != null && !attachmentInfo.isEmpty()) {
                item.setState((String)attachmentInfo.get("attachmentIds"));
                item.setAttachments((List)attachmentInfo.get("attachments"));
            }
            item.setGroupDecisionType(entity.getResultNumber());
            item.setResult(entity.getResultName().getLocaleValue());
            item.setDecisionType(entity.getDecisionType());
            Date time = entity.getCreateDate();
            if (time != null) {
                item.setTime(WfUtils.parseToUserZoneDateString(time));
                Date userZoneDate = WfUtils.getUserZoneDate(time);
                item.setFormatTime(userZoneDate.getTime());
                item.setFormatStrTime(new SimpleDateFormat("MM/dd HH:mm").format(userZoneDate));
            }
            item.setActivityId(entity.getActivityId());
            item.setActivityName(entity.getActivityName().getLocaleValue());
            String userid = entity.getAssigneeId();
            item.setUserStr(userid);
            item.setAssignee(entity.getAssignee().getLocaleValue());
            item.setOwnerId(entity.getOwnerId());
            item.setOwnerIdStr(String.valueOf(entity.getOwnerId()));
            item.setOwnerName(entity.getOwner().getLocaleValue());
            item.setType(entity.getType());
            item.setNodeType(entity.getActivityId());
            item.setTerminalWay(entity.getTerminalWay());
            item.setIsPublic(entity.getIsPublic());
            approvalRecordItems.add(item);
        }
        return approvalRecordItems;
    }
}

