/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.task.TaskInfo;
import org.apache.commons.lang.BooleanUtils;

public class AllTasksAllowCirculateCmd
implements Command<Boolean> {
    public static final String CIRCULATE = "circulate";
    private static final List<String> CHECK_CIRCLE_TYPE = ImmutableList.of((Object)"UserTask", (Object)"AuditTask", (Object)"YunzhijiaTask");
    private static final String[] TASK_SELECT_FIELDS = new String[]{"id", "taskDefinitionKey", "processInstanceId", "processDefinitionId", "category", "source", "control"};
    private static final String TASK_SELECT_FIELDS_JOIN = StringUtils.join((Object[])TASK_SELECT_FIELDS, (String)",");
    private List<Long> taskIds;
    private List<TaskInfo> tasks;

    public AllTasksAllowCirculateCmd(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    public AllTasksAllowCirculateCmd(List<Long> taskIds, List<TaskInfo> tasks) {
        this.taskIds = taskIds;
        this.tasks = tasks;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        if (this.tasks != null && !this.tasks.isEmpty()) {
            return this.isAllTasksAllowCirculate(commandContext);
        }
        return this.isAllTasksAllowCirculate(commandContext, this.taskIds);
    }

    private Boolean isAllTasksAllowCirculate(CommandContext commandContext) {
        return AllTasksAllowCirculateCmd.isAllTasksAllowCirculate(commandContext, Lists.newArrayList(), this.tasks);
    }

    public boolean isAllTasksAllowCirculate(CommandContext commandContext, List<Long> taskIds) {
        return AllTasksAllowCirculateCmd.isAllTasksAllowCirculate(commandContext, taskIds, Lists.newArrayList());
    }

    private static boolean isAllTasksAllowCirculate(CommandContext commandContext, List<Long> taskIds, List<TaskInfo> taskEntities) {
        AllTasksAllowCirculateCmd.handleTaskIds(commandContext, taskIds, taskEntities);
        return AllTasksAllowCirculateCmd.handleTaskType(taskEntities);
    }

    @Deprecated
    public static boolean isTaskAllowCirculate(CommandContext commandContext, Long taskId) {
        return AllTasksAllowCirculateCmd.isAllTasksAllowCirculate(commandContext, Lists.newArrayList((Object[])new Long[]{taskId}), Lists.newArrayList());
    }

    private static boolean handleTaskType(List<TaskInfo> taskEntities) {
        if (WfUtils.isEmptyForCollection(taskEntities)) {
            return Boolean.FALSE;
        }
        return taskEntities.stream().allMatch(AllTasksAllowCirculateCmd::isTaskNeedCheck);
    }

    private static void handleTaskIds(CommandContext commandContext, List<Long> taskIds, List<TaskInfo> taskEntities) {
        HistoricTaskInstanceEntityManager historyManager = commandContext.getHistoricTaskInstanceEntityManager();
        if (Objects.isNull(taskEntities)) {
            taskEntities = Lists.newArrayList();
        }
        if (taskEntities.isEmpty() && WfUtils.isNotEmptyForCollection(taskIds)) {
            EntityQueryBuilder queryBuilder = historyManager.createQueryBuilder().addFilter("id", "in", taskIds);
            queryBuilder.setSelectFields(TASK_SELECT_FIELDS_JOIN);
            List hisTasks = historyManager.findByQueryBuilder(queryBuilder);
            if (WfUtils.isNotEmptyForCollection(hisTasks)) {
                taskEntities.addAll(hisTasks);
            }
        }
    }

    private static boolean isTaskNeedCheck(TaskInfo taskInfo) {
        String control = taskInfo.getControl();
        if (WfUtils.isNotEmpty(control)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)control, Map.class);
            Object circulate = map.get(CIRCULATE);
            return Objects.nonNull(circulate) && BooleanUtils.toBoolean((String)((String)circulate));
        }
        String taskSource = taskInfo.getSource();
        if (!taskSource.equalsIgnoreCase("wf")) {
            return Boolean.FALSE;
        }
        String category = taskInfo.getCategory();
        return CHECK_CIRCLE_TYPE.contains(category);
    }
}

