/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.TaskInfo;

public class AllTasksAllowTransferCmd
implements Command<Boolean> {
    private static final Log log = LogFactory.getLog(AllTasksAllowTransferCmd.class);
    private List<Long> taskIds;
    private List<TaskInfo> tasks;

    public AllTasksAllowTransferCmd(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    public AllTasksAllowTransferCmd(List<Long> taskIds, List<TaskInfo> tasks) {
        this.taskIds = taskIds;
        this.tasks = tasks;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        if (this.tasks != null && !this.tasks.isEmpty()) {
            return this.isAllTasksAllowTransfer(commandContext, this.tasks);
        }
        return this.isAllTasksAllowTransfer(commandContext);
    }

    public boolean isAllTasksAllowTransfer(CommandContext commandContext) {
        boolean isAllTasksAllowTransfer = true;
        for (Long taskId : this.taskIds) {
            if (AllTasksAllowTransferCmd.isAllowTransfer(commandContext, taskId)) continue;
            isAllTasksAllowTransfer = false;
            break;
        }
        return isAllTasksAllowTransfer;
    }

    private Boolean isAllTasksAllowTransfer(CommandContext commandContext, List<TaskInfo> tasks) {
        boolean isAllTasksAllowTransfer = true;
        for (TaskInfo task : tasks) {
            if (AllTasksAllowTransferCmd.isAllowTransfer(commandContext, null, task)) continue;
            isAllTasksAllowTransfer = false;
            break;
        }
        return isAllTasksAllowTransfer;
    }

    public static boolean isAllowTransfer(CommandContext commandContext, Long taskId) {
        return AllTasksAllowTransferCmd.isAllowTransfer(commandContext, taskId, null);
    }

    private static boolean isAllowTransfer(CommandContext commandContext, Long taskId, TaskInfo taskEntity) {
        if (taskEntity == null && taskId != null) {
            taskEntity = (TaskInfo)commandContext.getTaskEntityManager().findById(taskId, String.format("%s,%s,%s,%s,%s,%s", "id", "taskDefinitionKey", "processInstanceId", "processDefinitionId", "category", "control"));
        }
        boolean isAllowTransfer = false;
        if (taskEntity != null) {
            String category;
            BpmnModel bpmnModel;
            String control = taskEntity.getControl();
            if (StringUtils.isNotBlank((CharSequence)control)) {
                Map map = (Map)SerializationUtils.fromJsonString((String)control, Map.class);
                Object transfer = map.get("transfer");
                return transfer != null && (Boolean)transfer != false;
            }
            Long processInstanceId = taskEntity.getProcessInstanceId();
            try {
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(taskEntity.getProcessDefinitionId(), processInstanceId);
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
                return Boolean.FALSE;
            }
            String currentActivityId = taskEntity.getTaskDefinitionKey();
            switch (category = taskEntity.getCategory()) {
                case "UserTask": {
                    UserTask userTask = (UserTask)bpmnModel.getFlowElement(currentActivityId);
                    isAllowTransfer = userTask.isAllowTransfer();
                    break;
                }
                case "AuditTask": {
                    AuditTask auditTask = (AuditTask)bpmnModel.getFlowElement(currentActivityId);
                    isAllowTransfer = auditTask.isAllowTransfer();
                    break;
                }
                case "YunzhijiaTask": {
                    YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)bpmnModel.getFlowElement(currentActivityId);
                    isAllowTransfer = yunzhijiaTask.isAllowTransfer();
                    break;
                }
                case "BillTask": {
                    BillTask billTask = (BillTask)bpmnModel.getFlowElement(currentActivityId);
                    isAllowTransfer = billTask.isAllowTransfer();
                    break;
                }
            }
        }
        return isAllowTransfer;
    }
}

