/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.ApprovalRecordCmd;
import kd.bos.workflow.engine.impl.cmd.task.ApprovalRecordOptimizationCmd;
import kd.bos.workflow.engine.impl.cmd.task.GetAutoCoordinatorRecordCmd;
import kd.bos.workflow.engine.impl.cmd.task.GetCoordinatorRecordByTaskIdsCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.SignatureUtils;

public class ApprovalRecordInclCoordinateCmd
implements Command<List<IApprovalRecordGroup>> {
    private String businessKey;
    private static final String AUTO_COORDINATE = "autoCorrdinate";
    private static final String MANUAL_COORDINATE = "manualCorrdinate";

    public ApprovalRecordInclCoordinateCmd(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public List<IApprovalRecordGroup> execute(CommandContext commandContext) {
        Object aRecordGroups = new ArrayList(0);
        if (WfConfigurationUtil.disableApprovalRecordOptimization()) {
            ApprovalRecordCmd aReocrdcmd = new ApprovalRecordCmd(null, this.businessKey);
            aRecordGroups = aReocrdcmd.execute(commandContext);
        } else {
            ApprovalRecordOptimizationCmd cmd = new ApprovalRecordOptimizationCmd(null, this.businessKey);
            aRecordGroups = cmd.execute(commandContext);
        }
        Iterator iterator = aRecordGroups.iterator();
        while (iterator.hasNext()) {
            IApprovalRecordGroup group = (IApprovalRecordGroup)iterator.next();
            List approRecords = group.getChildren();
            String groupIdStr = group.getGroup();
            long groupId = Long.parseLong(groupIdStr);
            Object autoCoorRecords = new GetAutoCoordinatorRecordCmd(groupId).execute(commandContext);
            this.setCoorRecordType((List<IApprovalRecordItem>)autoCoorRecords, 0);
            approRecords.addAll(autoCoorRecords);
            List<Long> taskIds = this.getGroupTaskIds(approRecords);
            Object manualCoorRecords = new GetCoordinatorRecordByTaskIdsCmd(taskIds).execute(commandContext);
            this.setCoorRecordType((List<IApprovalRecordItem>)manualCoorRecords, 1);
            approRecords.addAll(manualCoorRecords);
            SignatureUtils.handleApprovalRecordApiSignature(approRecords);
        }
        return aRecordGroups;
    }

    private void setCoorRecordType(List<IApprovalRecordItem> autoCoorRecords, int type) {
        for (IApprovalRecordItem autoRecord : autoCoorRecords) {
            if (type == 0) {
                autoRecord.setType(AUTO_COORDINATE);
                continue;
            }
            if (type != 1) continue;
            autoRecord.setType(MANUAL_COORDINATE);
        }
    }

    private List<Long> getGroupTaskIds(List<IApprovalRecordItem> approRecords) {
        HashSet<Long> taskIdsSet = new HashSet<Long>(16);
        for (IApprovalRecordItem approRecord : approRecords) {
            String taskIdStr = approRecord.getTaskId();
            if (WfUtils.isEmpty(taskIdStr)) continue;
            long taskId = Long.parseLong(taskIdStr);
            taskIdsSet.add(taskId);
        }
        return new ArrayList<Long>(taskIdsSet);
    }
}

