/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.impl.cmd.procinst.GetParentProcessInstanceInfoCmd;
import kd.bos.workflow.engine.impl.cmd.task.ApprovalRecordCmd;
import kd.bos.workflow.engine.impl.cmd.task.ApprovalRecordOptimizationCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;

public class ApprovalRecordSupportAllCmd
implements Command<List<IApprovalRecordGroup>> {
    private String businesskey;
    private String entityNumber;
    private boolean allRecord;
    private List<HistoricProcessInstanceEntity> entities;

    public ApprovalRecordSupportAllCmd(String businesskey, String entityNumber, boolean allRecord, List<HistoricProcessInstanceEntity> entities) {
        this.businesskey = businesskey;
        this.entityNumber = entityNumber;
        this.allRecord = allRecord;
        this.entities = entities;
    }

    @Override
    public List<IApprovalRecordGroup> execute(CommandContext commandContext) {
        if (null == this.entities || this.entities.isEmpty()) {
            this.entities = new GetParentProcessInstanceInfoCmd(this.businesskey, this.entityNumber, "processinstanceid,processdefinitionid,createdate,endtype", "createdate", !this.allRecord).execute(commandContext);
        }
        if (null == this.entities || this.entities.isEmpty()) {
            return null;
        }
        ArrayList<IApprovalRecordGroup> approvalRecordGroups = new ArrayList<IApprovalRecordGroup>(this.entities.size());
        Object approvalRecordGroupsChild = null;
        Long processInstanceId = null;
        for (HistoricProcessInstanceEntity entity : this.entities) {
            if (null == entity) {
                return null;
            }
            processInstanceId = entity.getProcessInstanceId();
            Long procDefId = entity.getProcessDefinitionId();
            String endType = entity.getEndType();
            approvalRecordGroupsChild = WfConfigurationUtil.disableApprovalRecordOptimization() ? new ApprovalRecordCmd(processInstanceId, this.businesskey, procDefId, endType).execute(commandContext) : new ApprovalRecordOptimizationCmd(processInstanceId, this.businesskey, procDefId, endType).execute(commandContext);
            if (null == approvalRecordGroupsChild || approvalRecordGroupsChild.isEmpty()) continue;
            approvalRecordGroups.addAll((Collection<IApprovalRecordGroup>)approvalRecordGroupsChild);
        }
        return approvalRecordGroups;
    }
}

