/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.BatchCompleteTask;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class BatchAuditByBusinessKeysCmd
implements Command<Map<String, Object>> {
    protected List<String> businessIds;
    protected Map<String, Object> variables;

    public BatchAuditByBusinessKeysCmd(List<String> businessKeys, Map<String, Object> param) {
        this.businessIds = businessKeys;
        this.variables = param;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap<String, Long> successIds = new HashMap<String, Long>();
        HashMap<String, String> checkedIds = new HashMap<String, String>();
        ArrayList<String> errorInfos = new ArrayList<String>();
        boolean paramError = true;
        if (this.variables != null && WfUtils.isNotEmptyForCollection(this.businessIds)) {
            Object pAuditUserId = this.variables.get("auditUserId");
            Object pBatchOpType = this.variables.get("batchOpType");
            if (pAuditUserId != null && pBatchOpType != null) {
                paramError = false;
                StringBuilder taskIds = new StringBuilder();
                Long userId = Long.parseLong(pAuditUserId.toString());
                String ids = WfUtils.listToStringWithQuotes(this.businessIds, ",");
                StringBuilder sql1 = new StringBuilder();
                sql1.append("select a.fbusinesskey,b.ftaskid from t_wf_execution a left join t_wf_participant b on a.fid=b.fprocinstid ");
                sql1.append("where a.fprocesstype='AuditFlow' and a.fisscope='1' and b.ftype='participant' and a.fbusinesskey in (");
                sql1.append(ids);
                sql1.append(") and b.fuserid=? ");
                try (DataSet ds = DB.queryDataSet((String)"BatchAuditByBusinessKeys1", (DBRoute)DBRoute.workflow, (String)sql1.toString(), (Object[])new Object[]{userId});){
                    for (Object row : ds) {
                        Long taskId = row.getLong("ftaskid");
                        String businessKey = row.getString("fbusinesskey");
                        taskIds.append(",").append(taskId);
                        successIds.put(businessKey, taskId);
                    }
                }
                String taskIdsStr = taskIds.toString();
                if (!successIds.isEmpty()) {
                    Object row;
                    StringBuilder sql2 = new StringBuilder();
                    sql2.append("select fid,fbusinesskey from t_wf_task where fid in (").append(taskIds.substring(1)).append(") ");
                    if ("approve".equals(pBatchOpType)) {
                        sql2.append("and fbatchop not like '1-%' ");
                    }
                    if ("reject".equals(pBatchOpType)) {
                        sql2.append("and fbatchop not like '%-1' ");
                    }
                    DataSet ds = DB.queryDataSet((String)"BatchAuditByBusinessKeys2", (DBRoute)DBRoute.workflow, (String)sql2.toString());
                    row = null;
                    try {
                        for (Row row2 : ds) {
                            String businessKey = row2.getString("fbusinesskey");
                            Long fid = row2.getLong("fid");
                            successIds.remove(businessKey);
                            checkedIds.put(businessKey, businessKey);
                            if ("approve".equals(pBatchOpType)) {
                                errorInfos.add(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5904\u7406\u5931\u8d25\uff0c\u4e0d\u80fd\u6279\u91cf\u540c\u610f\u3002", (String)"BatchAuditByBusinessKeysCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), businessKey));
                            }
                            if ("reject".equals(pBatchOpType)) {
                                errorInfos.add(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5904\u7406\u5931\u8d25\uff0c\u4e0d\u80fd\u6279\u91cf\u9a73\u56de\u3002", (String)"BatchAuditByBusinessKeysCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), businessKey));
                            }
                            taskIdsStr = taskIdsStr.replace("," + fid, "");
                        }
                    }
                    catch (Throwable throwable) {
                        row = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ds != null) {
                            if (row != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)row).addSuppressed(throwable);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                }
                if (taskIdsStr.length() > 0) {
                    new BatchCompleteTask(taskIdsStr.substring(1), null, false, this.variables).execute(commandContext);
                }
                ArrayList<String> successIdList = new ArrayList<String>();
                for (String s : this.businessIds) {
                    if (successIds.containsKey(s)) {
                        successIdList.add(s);
                        continue;
                    }
                    if (checkedIds.containsKey(s)) continue;
                    errorInfos.add(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4efb\u52a1\u3002", (String)"BatchAuditByBusinessKeysCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), s));
                }
                ret.put("successIds", WfUtils.listToString(successIdList, ","));
                ret.put("errorInfos", errorInfos);
            }
        }
        if (paramError) {
            errorInfos.add(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatchAuditByBusinessKeysCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            ret.put("errorInfos", errorInfos);
        }
        return ret;
    }
}

