/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.TaskHelper;

public class BatchComplateConvertTasks
implements Command<String> {
    private Log logger = LogFactory.getLog(this.getClass());
    private Long taskId;
    private boolean compensation = false;

    public BatchComplateConvertTasks(Long taskId, boolean compensation) {
        this.taskId = taskId;
        this.compensation = compensation;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (this.compensation) {
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
            if (task == null) {
                String error = String.format("task[%s] is not exist,it is handled.", this.taskId);
                this.logger.warn(error);
                return error;
            }
            long currentUserId = Long.parseLong(RequestContext.get().getUserId());
            taskHelper.addComment(task.getId(), task.getProcessInstanceId(), currentUserId, "converted", null);
            taskHelper.completeTaskWithOutContinue(task, currentUserId, new HashMap<String, Object>(), true);
            this.logger.debug(String.format("finish bizflow task[%s]", task.getId()));
        }
        return null;
    }
}

