/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.BatchComplateMCTasks;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.TaskHelper;

public class BatchComplateCustomTasksCmd
extends BatchComplateMCTasks
implements Command<String> {
    private Log logger = LogFactory.getLog(this.getClass());
    private Long[] taskids;
    private Long userId;
    private ILocaleString opinion;
    private Map<String, Object> variables;
    private boolean verify = false;
    private boolean compensation = false;

    public BatchComplateCustomTasksCmd(List<Long> taskIds, Long userId, ILocaleString opinion, boolean verify, Map<String, Object> variables) {
        if (taskIds != null && taskIds.size() > 0) {
            this.taskids = new Long[taskIds.size()];
            for (int i = 0; i < taskIds.size(); ++i) {
                this.taskids[i] = taskIds.get(i);
            }
        }
        this.userId = userId;
        this.opinion = opinion;
        this.verify = verify;
        this.variables = variables;
    }

    public BatchComplateCustomTasksCmd(Long[] taskids, Long userId, boolean compensation, Map<String, Object> variables) {
        this.taskids = taskids;
        this.compensation = compensation;
        this.variables = variables;
        this.userId = userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(CommandContext commandContext) {
        JSONArray successIds = new JSONArray();
        int failedCount = 0;
        int successCount = 0;
        int taskBalance = 0;
        StringBuilder failedBillnos = new StringBuilder();
        List<TaskEntity> tasks = null;
        if (this.compensation) {
            tasks = super.getTaskEntityList(commandContext, this.compensation, null, this.taskids);
            if (tasks == null || tasks.isEmpty()) {
                return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u5df2\u5904\u7406\u3002", (String)"BatchCompleteTask_6", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskids[0]);
            }
            super.handleTaskWhenCompensation(commandContext, tasks, this.variables, this.userId);
            return null;
        }
        if (!super.checkTasks(this.taskids, null)) {
            return null;
        }
        try {
            tasks = super.getTaskEntityList(commandContext, this.compensation, null, this.taskids);
            int resultSize = tasks.size();
            taskBalance = this.taskids.length - resultSize;
            this.variables = super.getVariables(commandContext, this.variables, this.opinion, this.userId);
            Map<String, Object> map = super.setTaskComplate(commandContext, tasks, this.verify, this.variables, failedBillnos, successIds);
            failedCount += ((Integer)map.get("failedCount")).intValue();
            successCount += ((Integer)map.get("successCount")).intValue();
            StringBuilder handleTaskNotice = (StringBuilder)map.get("handleTaskNotice");
            List taskEntityList = (List)map.get("taskEntityList");
            try {
                TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
                boolean async = tasks.size() > 1;
                taskHelper.quickBatchCompleteTask(taskEntityList, super.getUserId(this.userId), async);
                this.variables.put("updateQuantitySummaryDone", Boolean.TRUE);
                this.variables.put("savedLogMark", "true");
                taskHelper.planBatchCompensationTaskJob(taskEntityList, this.variables);
                taskHelper.addOperationLogForTasks(commandContext, taskEntityList, this.variables, this.userId);
            }
            catch (Exception e) {
                ++failedCount;
                handleTaskNotice.append(e.getMessage());
                this.logger.error(String.format("\u6279\u91cf\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
            }
            if (handleTaskNotice.length() > 0) {
                WfUtils.addOpLog("wf_task", "submit", new MultiLangEnumBridge("\u63d0\u4ea4\u5ba1\u6279\u4efb\u52a1", "BatchCompleteTask_4", "bos-wf-engine"), new MultiLangEnumBridge("\u7cfb\u7edf\u5f02\u5e38\uff1a%s", "BatchCompleteTask_9", "bos-wf-engine"), handleTaskNotice.toString());
            }
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
        finally {
            super.removeTaskCacheSign(this.taskids, null);
        }
        return super.getResultOfTaskComplate(taskBalance, failedCount, successCount, successIds, failedBillnos, tasks);
    }
}

